/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.cognosns;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class MembershipCache {
    private static final String PUBLIC_TENANT_ID = "";
    private final HashMap<String, HashMap> memberCaches = new HashMap();

    public void addMember(BaseClass object, String objectTenantID, BaseClass member, String memberTenantID) {
        HashMap<BaseClass, LinkedHashSet<BaseClassProxy>> memberCache = this.memberCaches.get(memberTenantID);
        if (memberCache == null) {
            memberCache = new HashMap<BaseClass, LinkedHashSet<BaseClassProxy>>();
            this.memberCaches.put(memberTenantID, memberCache);
        }
        LinkedHashSet<BaseClassProxy> theMemberList = (LinkedHashSet<BaseClassProxy>)memberCache.get(member);
        BaseClassProxy baseClassProxy = new BaseClassProxy(objectTenantID, object);
        if (theMemberList == null) {
            theMemberList = new LinkedHashSet<BaseClassProxy>();
            theMemberList.add(baseClassProxy);
            memberCache.put(member, theMemberList);
        } else {
            theMemberList.add(baseClassProxy);
        }
    }

    private void expandMembership(LinkedHashSet<BaseClass> theMembership, BaseClass camID, String tenantID) {
        LinkedHashSet<BaseClass> directMembership = this.getDirectMemberOf(camID, tenantID);
        if (directMembership == null) {
            return;
        }
        for (BaseClass currentCamID : directMembership) {
            theMembership.add(currentCamID);
            this.expandMembership(theMembership, currentCamID, tenantID);
        }
    }

    public LinkedHashSet<BaseClass> getCompleteMembershipOf(BaseClass camID, String tenantID) {
        LinkedHashSet<BaseClass> membership = new LinkedHashSet<BaseClass>();
        this.expandMembership(membership, camID, tenantID);
        if (membership.size() == 0) {
            return null;
        }
        return membership;
    }

    public LinkedHashSet<BaseClass> getDirectMemberOf(BaseClass camID, String tenantID) {
        HashSet<String> cacheTenants = new HashSet<String>();
        ArrayList<HashMap> caches = new ArrayList<HashMap>();
        if (this.memberCaches.containsKey(PUBLIC_TENANT_ID)) {
            cacheTenants.add(PUBLIC_TENANT_ID);
            caches.add(this.memberCaches.get(PUBLIC_TENANT_ID));
        }
        if (!PUBLIC_TENANT_ID.equals(tenantID) && this.memberCaches.containsKey(tenantID)) {
            cacheTenants.add(tenantID);
            caches.add(this.memberCaches.get(tenantID));
        }
        LinkedHashSet<BaseClass> directMemberOf = new LinkedHashSet<BaseClass>();
        for (HashMap cache : caches) {
            LinkedHashSet tenantDirectMemeberOf = (LinkedHashSet)cache.get(camID);
            if (tenantDirectMemeberOf == null) continue;
            for (BaseClassProxy baseClass : tenantDirectMemeberOf) {
                if (!cacheTenants.contains(baseClass.tenantID)) continue;
                directMemberOf.add(baseClass.baseClass);
            }
        }
        if (directMemberOf.size() == 0) {
            return null;
        }
        return directMemberOf;
    }

    private final class BaseClassProxy {
        private final String tenantID;
        private final BaseClass baseClass;

        private BaseClassProxy(String theTenantID, BaseClass theBaseClass) {
            this.tenantID = theTenantID;
            this.baseClass = theBaseClass;
        }
    }
}

