/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.common;

import com.ibm.cognos.camaaa.internal.admin.common.QueryCMForNSInitialization;
import com.ibm.cognos.camaaa.internal.admin.soap.Directory;
import com.ibm.cognos.camaaa.internal.admin.soap.DirectoryImpl;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessorHTTP;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.util.CAMEncoder;
import com.ibm.cognos.camaaa.internal.common.util.LocaleUtil;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class QueryCMForNSInitializationImpl
implements QueryCMForNSInitialization {
    private static final String SOAP_ENVELOPE_CLOSING_TAG = "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String QUERY_RESULT_ITEM_XPATH_EXPRESSION = "/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']";
    private static final XPath NAME_ITEMS_XPATH_EXPRESSION = DocumentHelper.createXPath((String)"/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='name']/*[local-name()='value']/*");
    private static final XPath NAMESPACE_FORMAT_XPATH_EXPRESSION = DocumentHelper.createXPath((String)"/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='queryResponse']/*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='namespaceFormat']/*[local-name()='value']");
    private static final String SOAP_ENVELOPE_OPENING_TAG = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
    private static final String ADD_NAMESPACE_SUCCESS_XPATH_EXPRESSION = "/*[local-name()='Envelope']/*[local-name()='Body']/*[local-name()='addNamespaceResponse']/*[local-name()='result']/*[local-name()='item']/*[local-name()='defaultName']/*[local-name()='value']";
    private static final String CLASS_NAME = QueryCMForNSInitializationImpl.class.getName();
    private static final int QUERY_CM_MAXIMUM_ATTEMPTS = 4;
    private static final long QUERY_CM_ATTEMPT_DELAY = 1000L;
    private ICMAccessor cmAccessor;

    public QueryCMForNSInitializationImpl() throws LocalizableException {
        this(CMAccessor.getInstance());
    }

    public QueryCMForNSInitializationImpl(ICMAccessor theCmAccessor) {
        this.cmAccessor = theCmAccessor;
    }

    @Override
    public void addNamespaceToCM(String namespaceId, String defaultName, String namespaceFormat, String[] capabilities) throws LocalizableException {
        block10: {
            StringBuilder cmAddRequest = new StringBuilder();
            cmAddRequest.append(SOAP_ENVELOPE_OPENING_TAG);
            cmAddRequest.append(" <SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header><SOAP-ENV:Body>");
            cmAddRequest.append("<cm1:addNamespace xmlns:cm1=\"http://developer.cognos.com/schemas/contentManagerService/1\">");
            cmAddRequest.append("<parentPath xsi:type=\"bus:searchPathSingleObject\">/directory</parentPath>");
            cmAddRequest.append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">");
            cmAddRequest.append("<item xsi:type=\"bus:namespace\">");
            cmAddRequest.append("<defaultName xsi:type=\"bus:stringProp\">");
            cmAddRequest.append("<value xsi:type=\"xsd:string\">");
            cmAddRequest.append(CAMEncoder.encode1((String)defaultName));
            cmAddRequest.append("</value></defaultName>");
            cmAddRequest.append("<id xsi:type=\"bus:stringProp\">");
            cmAddRequest.append("<value xsi:type=\"xsd:string\">");
            if (namespaceId == null || namespaceId.isEmpty()) {
                cmAddRequest.append(":");
            } else {
                cmAddRequest.append(CAMEncoder.encode2((String)CAMEncoder.decodeQuote((String)namespaceId)));
            }
            cmAddRequest.append("</value></id>");
            cmAddRequest.append("<active xsi:type=\"booleanProp\">");
            cmAddRequest.append("<value xsi:type=\"boolean\">true</value></active>");
            cmAddRequest.append("<namespaceFormat xsi:type=\"bus:anyURIProp\">");
            cmAddRequest.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">");
            cmAddRequest.append(namespaceFormat);
            cmAddRequest.append("</value></namespaceFormat>");
            cmAddRequest.append("<capabilities xsi:type=\"bus:nmtokenArrayProp\">");
            cmAddRequest.append("<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"xsd:string[");
            cmAddRequest.append(capabilities == null ? 0 : capabilities.length);
            cmAddRequest.append("]\">");
            if (capabilities != null) {
                for (String aCapability : capabilities) {
                    cmAddRequest.append("<item xsi:type=\"xsd:string\">");
                    cmAddRequest.append(aCapability);
                    cmAddRequest.append("</item>");
                }
            }
            cmAddRequest.append("</value></capabilities>");
            cmAddRequest.append("</item></objects><options xsi:type=\"bus:addOptions\">");
            cmAddRequest.append("<updateAction xsi:type=\"bus:updateActionEnum\">update</updateAction>");
            cmAddRequest.append("</options></cm1:addNamespace>");
            cmAddRequest.append(SOAP_ENVELOPE_CLOSING_TAG);
            String response = null;
            try {
                response = this.cmAccessor.invoke(cmAddRequest.toString());
                if (response != null) {
                    Document responseDoc;
                    SAXReader reader = new SAXReader();
                    try {
                        responseDoc = reader.read((Reader)new StringReader(response));
                    }
                    catch (DocumentException e) {
                        throw new InternalErrorException(CLASS_NAME);
                    }
                    String value = DocumentHelper.valueOf((String)ADD_NAMESPACE_SUCCESS_XPATH_EXPRESSION, (Node)responseDoc.getRootElement());
                    if (value != null && value.length() > 0 && !defaultName.equals(value)) {
                        throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_ADD_NS_RESPONSE_ERROR", (Object[])new String[]{defaultName, value == null ? "null" : value}));
                    }
                    break block10;
                }
                throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_CM_NOT_INITIALIZED"));
            }
            catch (SoapFaultException sfe) {
                String errorCodeString = sfe.getErrorCodeString();
                if ("cmInStandByMode".equals(errorCodeString)) break block10;
                throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_ADD_NS_RESPONSE_ERROR", (Object[])new String[]{defaultName, namespaceId == null ? "null" : namespaceId}), (Throwable)sfe);
            }
        }
    }

    private String callActiveCm(StringBuffer cmRequest) throws LocalizableException, InternalErrorException, SoapFaultException {
        String response = null;
        ICMAccessor theCmAccessor = this.cmAccessor;
        SoapFaultException failure = null;
        for (int attempt = 0; attempt < 4; ++attempt) {
            block5: {
                try {
                    response = null;
                    response = theCmAccessor.invoke(cmRequest.toString());
                }
                catch (SoapFaultException sfe) {
                    failure = sfe;
                    String errorCodeString = sfe.getErrorCodeString();
                    if (!"cmInStandByMode".equals(errorCodeString)) break block5;
                    theCmAccessor = new CMAccessorHTTP(CMAccessorHTTP.getActiveCM(this.cmAccessor));
                    continue;
                }
            }
            if (response != null) break;
            this.sleep(1000L);
        }
        if (failure != null && response == null) {
            throw failure;
        }
        if (response == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_CM_NOT_INITIALIZED"));
        }
        return response;
    }

    @Override
    public Directory createAncestorDirectory() throws LocalizableException {
        Document responseDoc;
        StringBuffer cmRequest = new StringBuffer();
        cmRequest.append(SOAP_ENVELOPE_OPENING_TAG);
        cmRequest.append(" <SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header><SOAP-ENV:Body>");
        cmRequest.append("<bus:query><search xsi:type=\"xsd:string\">/directory");
        cmRequest.append("</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">");
        cmRequest.append("<item xsi:type=\"cm:propEnum\">name</item></properties></bus:query>");
        cmRequest.append("</SOAP-ENV:Body></SOAP-ENV:Envelope> ");
        String response = this.callActiveCm(cmRequest);
        SAXReader reader = new SAXReader();
        try {
            responseDoc = reader.read((Reader)new StringReader(response));
        }
        catch (DocumentException e) {
            throw new InternalErrorException(CLASS_NAME);
        }
        List nameItems = DocumentHelper.selectElements((XPath)NAME_ITEMS_XPATH_EXPRESSION, (Node)responseDoc);
        DirectoryImpl directory = new DirectoryImpl();
        for (int i = 0; i < nameItems.size(); ++i) {
            String localeStr = DocumentHelper.valueOf((String)"./*[local-name()='locale']", (Node)((Element)nameItems.get(i)));
            Locale locale = LocaleUtil.createContentLocale((String)localeStr, null);
            String value = DocumentHelper.valueOf((String)"./*[local-name()='value']", (Node)((Element)nameItems.get(i)));
            directory.addName(locale, value);
        }
        return directory;
    }

    @Override
    public void deleteNamespaceFromCM(String namespaceId) throws LocalizableException {
        block5: {
            StringBuilder cmDeleteRequest = new StringBuilder();
            cmDeleteRequest.append(SOAP_ENVELOPE_OPENING_TAG);
            cmDeleteRequest.append(" <SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header><SOAP-ENV:Body>");
            cmDeleteRequest.append("<cm1:deleteNamespace xmlns:cm1=\"http://developer.cognos.com/schemas/contentManagerService/1\">");
            cmDeleteRequest.append("<id xsi:type=\"xsd:string\">");
            if (namespaceId == null || namespaceId.isEmpty()) {
                cmDeleteRequest.append(":");
            } else {
                cmDeleteRequest.append(CAMEncoder.encode2((String)CAMEncoder.decodeQuote((String)namespaceId)));
            }
            cmDeleteRequest.append("</id></cm1:deleteNamespace>");
            cmDeleteRequest.append(SOAP_ENVELOPE_CLOSING_TAG);
            String response = null;
            try {
                response = this.cmAccessor.invoke(cmDeleteRequest.toString());
                if (response == null) {
                    throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_CM_NOT_INITIALIZED"));
                }
            }
            catch (SoapFaultException sfe) {
                String errorCodeString = sfe.getErrorCodeString();
                if ("cmInStandByMode".equals(errorCodeString)) break block5;
                throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_DELETE_NS_ERROR", (Object[])new String[]{namespaceId == null ? "null" : namespaceId}), (Throwable)sfe);
            }
        }
    }

    @Override
    public String retrieveNamespaceFormatFromCM(String namespaceId) throws LocalizableException {
        String namespaceFormat = null;
        StringBuffer cmRequest = new StringBuffer();
        cmRequest.append(SOAP_ENVELOPE_OPENING_TAG);
        cmRequest.append("<SOAP-ENV:Header><bus:biBusHeader/></SOAP-ENV:Header>");
        cmRequest.append("<SOAP-ENV:Body><bus:query><search xsi:type=\"xsd:string\">CAMID(\"");
        cmRequest.append(CAMEncoder.encode2((String)CAMEncoder.decodeQuote((String)namespaceId)));
        cmRequest.append("\")</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[1]\">");
        cmRequest.append("<item xsi:type=\"cm:propEnum\">namespaceFormat</item></properties></bus:query>");
        cmRequest.append(SOAP_ENVELOPE_CLOSING_TAG);
        String response = this.callActiveCm(cmRequest);
        if (response != null) {
            Document responseDoc;
            SAXReader reader = new SAXReader();
            try {
                responseDoc = reader.read((Reader)new StringReader(response));
            }
            catch (DocumentException e) {
                throw new InternalErrorException(CLASS_NAME);
            }
            String value = DocumentHelper.valueOf((XPath)NAMESPACE_FORMAT_XPATH_EXPRESSION, (Node)responseDoc.getRootElement());
            namespaceFormat = value != null && value.length() > 0 ? value : "http://developer.cognos.com/schemas/CAM/AAANamespaceFormat/3/";
        } else {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_CM_NOT_INITIALIZED"));
        }
        return namespaceFormat;
    }

    private void sleep(long time) throws InternalErrorException {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            throw new InternalErrorException(this.getClass().getName(), e);
        }
    }
}

