/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.HandlerChainConfigException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidCfgAttributeValueException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.UnexpectedElementException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerWrapper;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class AdminHandler
extends HandlerWrapper {
    private static final QName ADMIN_HANDLER = QName.get((String)"admin-handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName ADMIN_HANDLER_REF = QName.get((String)"admin-handler-ref", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName HANDLER = QName.get((String)"handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");

    private String getMandatoryNameAttribute(Element theElement) throws InvalidCfgAttributeValueException {
        String name = theElement.attributeValue("name");
        if (name == null) {
            throw new InvalidCfgAttributeValueException(AdminHandler.class.getName(), name, "name");
        }
        return name;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        HandlerFactory handlerFactory = (HandlerFactory)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerFactory");
        Element root = (Element)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfigurationElement");
        String handlerConfiguration = (String)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration");
        if (root == null) {
            SAXReader xmlReader = new SAXReader();
            try {
                Document doc = xmlReader.read((Reader)new StringReader(handlerConfiguration));
                root = doc.getRootElement();
            }
            catch (DocumentException e) {
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
            }
        }
        if (root != null && root.getNodeType() == 1) {
            Object e;
            this.setName(root);
            if (root.getQName().equals((Object)ADMIN_HANDLER)) {
                e = root.createCopy(HANDLER);
                Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
                this.setHandler(handlerFactory.createHandler(config, (Element)e));
            } else if (root.getQName().equals((Object)ADMIN_HANDLER_REF)) {
                String refName = this.getMandatoryNameAttribute(root);
                this.setHandler(handlerFactory.getHandlerByName(refName));
            } else {
                e = new UnexpectedElementException(ADMIN_HANDLER.getQualifiedName() + "|" + ADMIN_HANDLER_REF.getQualifiedName());
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)e);
            }
        }
    }
}

