/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.handler.ProcessWellKnownQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.InternalQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilter;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterConditionalExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterFunctionCall;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterRelationExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.admin.soap.SessionImpl;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportImpl;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ProcessSessionQuery
extends DefaultHandler {
    private static final String AT_SIGN = "@";

    private static String getExpectedPropertyValue(Passport thePassport, String theProperty) throws SoapFaultException {
        String expectedValue = null;
        if (theProperty.equals(ProcessSessionQuery.getXpathPropertyName("objectClass"))) {
            expectedValue = "session";
        } else if (theProperty.equals(ProcessSessionQuery.getXpathPropertyName("tenantID"))) {
            expectedValue = thePassport.getTenancyInfo().getTenancy(TenancyInfo.TenancyType.TENANTID);
        } else {
            throw new RuntimeException("The property '" + theProperty + "' is not searchable.");
        }
        return expectedValue;
    }

    public static Collection<Passport> getMatchingPassports(Passport thePassport, SearchExpression theSearchExpression) throws SoapFaultException {
        Collection<Passport> sessions = PassportManager.getInstance().getVisibleSession(thePassport);
        Iterator<Passport> sIt = sessions.iterator();
        SearchStep[] steps = theSearchExpression.getSteps();
        ArrayList<Passport> matchingPassports = new ArrayList<Passport>();
        SearchFilter filter = null;
        switch (steps.length) {
            case 0: {
                break;
            }
            case 1: {
                filter = steps[0].getPredicate();
                break;
            }
            case 2: {
                filter = steps[1].getPredicate();
                break;
            }
            default: {
                return matchingPassports;
            }
        }
        while (sIt.hasNext()) {
            PassportImpl p = (PassportImpl)sIt.next();
            if (!ProcessSessionQuery.matchesFilter(p, filter)) continue;
            matchingPassports.add(p);
        }
        return matchingPassports;
    }

    static String getXpathPropertyName(String thePropertyName) {
        return AT_SIGN + thePropertyName;
    }

    private static boolean matchesConditionalExpression(Passport thePassport, SearchFilter filter) throws SoapFaultException {
        SearchFilterConditionalExpression expr = (SearchFilterConditionalExpression)filter;
        String operator = expr.getOperator();
        SearchFilter[] filters = expr.getFilters();
        boolean retval = false;
        for (int i = 0; !(i >= filters.length || !(retval = ProcessSessionQuery.matchesFilter(thePassport, filters[i])) && operator.equals("and") || retval && operator.equals("or")); ++i) {
        }
        return retval;
    }

    private static boolean matchesFilter(Passport thePassport, SearchFilter theSearchFilter) throws SoapFaultException {
        boolean retval;
        if (theSearchFilter == null) {
            retval = true;
        } else {
            switch (theSearchFilter.getSearchFilterType()) {
                case 3: {
                    retval = ProcessSessionQuery.matchesConditionalExpression(thePassport, theSearchFilter);
                    break;
                }
                case 2: {
                    retval = ProcessSessionQuery.matchesFunctionCall(thePassport, theSearchFilter);
                    break;
                }
                case 1: {
                    retval = ProcessSessionQuery.matchesRelationalExpression(thePassport, theSearchFilter);
                    break;
                }
                default: {
                    retval = false;
                }
            }
        }
        return retval;
    }

    private static boolean matchesFunctionCall(Passport thePassport, SearchFilter filter) throws SoapFaultException {
        String expectedValue;
        SearchFilterFunctionCall expr = (SearchFilterFunctionCall)filter;
        String[] parameters = expr.getParameters();
        boolean retval = expr.getFunctionName().equals("CAMID") ? false : (expr.getFunctionName().equals("starts-with") ? (expectedValue = ProcessSessionQuery.getExpectedPropertyValue(thePassport, parameters[0])) != null && expectedValue.startsWith(parameters[1]) : (expr.getFunctionName().equals("ends-with") ? (expectedValue = ProcessSessionQuery.getExpectedPropertyValue(thePassport, parameters[0])) != null && expectedValue.endsWith(parameters[1]) : (expr.getFunctionName().equals("contains") ? (expectedValue = ProcessSessionQuery.getExpectedPropertyValue(thePassport, parameters[0])) != null && expectedValue.indexOf(parameters[1]) != -1 : false)));
        return retval;
    }

    private static boolean matchesRelationalExpression(Passport thePassport, SearchFilter filter) throws SoapFaultException {
        SearchFilterRelationExpression expr = (SearchFilterRelationExpression)filter;
        String property = expr.getPropertyName();
        String operator = expr.getOperator();
        String constraint = expr.getConstraint();
        String expectedPropertyValue = ProcessSessionQuery.getExpectedPropertyValue(thePassport, property);
        boolean retval = expectedPropertyValue == null ? false : (operator.equals("=") ? expectedPropertyValue.compareTo(constraint) == 0 : (operator.equals(">") ? expectedPropertyValue.compareTo(constraint) > 0 : (operator.equals(">=") ? expectedPropertyValue.compareTo(constraint) >= 0 : (operator.equals("<") ? expectedPropertyValue.compareTo(constraint) < 0 : (operator.equals("<=") ? expectedPropertyValue.compareTo(constraint) <= 0 : (operator.equals("!=") ? expectedPropertyValue.compareTo(constraint) != 0 : false))))));
        return retval;
    }

    private static boolean requestIsForSession(SearchStep[] origSearchSteps) {
        boolean retValue = false;
        if (origSearchSteps.length > 0 && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[0], 3, "session")) {
            retValue = origSearchSteps.length == 2 && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[1], 3, "*");
        }
        return retValue;
    }

    private void addSessions(MessageContext theContext, Query theQuery, QueryResult theQueryResult) throws SoapFaultException {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        SearchExpression searchExpression = theQuery.getSearchExpression();
        Collection<Passport> matchingPassports = ProcessSessionQuery.getMatchingPassports(passport, searchExpression);
        for (PassportImpl passportImpl : matchingPassports) {
            SessionImpl session = new SessionImpl(passportImpl);
            session.populate(passportImpl);
            theQueryResult.add((BaseClass)session);
        }
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        InternalQuery origQuery = (InternalQuery)theContext.get((Object)Query.class.getName());
        SearchExpression origSearchExpression = origQuery.getSearchExpression();
        SearchStep[] origSearchSteps = origSearchExpression.getSteps();
        if (origSearchSteps == null) {
            return false;
        }
        if (ProcessSessionQuery.requestIsForSession(origSearchSteps)) {
            this.addSessions(theContext, origQuery, queryResult);
            retval = false;
        }
        return retval;
    }
}

