/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.InternalQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpressionImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilter;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterConditionalExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterFunctionCall;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterRelationExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ProcessWellKnownQuery
extends DefaultHandler {
    static final String STAR = "*";
    private static final String HOME = "home";
    private static final String NAMESPACE_OC = "namespace";
    private NamespaceManager namespaceManager;

    public static SearchPath getSearchPath(SearchFilterFunctionCall theCamidFunctionCall) throws SoapFaultException {
        String[] camidFunctionParms;
        SearchPathImpl searchPath = null;
        if (theCamidFunctionCall.getFunctionName().equals("CAMID") && (camidFunctionParms = theCamidFunctionCall.getParameters()) != null && camidFunctionParms.length == 2 && camidFunctionParms[0] != null) {
            searchPath = new SearchPathImpl(camidFunctionParms[0], camidFunctionParms[1]);
        }
        return searchPath;
    }

    public static boolean isCamidFunctionCall(SearchStep firstSearchStep) {
        int origAxis = firstSearchStep.getAxis();
        String origNodeTest = firstSearchStep.getNodeTest();
        SearchFilter origSearchFilter = firstSearchStep.getPredicate();
        if (origSearchFilter != null) {
            switch (origSearchFilter.getSearchFilterType()) {
                case 2: {
                    SearchFilterFunctionCall searchFilterFunctionCall = (SearchFilterFunctionCall)origSearchFilter;
                    String origFunctionCallName = searchFilterFunctionCall.getFunctionName();
                    if (origAxis != 5 || !origNodeTest.equals(STAR) || !origFunctionCallName.equals("CAMID")) break;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isMatchingStep(SearchStep theSearchStep, int theExpectedAxis, String theExpectedNodeTest) {
        int actualAxis = theSearchStep.getAxis();
        String actualNodeTest = theSearchStep.getNodeTest();
        return actualAxis == theExpectedAxis && actualNodeTest.equals(theExpectedNodeTest);
    }

    private static boolean isMatchingStep(SearchStep theSearchStep, int theExpectedAxis, String theExpectedNodeTest, SearchFilter theExpectedSearchFilter) {
        SearchFilter actualSearchFilter = theSearchStep.getPredicate();
        return ProcessWellKnownQuery.isMatchingStep(theSearchStep, theExpectedAxis, theExpectedNodeTest) && ProcessWellKnownQuery.isSameFilter(actualSearchFilter, theExpectedSearchFilter);
    }

    private static boolean isSameFilter(SearchFilter theActualSearchFilter, SearchFilter theExpectedSearchFilter) {
        if (theActualSearchFilter == null || theExpectedSearchFilter == null) {
            return theActualSearchFilter == theExpectedSearchFilter;
        }
        return theActualSearchFilter.equals(theExpectedSearchFilter);
    }

    private static boolean requestIsForDirectoryStar(SearchStep[] origSearchSteps) {
        int expectedSearchStepLength = 2;
        boolean retValue = origSearchSteps.length == 2 && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[0], 3, "directory", null) && (ProcessWellKnownQuery.isMatchingStep(origSearchSteps[1], 3, STAR, null) || ProcessWellKnownQuery.isMatchingStep(origSearchSteps[1], 3, NAMESPACE_OC, null));
        return retValue;
    }

    private static boolean requestIsForHomeAccount(SearchStep[] origSearchSteps) {
        int expectedSearchStepLength = 2;
        boolean retValue = origSearchSteps.length == 2 && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[0], 3, HOME, null) && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[1], 3, "account", null);
        return retValue;
    }

    private static boolean requestIsForNamespaceHomeAccount(SearchStep[] origSearchSteps) {
        int expectedSearchStepLength = 3;
        boolean retValue = origSearchSteps.length == 3 && ProcessWellKnownQuery.isCamidFunctionCall(origSearchSteps[0]) && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[1], 3, HOME, null) && ProcessWellKnownQuery.isMatchingStep(origSearchSteps[2], 5, "account", null);
        return retValue;
    }

    private void addMatchingNamespace(QueryResult queryResult, String namespaceID, SearchFilter filter) {
        if (this.namespaceMatchesFilter(namespaceID, filter)) {
            Namespace ns = this.namespaceManager.getNamespace(namespaceID);
            queryResult.add((BaseClass)ns);
        }
    }

    private boolean addNamespace(QueryResult queryResult, SearchStep[] origSearchSteps, SearchPath searchPath, QueryOptions options) throws SoapFaultException {
        if (options == null || options.getSkipCount() == 0L) {
            return this.handleSpecificNamespaceQuery(queryResult, origSearchSteps, searchPath) && this.handleNamespaceRelativeQuery(queryResult, origSearchSteps, searchPath) && this.handleNamespaceAncestorQuery(queryResult, origSearchSteps, searchPath);
        }
        return true;
    }

    private String getExpectedPropertyValue(String property, String namespaceID) {
        String expectedPropertyValue = property.equals("@objectClass") ? NAMESPACE_OC : (property.equals("@defaultName") || property.equals("@name") ? this.namespaceManager.getNamespace(namespaceID).getName(null) : null);
        return expectedPropertyValue;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean retval = false;
        QueryResult queryResult = (QueryResult)theContext.get((Object)QueryResult.class.getName());
        InternalQuery origQuery = (InternalQuery)theContext.get((Object)Query.class.getName());
        SearchExpression origSearchExpression = origQuery.getSearchExpression();
        SearchStep[] origSearchSteps = origSearchExpression.getSteps();
        if (origSearchSteps == null) {
            return false;
        }
        if (ProcessWellKnownQuery.requestIsForDirectoryStar(origSearchSteps)) {
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            Set<String> namespaceIds = passport.getAuthenticatedNamespaceIDs();
            for (String namespaceId : namespaceIds) {
                Namespace namespace = this.namespaceManager.getNamespace(namespaceId);
                if (namespace == null) continue;
                queryResult.add((BaseClass)namespace);
            }
            retval = false;
        } else if (ProcessWellKnownQuery.requestIsForNamespaceHomeAccount(origSearchSteps)) {
            SearchFilterFunctionCall camidFunctionCall = (SearchFilterFunctionCall)origSearchSteps[0].getPredicate();
            SearchPath searchPath = ProcessWellKnownQuery.getSearchPath(camidFunctionCall);
            origQuery.setSearchExpression(new SearchExpressionImpl("~"));
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)searchPath.getNamespaceID());
            Namespace ns = this.namespaceManager.getNamespace(searchPath.getNamespaceID());
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject", (Object)ns);
            retval = true;
        } else if (ProcessWellKnownQuery.requestIsForHomeAccount(origSearchSteps)) {
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)passport.getPrimaryNsID());
            Namespace ns = this.namespaceManager.getNamespace(passport.getPrimaryNsID());
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject", (Object)ns);
            retval = true;
        } else {
            retval = this.handleNamespaceQuery(theContext, queryResult, origQuery);
        }
        return retval;
    }

    private boolean handleNamespaceAncestorQuery(QueryResult queryResult, SearchStep[] origSearchSteps, SearchPath theSearchPath) throws SoapFaultException {
        if (origSearchSteps.length == 2 && theSearchPath.getObjectID() != null) {
            switch (origSearchSteps[1].getAxis()) {
                case 2: {
                    this.addMatchingNamespace(queryResult, theSearchPath.getNamespaceID(), origSearchSteps[1].getPredicate());
                    break;
                }
            }
        }
        return true;
    }

    private boolean handleNamespaceQuery(MessageContext theContext, QueryResult queryResult, Query origQuery) throws SoapFaultException {
        boolean retval = true;
        SearchStep[] origSearchSteps = origQuery.getSearchExpression().getSteps();
        if (origSearchSteps.length == 0) {
            return retval;
        }
        if (ProcessWellKnownQuery.isCamidFunctionCall(origSearchSteps[0])) {
            SearchPath searchPath = ProcessWellKnownQuery.getSearchPath((SearchFilterFunctionCall)origSearchSteps[0].getPredicate());
            String namespaceID = searchPath.getNamespaceID();
            HashSet<Namespace> browseableNS = new HashSet<Namespace>();
            browseableNS.addAll(Arrays.asList(this.namespaceManager.getBrowseableNamespaces()));
            Namespace ns = this.namespaceManager.getNamespace(namespaceID);
            if (browseableNS.contains(ns)) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)namespaceID);
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespaceObject", (Object)ns);
                retval = this.addNamespace(queryResult, origSearchSteps, searchPath, origQuery.getQueryOptions());
            } else {
                retval = false;
            }
        } else {
            retval = this.handleRootQuery(queryResult, origSearchSteps);
        }
        return retval;
    }

    private boolean handleNamespaceRelativeQuery(QueryResult queryResult, SearchStep[] origSearchSteps, SearchPath theSearchPath) throws SoapFaultException {
        boolean retval = true;
        if (origSearchSteps.length == 2 && theSearchPath.getObjectID() == null) {
            switch (origSearchSteps[1].getAxis()) {
                case 2: 
                case 7: {
                    this.addMatchingNamespace(queryResult, theSearchPath.getNamespaceID(), origSearchSteps[1].getPredicate());
                    retval = false;
                    break;
                }
                case 5: {
                    this.addMatchingNamespace(queryResult, theSearchPath.getNamespaceID(), origSearchSteps[1].getPredicate());
                    break;
                }
                case 1: 
                case 6: {
                    retval = false;
                    break;
                }
            }
        }
        return retval;
    }

    private boolean handleRootQuery(QueryResult queryResult, SearchStep[] origSearchSteps) throws SoapFaultException {
        boolean retval = false;
        if (origSearchSteps.length == 1 && origSearchSteps[0].getNodeTest().equals(STAR) || origSearchSteps[0].getNodeTest().equals(NAMESPACE_OC)) {
            int actualAxis = origSearchSteps[0].getAxis();
            switch (actualAxis) {
                case 3: 
                case 4: 
                case 5: {
                    Namespace[] namespaces = this.namespaceManager.getBrowseableNamespaces();
                    for (int i = 0; i < namespaces.length; ++i) {
                        this.addMatchingNamespace(queryResult, namespaces[i].getSearchPath().getNamespaceID(), origSearchSteps[0].getPredicate());
                    }
                    retval = actualAxis != 3;
                    break;
                }
                default: {
                    retval = false;
                }
            }
        }
        return retval;
    }

    private boolean handleSpecificNamespaceQuery(QueryResult queryResult, SearchStep[] origSearchSteps, SearchPath theSearchPath) throws SoapFaultException {
        if (origSearchSteps.length == 1 && theSearchPath.getObjectID() == null) {
            this.addMatchingNamespace(queryResult, theSearchPath.getNamespaceID(), origSearchSteps[0].getPredicate());
            return false;
        }
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.namespaceManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
    }

    private boolean namespaceMatchesConditionalExpression(String namespaceID, SearchFilter filter) {
        SearchFilterConditionalExpression expr = (SearchFilterConditionalExpression)filter;
        String operator = expr.getOperator();
        SearchFilter[] filters = expr.getFilters();
        boolean retval = false;
        for (int i = 0; !(i >= filters.length || !(retval = this.namespaceMatchesFilter(namespaceID, filters[i])) && operator.equals("and") || retval && operator.equals("or")); ++i) {
        }
        return retval;
    }

    private boolean namespaceMatchesFilter(String namespaceID, SearchFilter filter) {
        boolean retval;
        if (filter == null) {
            retval = true;
        } else {
            switch (filter.getSearchFilterType()) {
                case 3: {
                    retval = this.namespaceMatchesConditionalExpression(namespaceID, filter);
                    break;
                }
                case 2: {
                    retval = this.namespaceMatchesFunctionCall(namespaceID, filter);
                    break;
                }
                case 1: {
                    retval = this.namespaceMatchesRelationalExpression(namespaceID, filter);
                    break;
                }
                default: {
                    retval = false;
                }
            }
        }
        return retval;
    }

    private boolean namespaceMatchesFunctionCall(String namespaceID, SearchFilter filter) {
        String expectedValue;
        SearchFilterFunctionCall expr = (SearchFilterFunctionCall)filter;
        String[] parameters = expr.getParameters();
        boolean retval = expr.getFunctionName().equals("CAMID") ? parameters[0] != null && parameters[0].equals(namespaceID) && parameters[1] == null : (expr.getFunctionName().equals("starts-with") ? (expectedValue = this.getExpectedPropertyValue(parameters[0], namespaceID)) != null && expectedValue.startsWith(parameters[1]) : (expr.getFunctionName().equals("ends-with") ? (expectedValue = this.getExpectedPropertyValue(parameters[0], namespaceID)) != null && expectedValue.endsWith(parameters[1]) : (expr.getFunctionName().equals("contains") ? (expectedValue = this.getExpectedPropertyValue(parameters[0], namespaceID)) != null && expectedValue.indexOf(parameters[1]) != -1 : false)));
        return retval;
    }

    private boolean namespaceMatchesRelationalExpression(String namespaceID, SearchFilter filter) {
        SearchFilterRelationExpression expr = (SearchFilterRelationExpression)filter;
        String property = expr.getPropertyName();
        String operator = expr.getOperator();
        String constraint = expr.getConstraint();
        String expectedPropertyValue = this.getExpectedPropertyValue(property, namespaceID);
        boolean retval = expectedPropertyValue == null ? false : (operator.equals("=") ? expectedPropertyValue.compareTo(constraint) == 0 : (operator.equals(">") ? expectedPropertyValue.compareTo(constraint) > 0 : (operator.equals(">=") ? expectedPropertyValue.compareTo(constraint) >= 0 : (operator.equals("<") ? expectedPropertyValue.compareTo(constraint) < 0 : (operator.equals("<=") ? expectedPropertyValue.compareTo(constraint) <= 0 : (operator.equals("!=") ? expectedPropertyValue.compareTo(constraint) != 0 : false))))));
        return retval;
    }
}

