/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.ExternalSearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.Group;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceFolder;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResponse;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.Role;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.Tenant;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClass;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogUtil;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.util.LocaleUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public class QueryCM
extends DefaultHandler {
    public static final String ANONYMOUS_USER_CAMID = "CAMID(\"::Anonymous\")";
    private static final String ARRAY_TYPE = "arrayType";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String LOCALE = "locale";
    private static final String SEARCH = "search";
    private static final String REPLACE_1 = "CAMID(\"\")//~";
    private static final String REPLACE_2 = "~";
    private static final XPath MULTIPLE_QUERY_XPATH = DocumentHelper.createXPath((String)"./SOAP-ENV:Body/bus:query/bus:requests/*");
    private static final XPath SEARCH_PATH_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='searchPath']/*");
    private static final XPath SINGLE_QUERY_XPATH = DocumentHelper.createXPath((String)"./SOAP-ENV:Body/*[local-name()='query']");
    private static final XPath MULTIPLE_QUERY_RESPONSE_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/*/*/*");
    private static final XPath SINGLE_QUERY_RESPONSE_XPATH = DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/*");
    private ICMAccessor cmAccessor;

    private static void replaceSearchString(Element thequeryRequest) {
        Element search = thequeryRequest.element(SEARCH);
        if (search.getText().equals(REPLACE_1) || search.getText().equals(REPLACE_2)) {
            search.setText(ANONYMOUS_USER_CAMID);
        }
    }

    private void addItem(QueryResult theResult, Element itemElement, String theArrayType) throws SoapFaultException {
        String objectClass = this.getXsiTypeName(itemElement);
        String searchPathStr = DocumentHelper.valueOf((XPath)SEARCH_PATH_XPATH, (Node)itemElement);
        Object searchPath = searchPathStr.startsWith("CAMID") ? new SearchPathImpl(searchPathStr) : new ExternalSearchPathImpl(searchPathStr);
        BaseClass object = theResult.create((SearchPath)searchPath, objectClass);
        if (object instanceof Account) {
            this.populateAccount((Account)object, itemElement, theResult);
        } else if (object instanceof Group) {
            this.populateGroup((Group)object, itemElement, theResult);
        } else if (object instanceof Role) {
            this.populateRole((Role)object, itemElement, theResult);
        } else if (object instanceof Namespace) {
            this.populateNamespace((Namespace)object, itemElement, theResult);
        } else if (object instanceof NamespaceFolder) {
            this.populateNamespaceFolder((NamespaceFolder)object, itemElement, theResult);
        } else if (object instanceof Tenant) {
            this.populateTenant((Tenant)object, itemElement, theResult);
        }
        theResult.add(object);
    }

    private String getArrayTypeName(Element theElement) {
        String arrayType = theElement.attributeValue(QName.get((String)ARRAY_TYPE, (String)"http://schemas.xmlsoap.org/soap/encoding/"));
        String arrayTypeName = null;
        if (arrayType != null) {
            int endOfType;
            int endOfPrefix = arrayType.indexOf(58);
            int startOfType = 0;
            if (endOfPrefix > 0) {
                startOfType = endOfPrefix + 1;
            }
            arrayTypeName = (endOfType = arrayType.indexOf(91, startOfType)) > 0 ? arrayType.substring(startOfType, endOfType) : arrayType.substring(startOfType);
        }
        return arrayTypeName;
    }

    private String getElementValue(Element theRoot, String theElementName) {
        String retval = null;
        Element element = theRoot.element(theElementName);
        if (element != null) {
            retval = element.getStringValue();
        }
        return retval;
    }

    private String getXsiTypeName(Element theElement) {
        String xsiType = theElement.attributeValue(QName.get((String)TYPE, (String)"http://www.w3.org/2001/XMLSchema-instance"));
        String xsiTypeName = null;
        if (xsiType != null) {
            int endOfPrefix = xsiType.indexOf(58);
            int startOfType = 0;
            if (endOfPrefix > 0) {
                startOfType = endOfPrefix + 1;
            }
            xsiTypeName = xsiType.substring(startOfType);
        }
        return xsiTypeName;
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        Element soapRequest = LogUtil.getLoggableSoapEnvelope(((SoapEnvRequestImpl)request).getElement());
        boolean isMultipleQuery = true;
        List queries = DocumentHelper.selectNodes((XPath)MULTIPLE_QUERY_XPATH, (Node)soapRequest);
        if (queries.isEmpty()) {
            queries = DocumentHelper.selectNodes((XPath)SINGLE_QUERY_XPATH, (Node)soapRequest);
            isMultipleQuery = false;
        }
        for (int i = 0; i < queries.size(); ++i) {
            QueryCM.replaceSearchString((Element)queries.get(i));
        }
        try {
            String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
            String[] readTenantIds = (String[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.readTenantID");
            Document doc = tenantID != null || readTenantIds != null ? this.sendTenantedRequest(soapRequest, tenantID, readTenantIds) : DocumentHelper.parseText((String)this.cmAccessor.invoke(soapRequest.asXML()));
            Element responseElement = doc.getRootElement();
            List items = isMultipleQuery ? DocumentHelper.selectNodes((XPath)MULTIPLE_QUERY_RESPONSE_XPATH, (Node)responseElement) : DocumentHelper.selectNodes((XPath)SINGLE_QUERY_RESPONSE_XPATH, (Node)responseElement);
            SoapEnvelope response = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
            QueryResponse queryResponse = (QueryResponse)response.getBody().getBodyEntry();
            QueryResult[] queryResult = queryResponse.getResult();
            for (int i = 0; i < items.size(); ++i) {
                this.populateResults((Element)items.get(i), queryResult[i]);
            }
        }
        catch (Exception e) {
            throw new FunctionCallFailedException(QueryCM.class.toString(), "Method.invoke(cmServiceInstance, queryRequest)", e);
        }
        return true;
    }

    private Document sendTenantedRequest(Element soapRequest, String tenantID, String[] readTenantIds) throws DocumentException, SoapFaultException {
        String[] readTenantIdsToUse = readTenantIds;
        if (readTenantIdsToUse == null && tenantID != null) {
            readTenantIdsToUse = new String[]{};
        }
        HashSet<String> readTenantIdsSet = null;
        if (readTenantIdsToUse != null) {
            readTenantIdsSet = new HashSet<String>(readTenantIdsToUse.length + 2);
            for (String readId : readTenantIdsToUse) {
                readTenantIdsSet.add(readId);
            }
            readTenantIdsSet.add("");
            if (tenantID != null) {
                readTenantIdsSet.add(tenantID);
            }
        }
        return DocumentHelper.parseText((String)this.cmAccessor.invoke(soapRequest.asXML(), tenantID, readTenantIdsSet));
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.cmAccessor = CMAccessor.getInstance();
    }

    private void parseObjectAncestors(BaseClass theBaseClass, QueryResult theResult, Element property) throws SoapFaultException {
        BaseClass[] ancestors = null;
        Element value = property.element(VALUE);
        if (value != null) {
            List items = value.elements();
            ancestors = new BaseClass[items.size() - 1];
            int cursor = 0;
            for (int j = 0; j < items.size(); ++j) {
                Element ancestorElement = (Element)items.get(j);
                String objectClass = this.getElementValue(ancestorElement, "objectClass");
                String title = this.getElementValue(ancestorElement, "title");
                String searchPath = this.getElementValue(ancestorElement, "searchPath");
                if (searchPath.equals("/directory") && j == 0) continue;
                ancestors[cursor] = theResult.create((SearchPath)new SearchPathImpl(searchPath), objectClass);
                ancestors[cursor].addName(null, title);
                ++cursor;
            }
        }
        theBaseClass.setAncestors(ancestors);
    }

    private void populateAccount(Account theAccount, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theAccount, properties, theResult);
        for (int i = 0; i < properties.size(); ++i) {
            String value;
            Locale locale;
            String localeStr;
            Element property = (Element)properties.get(i);
            String propertyName = property.getName();
            if (propertyName.equals("businessPhone")) {
                String businessPhone = this.getElementValue(property, "businessPhone");
                theAccount.setBusinessPhone(businessPhone);
                continue;
            }
            if (propertyName.equals("contentLocale")) {
                localeStr = this.getElementValue(property, "contentLocale");
                locale = new Locale(localeStr);
                theAccount.setContentLocale(locale);
                continue;
            }
            if (propertyName.equals("email")) {
                String email = this.getElementValue(property, "email");
                theAccount.setEmail(email);
                continue;
            }
            if (propertyName.equals("faxPhone")) {
                String faxPhone = this.getElementValue(property, "faxPhone");
                theAccount.setFaxPhone(faxPhone);
                continue;
            }
            if (propertyName.equals("givenName")) {
                value = this.getElementValue(property, "givenName");
                theAccount.setGivenName(value);
                continue;
            }
            if (propertyName.equals("homePhone")) {
                value = this.getElementValue(property, "homePhone");
                theAccount.setHomePhone(value);
                continue;
            }
            if (propertyName.equals("mobilePhone")) {
                value = this.getElementValue(property, "mobilePhone");
                theAccount.setMobilePhone(value);
                continue;
            }
            if (propertyName.equals("pagerPhone")) {
                value = this.getElementValue(property, "pagerPhone");
                theAccount.setPagerPhone(value);
                continue;
            }
            if (propertyName.equals("parameters")) {
                value = this.getElementValue(property, "parameters");
                theAccount.setPagerPhone(value);
                continue;
            }
            if (propertyName.equals("postalAddress")) {
                value = this.getElementValue(property, "postalAddress");
                theAccount.setPostalAddress(value);
                continue;
            }
            if (propertyName.equals("productLocale")) {
                localeStr = this.getElementValue(property, "productLocale");
                locale = new Locale(localeStr);
                theAccount.setProductLocale(locale);
                continue;
            }
            if (propertyName.equals("surname")) {
                value = this.getElementValue(property, "surname");
                theAccount.setSurname(value);
                continue;
            }
            if (!propertyName.equals("userName")) continue;
            value = this.getElementValue(property, "userName");
            theAccount.setUserName(value);
        }
    }

    private void populateBaseClass(BaseClass theBaseClass, List theProperties, QueryResult theResult) throws SoapFaultException {
        for (int i = 0; i < theProperties.size(); ++i) {
            Element property = (Element)theProperties.get(i);
            String propertyName = property.getName();
            if (propertyName.equals("ancestors")) {
                this.parseObjectAncestors(theBaseClass, theResult, property);
                continue;
            }
            if (propertyName.equals("hasChildren")) {
                Boolean hasChildren = Boolean.valueOf(this.getElementValue(property, VALUE));
                theBaseClass.setHasChildren(hasChildren);
                continue;
            }
            if (propertyName.equals("name")) {
                Element value = property.element(VALUE);
                if (value == null) continue;
                List items = value.elements();
                for (int j = 0; j < items.size(); ++j) {
                    Element nameElement = (Element)items.get(j);
                    String localeStr = this.getElementValue(nameElement, LOCALE);
                    Locale locale = LocaleUtil.createContentLocale((String)localeStr, null);
                    String name = this.getElementValue(nameElement, VALUE);
                    theBaseClass.addName(locale, name);
                }
                continue;
            }
            if (propertyName.equals("tenantID")) {
                String tenant = this.getElementValue(property, VALUE);
                theBaseClass.setTenantID(tenant);
                continue;
            }
            if (!propertyName.equals("disabled")) continue;
            Boolean isDisabled = Boolean.valueOf(this.getElementValue(property, VALUE));
            theBaseClass.setDisabled(isDisabled.booleanValue());
        }
    }

    private void populateGroup(Group theGroup, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theGroup, properties, theResult);
        for (int i = 0; i < properties.size(); ++i) {
            Element property = (Element)properties.get(i);
            String propertyName = property.getName();
            if (!propertyName.equals("members")) continue;
        }
    }

    private void populateNamespace(Namespace theNamespace, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theNamespace, properties, theResult);
        for (int i = 0; i < properties.size(); ++i) {
            Element property = (Element)properties.get(i);
            String propertyName = property.getName();
            if (!propertyName.equals("capabilities") && !propertyName.equals("namespaceFormat")) continue;
        }
    }

    private void populateNamespaceFolder(NamespaceFolder theFolder, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theFolder, properties, theResult);
    }

    private void populateResults(Element theQueryResultElement, QueryResult theQueryResult) throws SoapFaultException {
        List items = theQueryResultElement.elements();
        String arrayType = this.getArrayTypeName(theQueryResultElement);
        for (int i = 0; i < items.size(); ++i) {
            Element itemElement = (Element)items.get(i);
            this.addItem(theQueryResult, itemElement, arrayType);
        }
    }

    private void populateRole(Role theRole, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theRole, properties, theResult);
        for (int i = 0; i < properties.size(); ++i) {
            Element property = (Element)properties.get(i);
            String propertyName = property.getName();
            if (!propertyName.equals("members")) continue;
        }
    }

    private void populateTenant(Tenant theTenant, Element theElement, QueryResult theResult) throws SoapFaultException {
        List properties = theElement.elements();
        this.populateUiClass((UiClass)theTenant, properties, theResult);
    }

    private void populateUiClass(UiClass theUiClass, List theProperties, QueryResult theResult) throws SoapFaultException {
        this.populateBaseClass((BaseClass)theUiClass, theProperties, theResult);
        for (int i = 0; i < theProperties.size(); ++i) {
            Element value;
            Element property = (Element)theProperties.get(i);
            String propertyName = property.getName();
            if (!propertyName.equals("description") || (value = property.element(VALUE)) == null) continue;
            List items = value.elements();
            for (int j = 0; j < items.size(); ++j) {
                Element descriptionElement = (Element)items.get(j);
                String localeStr = this.getElementValue(descriptionElement, LOCALE);
                Locale locale = LocaleUtil.createContentLocale((String)localeStr, null);
                String description = this.getElementValue(descriptionElement, VALUE);
                theUiClass.addDescription(locale, description);
            }
        }
    }
}

