/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class QueryCognosMembership
extends DefaultHandler {
    private static final String COGNOS_NAMESPACE = "";
    private static final String[] MEMBERSHIP_PROPERTIES = new String[]{"searchPath", "objectClass"};

    private String getMembershipQuery(Set<String> theUserIdentity) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("membership");
        buffer.append('(');
        Iterator<String> it = theUserIdentity.iterator();
        boolean isFirstEntry = true;
        while (it.hasNext()) {
            if (isFirstEntry) {
                isFirstEntry = false;
            } else {
                buffer.append(" | ");
            }
            buffer.append(it.next());
        }
        buffer.append(')');
        return buffer.toString();
    }

    private Set<String> getUserIdentity(Account theAccount) throws SoapFaultException {
        BaseClass[] baseClass;
        LinkedHashSet<String> logonIdentity = new LinkedHashSet<String>();
        SearchPath searchPath = theAccount.getSearchPath();
        SearchPathImpl nsSearchPath = new SearchPathImpl(searchPath.getNamespaceID(), null);
        logonIdentity.add(searchPath.getValue());
        logonIdentity.add(nsSearchPath.getValue());
        if (!searchPath.getNamespaceID().equals(COGNOS_NAMESPACE)) {
            SearchPathImpl cognosNsSearchPath = new SearchPathImpl(COGNOS_NAMESPACE, null);
            logonIdentity.add(cognosNsSearchPath.getValue());
        }
        if ((baseClass = theAccount.getMemberOf()) != null) {
            for (int i = 0; i < baseClass.length; ++i) {
                String objectClass = baseClass[i].getObjectClass();
                if (!objectClass.equals("group") && !objectClass.equals("role")) continue;
                logonIdentity.add(baseClass[i].getSearchPath().getValue());
            }
        }
        return logonIdentity;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        QueryResult userInfo = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
        Account account = (Account)userInfo.getAll()[0];
        Set<String> logonIdentity = this.getUserIdentity(account);
        String membershipSearchExpression = this.getMembershipQuery(logonIdentity);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.searchTargetNamespace", (Object)COGNOS_NAMESPACE);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.searchPath", (Object)membershipSearchExpression);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.properties", (Object)MEMBERSHIP_PROPERTIES);
        LinkedHashSet cognosIdentity = new LinkedHashSet();
        LinkedHashSet cognosRoles = new LinkedHashSet();
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.cognosIdentity", cognosIdentity);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonIdentity", logonIdentity);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles", cognosRoles);
        return true;
    }
}

