/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.cognosns.CognosNSCache;
import com.ibm.cognos.camaaa.internal.admin.cognosns.CognosOMBridgeSoapAction;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Group;
import com.ibm.cognos.camaaa.internal.admin.soap.GroupImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.NamespaceImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.RoleImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class QueryCognosMembershipFromCache
extends DefaultHandler {
    static final String COGNOS_NS_CACHE = "COGNOS_NS_CACHE";
    static final String COGNOS_NAMESPACE_ID = "";
    static final Group COGNOS_EVERYONE = new GroupImpl(new SearchPathImpl("", ":Everyone"));
    static final Group COGNOS_ALL_AUTH_USERS = new GroupImpl(new SearchPathImpl("", ":All Authenticated Users"));
    private static final String COGNOS_ALL_AUTH_USERS_ID = ":All Authenticated Users";
    private static final String COGNOS_EVERYONE_ID = ":Everyone";
    private Namespace cognosNamespace;
    private boolean cmIsDisabled;
    private CognosNSCache cognosNSCache;

    private void addMembershipsToIdentities(LinkedHashSet<BaseClass> membership, List<BaseClass> membershipList, HashSet<String> cognosGroups, HashSet<String> cognosRoles) {
        for (BaseClass member : membership) {
            if (member instanceof RoleImpl) {
                this.addToLists(member, membershipList, cognosRoles);
                continue;
            }
            if (!(member instanceof GroupImpl)) continue;
            this.addToLists(member, membershipList, cognosGroups);
        }
    }

    private void addToLists(BaseClass member, List<BaseClass> membershipList, HashSet<String> cognosObjects) {
        if (cognosObjects.add(member.getSearchPath().getValue())) {
            membershipList.add(member);
        }
    }

    @Override
    public void destroy() {
    }

    private List<BaseClass> getMembershipFromCache(Set<BaseClass> logonIdentity, HashSet<String> cognosGroups, HashSet<String> cognosRoles, String tenantID) throws SoapFaultException {
        ArrayList<BaseClass> membershipList = new ArrayList<BaseClass>();
        Iterator<BaseClass> it = logonIdentity.iterator();
        while (it.hasNext()) {
            LinkedHashSet<BaseClass> membership = this.cognosNSCache.getMembership(it.next(), tenantID);
            if (membership == null) continue;
            this.addMembershipsToIdentities(membership, membershipList, cognosGroups, cognosRoles);
        }
        return membershipList;
    }

    private Set<String> getUserIdentity(Account theAccount, Set<BaseClass> logonIdentityObjects) throws SoapFaultException {
        BaseClass[] baseClass;
        HashSet<String> logonIdentity = new HashSet<String>();
        SearchPath searchPath = theAccount.getSearchPath();
        SearchPathImpl nsSearchPath = new SearchPathImpl(searchPath.getNamespaceID(), null);
        logonIdentityObjects.add(new NamespaceImpl(nsSearchPath));
        logonIdentity.add(nsSearchPath.getValue());
        logonIdentityObjects.add((BaseClass)theAccount);
        logonIdentity.add(searchPath.getValue());
        if (!this.cmIsDisabled) {
            logonIdentityObjects.add((BaseClass)COGNOS_EVERYONE);
            logonIdentity.add(COGNOS_EVERYONE.getSearchPath().getValue());
            logonIdentityObjects.add((BaseClass)this.cognosNamespace);
            logonIdentity.add(this.cognosNamespace.getSearchPath().getValue());
            if (!searchPath.getNamespaceID().equals(COGNOS_NAMESPACE_ID)) {
                logonIdentityObjects.add((BaseClass)COGNOS_ALL_AUTH_USERS);
                logonIdentity.add(COGNOS_ALL_AUTH_USERS.getSearchPath().getValue());
            }
        }
        if ((baseClass = theAccount.getMemberOf()) != null) {
            for (int i = 0; i < baseClass.length; ++i) {
                String objectClass = baseClass[i].getObjectClass();
                if (!objectClass.equals("group") && !objectClass.equals("role")) continue;
                logonIdentityObjects.add(baseClass[i]);
                logonIdentity.add(baseClass[i].getSearchPath().getValue());
            }
        }
        return logonIdentity;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        try {
            String action = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapAction");
            if (!action.equals(CognosOMBridgeSoapAction.getLatestSoapAction())) {
                return false;
            }
            QueryResult userInfo = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
            if (userInfo == null) {
                throw new RuntimeException("Expected an account object");
            }
            BaseClass[] nsObjects = userInfo.getAll();
            if (nsObjects.length != 1 || !(nsObjects[0] instanceof Account)) {
                throw new RuntimeException("Expected a single account object");
            }
            Account account = (Account)nsObjects[0];
            HashSet<BaseClass> logonIdentityObjects = new HashSet<BaseClass>();
            Set<String> logonIdentity = this.getUserIdentity(account, logonIdentityObjects);
            HashSet<String> cognosGroups = new HashSet<String>();
            HashSet<String> cognosRoles = new HashSet<String>();
            ArrayList<BaseClass> combinedMembershipList = new ArrayList<BaseClass>();
            String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
            if (tenantID == null) {
                tenantID = COGNOS_NAMESPACE_ID;
            }
            List<BaseClass> cognosUserMembershipList = this.getMembershipFromCache(logonIdentityObjects, cognosGroups, cognosRoles, tenantID);
            combinedMembershipList.addAll(cognosUserMembershipList);
            BaseClass[] memberOf = account.getMemberOf();
            if (memberOf != null) {
                List<BaseClass> namedUserMembershipList = Arrays.asList(memberOf);
                combinedMembershipList.addAll(namedUserMembershipList);
            }
            account.setMemberOf(combinedMembershipList.toArray(new BaseClass[combinedMembershipList.size()]));
            logonIdentity.addAll(cognosGroups);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.cognosIdentity", cognosGroups);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonIdentity", logonIdentity);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles", cognosRoles);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(QueryCognosMembershipFromCache.class.toString(), (Exception)((Object)e));
        }
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        super.init(theConfig);
        this.cognosNSCache = (CognosNSCache)theConfig.get((Object)COGNOS_NS_CACHE);
        if (this.cognosNSCache == null) {
            this.cognosNSCache = CognosNSCache.getInstance();
        }
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String value = config.getOptionalValue("./*[local-name()='instances']/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()", Boolean.FALSE.toString());
        this.cmIsDisabled = Boolean.valueOf(value);
        Configuration rootConfig = config.getRootConfiguration();
        value = rootConfig.getOptionalValue("./*[local-name()='internalDispatcher']/*[local-name()='value']", null);
        this.cognosNSCache.initialize(value, this.cmIsDisabled);
        this.cognosNamespace = new NamespaceImpl(new SearchPathImpl(COGNOS_NAMESPACE_ID, null));
    }
}

