/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryRequest;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResponse;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;

public class QueryMultiple
extends DefaultHandler {
    static final String SINGLE_QUERY_HANDLER = "singleQuery";
    private static final String QUERY_BODY_START = "<SOAP-ENV:Body LockWait=\"0\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><bus:query><bus:requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:queryRequest[1]\">";
    private static final String QUERY_BODY_END = "</bus:requests></bus:query></SOAP-ENV:Body>";

    static String getQueryBody(Query theQuery) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(QUERY_BODY_START);
        buffer.append(theQuery.toString());
        buffer.append(QUERY_BODY_END);
        return buffer.toString();
    }

    static boolean processSingleQuery(MessageContext theContext, Query theQuery, QueryResult theQueryResult) throws SoapFaultException {
        theContext.put((Object)Query.class.getName(), (Object)theQuery);
        theContext.put((Object)QueryResult.class.getName(), (Object)theQueryResult);
        HandlerBinding binding = (HandlerBinding)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler singleQueryHandler = binding.getHandler(SINGLE_QUERY_HANDLER);
        return singleQueryHandler.handleMessage(theContext);
    }

    private static void propagateKey(MessageContext theSource, MessageContext theDestination, String theKey) {
        if (theSource.containsKey((Object)theKey)) {
            theDestination.put((Object)theKey, theSource.get((Object)theKey));
        }
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean retval = true;
        SoapEnvelope requestEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapEnvelope responseEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        QueryResponse response = (QueryResponse)responseEnvelope.getBody().getBodyEntry();
        QueryRequest request = (QueryRequest)requestEnvelope.getBody().getBodyEntry();
        QueryResult[] results = response.getResult();
        Query[] queries = request.getQuery();
        if (queries.length != results.length) {
            throw new RuntimeException("Invalid request");
        }
        if (queries.length == 1) {
            retval = QueryMultiple.processSingleQuery(theContext, queries[0], results[0]);
        } else {
            for (int i = 0; i < queries.length; ++i) {
                MessageContext newMC = theContext.createMessageContextForNewRequest(QueryMultiple.getQueryBody(queries[i]));
                QueryMultiple.propagateKey(theContext, newMC, "com.ibm.cognos.camaaa.internal.common.handler.message.visa");
                retval = QueryMultiple.processSingleQuery(newMC, queries[i], results[i]);
                if (!retval) break;
            }
        }
        return retval;
    }
}

