/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class QueryUserAccountInfo
extends DefaultHandler {
    private static final String COGNOS_NAMESPACE = "";
    private static final String[] ANONYMOUS_USER_INFO_PROPERTIES = new String[]{"searchPath", "name", "userName", "ancestors"};
    private static final String[] NAMED_USER_INFO_PROPERTIES = new String[]{"searchPath", "name", "userName", "ancestors", "memberOf"};
    private final HashMap<String, String[]> additionalPropertiesToQuery = new HashMap();

    private void addAdditionalPropsToQuery(Map<String, String> advancedProperties, String nsId) {
        String additionalProps = advancedProperties.get("AdditionalUserPropertiesToQuery");
        if (additionalProps != null) {
            String[] addtionalPropsArray = additionalProps.split(",");
            LinkedHashSet<String> propsList = new LinkedHashSet<String>();
            for (int i = 0; i < addtionalPropsArray.length; ++i) {
                String prop = addtionalPropsArray[i].trim();
                if (COGNOS_NAMESPACE.equals(prop)) continue;
                propsList.add(prop);
            }
            if (propsList.size() > 0) {
                this.additionalPropertiesToQuery.put(nsId, propsList.toArray(new String[propsList.size()]));
            }
        }
    }

    private String getAccountSearchPathForNamespace(String theNamespaceID) throws SoapFaultException {
        SearchPathImpl nsSearchPath = new SearchPathImpl(theNamespaceID, null);
        return nsSearchPath.getValue() + "//~";
    }

    private String[] getAdditionalPropsToQuery(String theNamespaceID) {
        String[] additionalProps = this.additionalPropertiesToQuery.get(theNamespaceID);
        if (additionalProps == null && (additionalProps = this.additionalPropertiesToQuery.get(null)) == null) {
            return new String[0];
        }
        return additionalProps;
    }

    private String[] getUserInfoProperties(String theNamespaceID) {
        String[] ret;
        if (theNamespaceID.equals(COGNOS_NAMESPACE)) {
            ret = ANONYMOUS_USER_INFO_PROPERTIES;
        } else {
            int i;
            String[] additionalProps = this.getAdditionalPropsToQuery(theNamespaceID);
            LinkedHashSet<String> namedUserInfoProps = new LinkedHashSet<String>();
            for (i = 0; i < NAMED_USER_INFO_PROPERTIES.length; ++i) {
                namedUserInfoProps.add(NAMED_USER_INFO_PROPERTIES[i]);
            }
            for (i = 0; i < additionalProps.length; ++i) {
                namedUserInfoProps.add(additionalProps[i]);
            }
            ret = namedUserInfoProps.toArray(new String[namedUserInfoProps.size()]);
        }
        return ret;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String targetNamespace = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        String searchExpression = this.getAccountSearchPathForNamespace(targetNamespace);
        String[] properties = this.getUserInfoProperties(targetNamespace);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.searchTargetNamespace", (Object)targetNamespace);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.searchPath", (Object)searchExpression);
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.admin.properties", (Object)properties);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        Map<String, String> advancedProperties = config.getAdvancedProperties();
        this.addAdditionalPropsToQuery(advancedProperties, null);
        Configuration[] namespaceConfigs = config.getConfiguration("./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance']");
        if (namespaceConfigs != null) {
            for (int i = 0; i < namespaceConfigs.length; ++i) {
                Configuration nsConfig = namespaceConfigs[i];
                String type = nsConfig.getMandatoryValue("./@class");
                if ("Cognos".equals(type)) continue;
                String nsId = nsConfig.getMandatoryValue("./*[local-name()='parameter'][@name='id']/*[local-name()='value']/text()");
                this.addAdditionalPropsToQuery(nsConfig.getAdvancedProperties(), nsId);
            }
        }
    }
}

