/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.handler.SetIdentityRequestBuilder;
import com.ibm.cognos.camaaa.internal.common.soap.CamSection;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SetIdentityOnCM
extends DefaultHandler {
    private static final String UTF8 = "UTF8";
    private ICMAccessor cm;
    private TrustedRequestSession session;

    public SetIdentityOnCM() {
    }

    protected SetIdentityOnCM(ICMAccessor cmAccessor, TrustedRequestSession trustedSession) {
        this.cm = cmAccessor;
        this.session = trustedSession;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.cm = CMAccessor.getInstance();
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createTrustedSession();
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        String trustedRequest = this.createTrustedRequest(theContext);
        this.cm.invoke(trustedRequest);
        return true;
    }

    private String createTrustedRequest(MessageContext theContext) throws InternalErrorException {
        QueryResult userInfoQueryResult = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
        BaseClass[] baseObjects = userInfoQueryResult.getAll();
        Account userObject = (Account)baseObjects[0];
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        Set<String> identity = passport.getIdentity();
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        SoapEnvelopeResponse soapEnvResponse = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        CamSection cam = soapEnvResponse.getHeader().getBiBusHeader().getCamSection();
        Element newRequest = this.buildRequest(userObject, identity, requestContext, soapEnvResponse, cam);
        try {
            return new String(this.session.setMessageTrust("CAMSASVC", newRequest.asXML().getBytes(UTF8)), UTF8);
        }
        catch (CAMCryptoException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException(this.getClass().toString(), e);
        }
    }

    protected Element buildRequest(Account userObject, Set<String> identity, RequestContext requestContext, SoapEnvelopeResponse soapEnvResponse, CamSection cam) throws InternalErrorException {
        Element requestBody = SetIdentityRequestBuilder.createRequestBodyForSetIdentity(userObject, identity, cam, requestContext);
        try {
            Element newRequest = CMAccessor.createCMRequest(requestBody, (SoapEnvelope)soapEnvResponse);
            SoapEnvelopeRequestImpl.removeNonPropagatableRequestElements(newRequest);
            return newRequest;
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
    }
}

