/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class BaseClassImpl
implements BaseClass {
    public static final String ANCESTORS_PROPERTY = "ancestors";
    public static final String NAME_PROPERTY = "name";
    public static final String DEFAULT_NAME_PROPERTY = "defaultName";
    public static final String HAS_CHILDREN_PROPERTY = "hasChildren";
    public static final String SEARCH_PATH_PROPERTY = "searchPath";
    public static final String OBJECT_CLASS_PROPERTY = "objectClass";
    public static final String TENANT_ID_PROPERTY = "tenantID";
    public static final String DISABLED_PROPERTY = "disabled";
    static final String OBJECT_CLASS_VALUE = "baseClass";
    private HashMap names;
    private BaseClass[] ancestors;
    private Boolean hasChildren;
    private final SearchPath searchPath;
    private final HashSet propertiesWithValues = new HashSet();
    private Object userData;
    private String tenantID;
    private boolean disabled;

    public BaseClassImpl(SearchPath theSearchPath) {
        this.searchPath = theSearchPath;
        this.propertiesWithValues.add(SEARCH_PATH_PROPERTY);
        this.propertiesWithValues.add(OBJECT_CLASS_PROPERTY);
        this.userData = null;
        this.tenantID = "";
        this.disabled = false;
    }

    public void addName(Locale theLocale, String theName) {
        if (this.names == null) {
            this.names = new HashMap();
        }
        if (theLocale != null || theName != null) {
            this.names.put(theLocale, theName);
        }
        this.propertiesWithValues.add(NAME_PROPERTY);
        this.propertiesWithValues.add(DEFAULT_NAME_PROPERTY);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof BaseClassImpl) {
            BaseClassImpl rhs = (BaseClassImpl)obj;
            isEqual = this.searchPath.equals(rhs.searchPath);
        }
        return isEqual;
    }

    public BaseClass[] getAncestors() {
        return this.ancestors;
    }

    public Locale[] getAvailableNameLocales() {
        if (this.names != null) {
            Set keySet = this.names.keySet();
            Locale[] array = new Locale[keySet.size()];
            return keySet.toArray(array);
        }
        return null;
    }

    public String getDefaultName(RequestContext requestContext) {
        Locale[] locales;
        String defaultName = null;
        if (requestContext != null) {
            defaultName = this.getName(requestContext.getContentLocale());
        }
        if (defaultName == null) {
            defaultName = this.getName(null);
        }
        if (defaultName == null && requestContext != null) {
            defaultName = this.getName(requestContext.getServerLocale());
        }
        if (defaultName == null && (locales = this.getAvailableNameLocales()) != null && locales.length > 0) {
            defaultName = this.getName(locales[0]);
        }
        return defaultName;
    }

    public Boolean getHasChildren() {
        return this.hasChildren;
    }

    public String getName(Locale theLocale) {
        if (this.names != null) {
            return (String)this.names.get(theLocale);
        }
        return null;
    }

    public String getObjectClass() {
        return OBJECT_CLASS_VALUE;
    }

    public Set getPropertiesWithValue() {
        return Collections.unmodifiableSet(this.propertiesWithValues);
    }

    public SearchPath getSearchPath() {
        return this.searchPath;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int hashCode() {
        return this.searchPath.hashCode();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected void propertyHasValue(String thePropertyName) {
        this.propertiesWithValues.add(thePropertyName);
    }

    public void setAncestors(BaseClass[] theAncestors) {
        if (theAncestors == null) {
            throw new IllegalArgumentException();
        }
        this.ancestors = theAncestors;
        this.propertiesWithValues.add(ANCESTORS_PROPERTY);
    }

    public void setAncestors(Namespace theNamespace, BaseClass[] theAncestorsWithinNamespace) {
        int i;
        if (theNamespace == null || theAncestorsWithinNamespace == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> objectAncestors = new ArrayList<Object>();
        BaseClass[] nsAncestors = theNamespace.getAncestors();
        if (nsAncestors != null) {
            for (i = 0; i < nsAncestors.length; ++i) {
                objectAncestors.add(nsAncestors[i]);
            }
        }
        objectAncestors.add(theNamespace);
        for (i = 0; i < theAncestorsWithinNamespace.length; ++i) {
            objectAncestors.add(theAncestorsWithinNamespace[i]);
        }
        this.setAncestors(objectAncestors.toArray(new BaseClass[0]));
    }

    public void setDisabled(boolean theDisabledFlags) {
        this.disabled = theDisabledFlags;
        this.propertiesWithValues.add(DISABLED_PROPERTY);
    }

    public void setHasChildren(Boolean theHasChildrenFlag) {
        this.hasChildren = theHasChildrenFlag;
        this.propertiesWithValues.add(HAS_CHILDREN_PROPERTY);
    }

    public void setTenantID(String theTenantID) {
        this.tenantID = theTenantID;
        this.propertiesWithValues.add(TENANT_ID_PROPERTY);
    }

    public void setUserData(Object theUserData) {
        this.userData = theUserData;
    }
}

