/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.DistributionList;
import com.ibm.cognos.camaaa.internal.admin.soap.Group;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.Role;
import com.ibm.cognos.camaaa.internal.admin.soap.Serializer;
import com.ibm.cognos.camaaa.internal.admin.soap.Session;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClass;
import com.ibm.cognos.camaaa.internal.admin.soap.UiClassWithMembers;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;

public abstract class BaseSerializer
implements Serializer {
    protected static final String XSD_NS_PREFIX = "xsd";
    protected static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    protected static final String XSD_STRING = "xsd:string";
    protected static final String SOAPENC_ARRAY = "SOAP-ENC:Array";
    protected static final String SOAPENC_ARRAYTYPE = "SOAP-ENC:arrayType";
    protected static final String XSI_TYPE = "xsi:type";
    protected static final String XML_SPACE = "xml:space";
    protected static final String PRESERVE = "preserve";
    protected static final String STRING_PROP = "bus:stringProp";
    protected static final String CLASS_ENUM_PROP = "bus:classEnumProp";
    protected static final String CLASS_ENUM = "bus:classEnum";
    protected static final String LANGUAGE_PROP = "bus:languageProp";
    protected static final String ANCESTOR_INFO_ARRAY_PROP = "bus:ancestorInfoArrayProp";
    protected static final String ANCESTOR_INFO = "bus:ancestorInfo";
    protected static final String TOKEN_PROP = "bus:tokenProp";
    protected static final String MULTILINGUAL_TOKEN_PROP = "bus:multilingualTokenProp";
    protected static final String MULTILINGUAL_TOKEN = "bus:multilingualToken";
    protected static final String BASECLASS_ARRAYPROP = "bus:baseClassArrayProp";
    protected static final String BASECLASS = "bus:baseClass";
    protected static final String MULTILINGUAL_STRING_PROP = "bus:multilingualStringProp";
    protected static final String MULTILINGUAL_STRING = "bus:multilingualString";
    protected static final String PARAMETER_VALUE_ARRAYPROP = "bus:parameterValueArrayProp";
    protected static final String PARAMETER_VALUE = "bus:parameterValue";
    protected static final String PARMVALUE_ITEM = "bus:parmValueItem";
    protected static final String SIMPLE_PARM_VALUE_ITEM = "bus:simpleParmValueItem";
    protected static final String BOOLEAN_PROP = "bus:booleanProp";
    protected static final String XSD_BOOLEAN = "xsd:boolean";
    protected static final String STRING_ARRAY_PROP = "xsd:stringArrayProp";
    protected static final String ARRAY_OF_STRING = "xsd:arrayOfString";
    protected static final String XSI_NIL = "xsi:nil";
    protected static final String VALUE = "value";
    protected static final String ITEM = "item";
    protected static final String NAME = "name";
    protected static final String DEFAULT_NAME = "defaultName";
    protected static final String INCLUSIVE = "inclusive";
    protected static final String DISPLAY = "display";
    protected static final String USE = "use";
    protected static final String LOCALE = "locale";
    protected static final String OBJECT_CLASS = "objectClass";
    protected static final String ANCESTORS = "ancestors";
    protected static final String SEARCHPATH = "searchPath";
    protected static final String TITLE = "title";
    protected static final String MEMBERS = "members";
    protected static final String SECURITY_MEMBERS = "securityMembers";
    protected static final String DISTRIBUTION_MEMBERS = "distributionMembers";
    protected static final String DESCRIPTION = "description";
    protected static final String DEFAULT_DESCRIPTION = "defaultDescription";
    protected static final String HAS_CHILDREN = "hasChildren";
    protected static final String PARAMETERS = "parameters";
    protected static final String TRUE = "true";
    protected static final String MEMBER_OF = "memberOf";
    protected static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final String SEARCH_VALUE_XPATH_EXPRESSION = "./*[local-name()='searchPath']/*[local-name()='value']";
    private static final XPath SEARCH_VALUE_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='searchPath']/*[local-name()='value']");
    private static final String ITEM_XPATH_EXPRESSION = "./*[local-name()='item']";
    private static final XPath ITEM_XPATH = DocumentHelper.createXPath((String)"./*[local-name()='item']");

    protected static String getContentLocale(Locale theLocale, RequestContext theRequestContext) {
        Locale locale = theLocale;
        if (theLocale == null && theRequestContext.getContentLocale() != null) {
            locale = theRequestContext.getContentLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        locale = BaseSerializer.getMappedContentLocale(locale);
        return locale.toString();
    }

    private static Locale getMappedContentLocale(Locale theContentLocale) {
        Locale contentLocale = null;
        if (theContentLocale != null && !theContentLocale.toString().isEmpty()) {
            try {
                String locale = cclConfig.normalizeLocale(theContentLocale.toString());
                if (!cclConfig.validateContentLocale(locale)) {
                    locale = cclConfig.mapContentLocale(locale, false);
                }
                if (locale != null) {
                    contentLocale = new Locale(locale);
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return contentLocale;
    }

    private static Locale getMappedProductLocale(Locale theProductLocale) {
        Locale productLocale = null;
        if (theProductLocale != null && !theProductLocale.toString().isEmpty()) {
            try {
                String locale = cclConfig.normalizeLocale(theProductLocale.toString());
                if (!cclConfig.validateProductLocale(locale)) {
                    locale = cclConfig.mapProductLocale(locale, false);
                }
                if (locale != null) {
                    productLocale = new Locale(locale);
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return productLocale;
    }

    protected static Element getObjectItem(BaseClass theObject, Element queryResultElement) {
        String camID = theObject.getSearchPath().getValue();
        List items = DocumentHelper.selectNodes((XPath)ITEM_XPATH, (Node)queryResultElement);
        for (int i = 0; i < items.size(); ++i) {
            Element item = (Element)items.get(i);
            String searchPath = DocumentHelper.valueOf((XPath)SEARCH_VALUE_XPATH, (Node)item);
            if (!searchPath.equals(camID)) continue;
            return item;
        }
        return null;
    }

    protected static Set getRefPropSet(String refPropfForWhichAttribute, QueryOptions queryOptions) {
        String[] refPropStrArray;
        HashSet<String> refPropSet = new HashSet<String>();
        if (queryOptions != null && (refPropStrArray = queryOptions.getRefProps(refPropfForWhichAttribute)) != null) {
            for (int i = 0; i < refPropStrArray.length; ++i) {
                refPropSet.add(refPropStrArray[i]);
            }
        }
        return refPropSet;
    }

    static void setCCLConfig(ICCLConfiguration config) {
        if (config != null) {
            cclConfig = config;
        }
    }

    protected void addAccountParameter(Account theObject, Element value, String[] propNames, int index) {
        Element item = value.addElement(ITEM);
        item.addAttribute(XSI_TYPE, PARAMETER_VALUE);
        Element name = item.addElement(NAME);
        name.addAttribute(XSI_TYPE, XSD_STRING);
        name.addText(propNames[index]);
        String[] propValues = theObject.getParameterValue(propNames[index]);
        int valLength = propValues.length;
        Element propValuesElement = this.createArrayElement(item, VALUE, PARMVALUE_ITEM, valLength);
        for (int nVal = 0; nVal < valLength; ++nVal) {
            Element propValueItem = propValuesElement.addElement(ITEM);
            propValueItem.addAttribute(XSI_TYPE, SIMPLE_PARM_VALUE_ITEM);
            Element inclusive = propValueItem.addElement(INCLUSIVE);
            inclusive.addAttribute(XSI_TYPE, XSD_BOOLEAN);
            inclusive.addText(TRUE);
            Element display = propValueItem.addElement(DISPLAY);
            display.addAttribute(XSI_TYPE, XSD_STRING);
            Element use = propValueItem.addElement(USE);
            use.addAttribute(XSI_TYPE, XSD_STRING);
            String valueStr = propValues[nVal];
            if (valueStr != null) {
                display.addText(valueStr);
                use.addText(valueStr);
                continue;
            }
            this.addValueNotSpecified(display);
            this.addValueNotSpecified(use);
        }
    }

    protected void addAncestors(BaseClass theObject, RequestContext theRequestContext, Element item, Set expectedPropSet, Set unSupportedPropSet) {
        if (expectedPropSet.contains(ANCESTORS)) {
            BaseClass[] ancestors = theObject.getAncestors();
            Element ancestorsElement = item.addElement(ANCESTORS);
            ancestorsElement.addAttribute(XSI_TYPE, ANCESTOR_INFO_ARRAY_PROP);
            Element ancestorsValue = this.createArrayElement(ancestorsElement, VALUE, ANCESTOR_INFO, ancestors.length);
            for (int i = 0; i < ancestors.length; ++i) {
                Element ancestorItem = ancestorsValue.addElement(ITEM);
                ancestorItem.addAttribute(XSI_TYPE, ANCESTOR_INFO);
                Element objectClassElement = ancestorItem.addElement(OBJECT_CLASS);
                objectClassElement.addAttribute(XSI_TYPE, CLASS_ENUM);
                objectClassElement.addText(ancestors[i].getObjectClass());
                Element searchPathElement = ancestorItem.addElement(SEARCHPATH);
                searchPathElement.addAttribute(XSI_TYPE, XSD_STRING);
                searchPathElement.addAttribute(XML_SPACE, PRESERVE);
                searchPathElement.addText(ancestors[i].getSearchPath().getValue());
                String title = ancestors[i].getDefaultName(theRequestContext);
                Element titleElement = ancestorItem.addElement(TITLE);
                titleElement.addAttribute(XSI_TYPE, XSD_STRING);
                if (title != null) {
                    titleElement.addAttribute(XML_SPACE, PRESERVE);
                    titleElement.addText(title);
                    continue;
                }
                this.addValueNotSpecified(titleElement);
            }
            this.addMetaData(true, ancestorsElement);
        } else if (unSupportedPropSet.contains(ANCESTORS)) {
            this.addUnsupportedMetaData(item, ANCESTORS, ANCESTOR_INFO_ARRAY_PROP);
        }
    }

    protected void addDefaultDescription(UiClass theObject, RequestContext theRequestContext, Set thePropertySet, Set unSupportedPropSet, Element parentElement) {
        if (thePropertySet.contains(DEFAULT_DESCRIPTION)) {
            Element defaultDescriptionElement = parentElement.addElement(DEFAULT_DESCRIPTION);
            defaultDescriptionElement.addAttribute(XSI_TYPE, STRING_PROP);
            Element valueElement = defaultDescriptionElement.addElement(VALUE);
            valueElement.addAttribute(XSI_TYPE, XSD_STRING);
            String defaultDescription = theObject.getDefaultDescription(theRequestContext);
            if (defaultDescription != null) {
                valueElement.addText(defaultDescription);
            } else {
                this.addValueNotSpecified(valueElement);
            }
            this.addMetaData(true, defaultDescriptionElement);
        } else if (unSupportedPropSet.contains(DEFAULT_DESCRIPTION)) {
            this.addUnsupportedMetaData(parentElement, DEFAULT_DESCRIPTION, STRING_PROP);
        }
    }

    protected void addDefaultName(BaseClass theObject, RequestContext theRequestContext, Element item, Set expectedPropSet, Set unSupportedPropSet) {
        if (expectedPropSet.contains(DEFAULT_NAME)) {
            Element defaultNameElement = item.addElement(DEFAULT_NAME);
            defaultNameElement.addAttribute(XSI_TYPE, TOKEN_PROP);
            Element valueElement = defaultNameElement.addElement(VALUE);
            valueElement.addAttribute(XSI_TYPE, XSD_STRING);
            String defaultName = theObject.getDefaultName(theRequestContext);
            if (defaultName != null) {
                valueElement.addText(defaultName);
            } else {
                this.addValueNotSpecified(valueElement);
            }
            this.addMetaData(true, defaultNameElement);
        } else if (unSupportedPropSet.contains(DEFAULT_NAME)) {
            this.addUnsupportedMetaData(item, DEFAULT_NAME, TOKEN_PROP);
        }
    }

    protected void addDescription(UiClass theObject, RequestContext theRequestContext, Set thePropertySet, Set unSupportedPropSet, Element parentElement) {
        if (thePropertySet.contains(DESCRIPTION)) {
            Locale[] locales = theObject.getAvailableDescriptionLocales();
            int len = 0;
            if (locales != null) {
                len = locales.length;
            }
            Element descriptionElement = parentElement.addElement(DESCRIPTION);
            descriptionElement.addAttribute(XSI_TYPE, MULTILINGUAL_STRING_PROP);
            Element valueElement = this.createArrayElement(descriptionElement, VALUE, MULTILINGUAL_STRING, len);
            for (int i = 0; i < len; ++i) {
                String description = theObject.getDescription(locales[i]);
                Element item = valueElement.addElement(ITEM);
                item.addAttribute(XSI_TYPE, MULTILINGUAL_STRING);
                Element localeElement = item.addElement(LOCALE);
                localeElement.addAttribute(XSI_TYPE, XSD_STRING);
                String localeString = BaseSerializer.getContentLocale(locales[i], theRequestContext);
                if (localeString != null) {
                    localeElement.addText(localeString);
                } else {
                    this.addValueNotSpecified(localeElement);
                }
                Element value = item.addElement(VALUE);
                value.addAttribute(XSI_TYPE, XSD_STRING);
                if (description != null) {
                    value.addAttribute(XML_SPACE, PRESERVE);
                    value.addText(description);
                    continue;
                }
                this.addValueNotSpecified(value);
            }
            this.addMetaData(true, descriptionElement);
        } else if (unSupportedPropSet.contains(DESCRIPTION)) {
            this.addUnsupportedMetaData(parentElement, DESCRIPTION, MULTILINGUAL_STRING_PROP);
        }
    }

    protected void addHasChildren(BaseClass theObject, Element item, Set expectedPropSet, Set unSupportedPropSet) {
        if (expectedPropSet.contains(HAS_CHILDREN)) {
            Element hasChildrenElement = item.addElement(HAS_CHILDREN);
            hasChildrenElement.addAttribute(XSI_TYPE, BOOLEAN_PROP);
            Element hasChildrenValue = hasChildrenElement.addElement(VALUE);
            hasChildrenValue.addAttribute(XSI_TYPE, XSD_BOOLEAN);
            Boolean val = theObject.getHasChildren();
            if (val != null) {
                hasChildrenValue.addText(val.toString());
            } else {
                this.addValueNotSpecified(hasChildrenValue);
            }
            this.addMetaData(true, hasChildrenElement);
        } else if (unSupportedPropSet.contains(HAS_CHILDREN)) {
            this.addUnsupportedMetaData(item, HAS_CHILDREN, BOOLEAN_PROP);
        }
    }

    protected void addLanguageProp(Set thePropertySet, Set unSupportedPropSet, String theName, Locale theValue, Element parentElement) {
        if (thePropertySet.contains(theName)) {
            Element nameElement = parentElement.addElement(theName);
            nameElement.addAttribute(XSI_TYPE, LANGUAGE_PROP);
            Element value = nameElement.addElement(VALUE);
            value.addAttribute(XSI_TYPE, XSD_STRING);
            if (theValue != null) {
                value.addAttribute(XML_SPACE, PRESERVE);
                value.addText(theValue.toString());
            } else {
                this.addValueNotSpecified(value);
            }
            this.addMetaData(true, nameElement);
        } else if (unSupportedPropSet.contains(theName)) {
            this.addUnsupportedMetaData(parentElement, theName, LANGUAGE_PROP);
        }
    }

    protected void addMemberOfProp(Account theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        BaseClass[] memberOf = theObject.getMemberOf();
        Set refPropSet = BaseSerializer.getRefPropSet(MEMBER_OF, queryOptions);
        if (thePropertySet.contains(MEMBER_OF)) {
            Element memberOfElement = parentElement.addElement(MEMBER_OF);
            this.serializeObject(theRequestContext, refPropSet, queryOptions, memberOf, memberOfElement);
            this.addMetaData(true, memberOfElement);
        } else if (unSupportedPropSet.contains(NAME)) {
            this.addUnsupportedMetaData(parentElement, MEMBER_OF, BASECLASS_ARRAYPROP);
        }
    }

    protected void addMetaData(boolean supported, Element propElement) {
        Element metaData = propElement.addElement("metadata");
        Element supportElement = metaData.addElement("supported");
        supportElement.addAttribute(XSI_TYPE, XSD_BOOLEAN);
        supportElement.addText(Boolean.valueOf(supported).toString());
    }

    protected void addName(BaseClass theObject, RequestContext theRequestContext, Element item, Set expectedPropSet, Set unSupportedPropSet) {
        if (expectedPropSet.contains(NAME)) {
            Locale[] locales = theObject.getAvailableNameLocales();
            int len = 0;
            if (locales != null) {
                len = locales.length;
            }
            Element nameElement = item.addElement(NAME);
            nameElement.addAttribute(XSI_TYPE, MULTILINGUAL_TOKEN_PROP);
            Element nameValue = this.createArrayElement(nameElement, VALUE, MULTILINGUAL_TOKEN, len);
            for (int i = 0; i < len; ++i) {
                Element valueItem = nameValue.addElement(ITEM);
                valueItem.addAttribute(XSI_TYPE, MULTILINGUAL_TOKEN);
                Element localElement = valueItem.addElement(LOCALE);
                localElement.addAttribute(XSI_TYPE, XSD_STRING);
                String localeString = BaseSerializer.getContentLocale(locales[i], theRequestContext);
                if (localeString != null) {
                    localElement.addText(localeString);
                } else {
                    this.addValueNotSpecified(localElement);
                }
                String name = theObject.getName(locales[i]);
                Element localeValueItem = valueItem.addElement(VALUE);
                localeValueItem.addAttribute(XSI_TYPE, XSD_STRING);
                if (name != null) {
                    localeValueItem.addAttribute(XML_SPACE, PRESERVE);
                    localeValueItem.addText(name);
                    continue;
                }
                this.addValueNotSpecified(localeValueItem);
            }
            this.addMetaData(true, nameElement);
        } else if (unSupportedPropSet.contains(NAME)) {
            this.addUnsupportedMetaData(item, NAME, MULTILINGUAL_TOKEN_PROP);
        }
    }

    protected void addNames(BaseClass theObject, RequestContext theRequestContext, Element item, Set expectedPropSet, Set unSupportedPropSet) {
        this.addDefaultName(theObject, theRequestContext, item, expectedPropSet, unSupportedPropSet);
        this.addName(theObject, theRequestContext, item, expectedPropSet, unSupportedPropSet);
    }

    protected void addObjectClass(BaseClass theObject, Element item, Set expectedPropSet) {
        String objectClass = theObject.getObjectClass();
        if (objectClass != null) {
            if (objectClass.equalsIgnoreCase("baseClass")) {
                item.addAttribute(XSI_TYPE, "bus:nil");
            } else {
                item.addAttribute(XSI_TYPE, "bus:" + objectClass);
            }
            if (expectedPropSet.contains(OBJECT_CLASS)) {
                Element objectClassElement = item.addElement(OBJECT_CLASS);
                objectClassElement.addAttribute(XSI_TYPE, CLASS_ENUM_PROP);
                Element valueElement = objectClassElement.addElement(VALUE);
                valueElement.addAttribute(XSI_TYPE, CLASS_ENUM);
                valueElement.addText(objectClass);
                this.addMetaData(true, objectClassElement);
            }
        } else {
            throw new RuntimeException("Each object should always have its objectClass");
        }
    }

    protected void addStringArrayProp(Set thePropertySet, Set unSupportedPropSet, String theName, String[] values, Element parentElement) {
        if (thePropertySet.contains(theName)) {
            Element nameElement;
            if (values != null) {
                nameElement = this.createArrayElement(parentElement, theName, XSD_STRING, values.length);
                for (String value : values) {
                    Element stringElement = nameElement.addElement(ITEM);
                    stringElement.addAttribute(XSI_TYPE, XSD_STRING);
                    stringElement.addAttribute(XML_SPACE, PRESERVE);
                    stringElement.setText(value);
                }
            } else {
                nameElement = parentElement.addElement(theName);
                this.addValueNotSpecified(nameElement);
            }
            this.addMetaData(true, nameElement);
        } else if (unSupportedPropSet.contains(theName)) {
            this.addUnsupportedMetaData(parentElement, theName, STRING_PROP);
        }
    }

    protected void addStringProp(Set thePropertySet, Set unSupportedPropSet, String theName, String theValue, Element parentElement) {
        if (theName.equals(SEARCHPATH) || thePropertySet.contains(theName)) {
            Element nameElement = parentElement.addElement(theName);
            nameElement.addAttribute(XSI_TYPE, STRING_PROP);
            Element value = nameElement.addElement(VALUE);
            value.addAttribute(XSI_TYPE, XSD_STRING);
            if (theValue != null) {
                value.addAttribute(XML_SPACE, PRESERVE);
                value.addText(theValue);
            } else {
                this.addValueNotSpecified(value);
            }
            this.addMetaData(true, nameElement);
        } else if (unSupportedPropSet.contains(theName)) {
            this.addUnsupportedMetaData(parentElement, theName, STRING_PROP);
        }
    }

    protected void addUnsupportedMetaData(Element parentElement, String elementName, String type) {
        Element element = parentElement.addElement(elementName);
        element.addAttribute(XSI_TYPE, type);
        this.addMetaData(false, element);
    }

    protected void addValueNotSpecified(Element valueElement) {
        valueElement.addAttribute(XSI_NIL, TRUE);
        valueElement.addAttribute(XML_SPACE, PRESERVE);
    }

    protected Element createArrayElement(Element parentElement, String elementName, String arrayType, int length) {
        Element arrayElement = parentElement.addElement(elementName);
        arrayElement.addAttribute(XSI_TYPE, SOAPENC_ARRAY);
        arrayElement.addAttribute(SOAPENC_ARRAYTYPE, arrayType + "[" + length + "]");
        return arrayElement;
    }

    @Override
    public boolean serialize(BaseClass theObject, RequestContext theRequestContext, Set thePropSet, QueryOptions queryOptions, Element parentElement) {
        HashSet<String> expectedPropSet = new HashSet<String>(theObject.getPropertiesWithValue());
        HashSet unsupportedPropSet = new HashSet();
        if (thePropSet != null) {
            unsupportedPropSet.addAll(thePropSet);
        }
        unsupportedPropSet.removeAll(expectedPropSet);
        if (thePropSet == null) {
            expectedPropSet.clear();
        } else {
            expectedPropSet.retainAll(thePropSet);
        }
        Element item = parentElement.addElement(ITEM);
        item.add(new org.dom4j.Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/"));
        item.add(new org.dom4j.Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/"));
        item.add(new org.dom4j.Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        item.add(new org.dom4j.Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/"));
        item.add(new org.dom4j.Namespace(XSD_NS_PREFIX, XSD_NS_URI));
        this.addObjectClass(theObject, item, expectedPropSet);
        this.addStringProp(expectedPropSet, unsupportedPropSet, SEARCHPATH, theObject.getSearchPath().getValue(), item);
        String tenantID = theObject.getTenantID();
        if (!tenantID.isEmpty()) {
            expectedPropSet.add("tenantID");
        }
        this.addStringProp(expectedPropSet, unsupportedPropSet, "tenantID", theObject.getTenantID(), item);
        this.addAncestors(theObject, theRequestContext, item, expectedPropSet, unsupportedPropSet);
        this.addNames(theObject, theRequestContext, item, expectedPropSet, unsupportedPropSet);
        this.addHasChildren(theObject, item, expectedPropSet, unsupportedPropSet);
        this.serializeUiClass(theObject, theRequestContext, expectedPropSet, unsupportedPropSet, item);
        if (theObject instanceof Namespace) {
            this.serializeNamespace((Namespace)theObject, expectedPropSet, unsupportedPropSet, item);
        } else if (theObject instanceof Account) {
            this.serializeAccount((Account)theObject, theRequestContext, expectedPropSet, queryOptions, unsupportedPropSet, item);
        } else if (theObject instanceof Group) {
            this.serializeGroup((Group)theObject, theRequestContext, expectedPropSet, queryOptions, unsupportedPropSet, item);
        } else if (theObject instanceof Role) {
            this.serializeRole((Role)theObject, theRequestContext, expectedPropSet, queryOptions, unsupportedPropSet, item);
        } else if (theObject instanceof DistributionList) {
            this.serializeDistributionList((DistributionList)theObject, theRequestContext, expectedPropSet, queryOptions, unsupportedPropSet, item);
        } else if (theObject instanceof Session) {
            this.serializeSession((Session)theObject, theRequestContext, expectedPropSet, queryOptions, unsupportedPropSet, item);
        }
        return true;
    }

    protected void serializeAccount(Account theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        String[] readTenantIDs;
        String writeTenantID;
        Set propsWithValues = theObject.getPropertiesWithValue();
        if (propsWithValues.contains("writeTenantID") && (writeTenantID = theObject.getWriteTenantID()) != null) {
            thePropertySet.add("writeTenantID");
            this.addStringProp(thePropertySet, unSupportedPropSet, "writeTenantID", writeTenantID, parentElement);
        }
        if (propsWithValues.contains("readTenantIDs") && (readTenantIDs = theObject.getReadTenantIDs()) != null) {
            thePropertySet.add("readTenantIDs");
            this.addStringArrayProp(thePropertySet, unSupportedPropSet, "readTenantIDs", readTenantIDs, parentElement);
        }
        this.addMemberOfProp(theObject, theRequestContext, thePropertySet, queryOptions, unSupportedPropSet, parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "businessPhone", theObject.getBusinessPhone(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "email", theObject.getEmail(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "faxPhone", theObject.getFaxPhone(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "givenName", theObject.getGivenName(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "homePhone", theObject.getHomePhone(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "mobilePhone", theObject.getMobilePhone(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "pagerPhone", theObject.getPagerPhone(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "postalAddress", theObject.getPostalAddress(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "surname", theObject.getSurname(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "userName", theObject.getUserName(), parentElement);
        this.addLanguageProp(thePropertySet, unSupportedPropSet, "contentLocale", BaseSerializer.getMappedContentLocale(theObject.getContentLocale()), parentElement);
        this.addLanguageProp(thePropertySet, unSupportedPropSet, "productLocale", BaseSerializer.getMappedProductLocale(theObject.getProductLocale()), parentElement);
        this.serializeAccountParameterProperties(thePropertySet, unSupportedPropSet, theObject, parentElement);
    }

    protected void serializeAccountParameterProperties(Set thePropertySet, Set unSupportedPropSet, Account theObject, Element parentElement) {
        if (thePropertySet.contains(PARAMETERS)) {
            String[] propNames = theObject.getParameterNames();
            Element parameters = parentElement.addElement(PARAMETERS);
            parameters.addAttribute(XSI_TYPE, PARAMETER_VALUE_ARRAYPROP);
            int propLength = propNames.length;
            Element value = this.createArrayElement(parameters, VALUE, PARAMETER_VALUE, propLength);
            for (int nProp = 0; nProp < propLength; ++nProp) {
                this.addAccountParameter(theObject, value, propNames, nProp);
            }
            this.addMetaData(true, parameters);
        } else if (unSupportedPropSet.contains(PARAMETERS)) {
            this.addUnsupportedMetaData(parentElement, PARAMETERS, PARAMETER_VALUE_ARRAYPROP);
        }
    }

    protected void serializeDistributionList(DistributionList theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        this.serializeUiClassWithMembers((UiClassWithMembers)theObject, theRequestContext, thePropertySet, queryOptions, unSupportedPropSet, parentElement);
    }

    protected void serializeUiClassWithMembers(UiClassWithMembers theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        Set refPropSet;
        if (thePropertySet.contains(MEMBERS)) {
            BaseClass[] members = theObject.getMembers();
            refPropSet = BaseSerializer.getRefPropSet(MEMBERS, queryOptions);
            Element membersElement = parentElement.addElement(MEMBERS);
            this.serializeObject(theRequestContext, refPropSet, queryOptions, members, membersElement);
            this.addMetaData(true, membersElement);
        } else if (unSupportedPropSet.contains(MEMBERS)) {
            this.addUnsupportedMetaData(parentElement, MEMBERS, BASECLASS_ARRAYPROP);
        }
        if (thePropertySet.contains(SECURITY_MEMBERS)) {
            BaseClass[] securityMembers = theObject.getSecurityMembers();
            refPropSet = BaseSerializer.getRefPropSet(SECURITY_MEMBERS, queryOptions);
            Element securityMembersElement = parentElement.addElement(SECURITY_MEMBERS);
            this.serializeObject(theRequestContext, refPropSet, queryOptions, securityMembers, securityMembersElement);
            this.addMetaData(true, securityMembersElement);
        } else if (unSupportedPropSet.contains(SECURITY_MEMBERS)) {
            this.addUnsupportedMetaData(parentElement, SECURITY_MEMBERS, BASECLASS_ARRAYPROP);
        }
        if (thePropertySet.contains(DISTRIBUTION_MEMBERS)) {
            BaseClass[] distributionMembers = theObject.getDistributionMembers();
            refPropSet = BaseSerializer.getRefPropSet(DISTRIBUTION_MEMBERS, queryOptions);
            Element distributionMembersElement = parentElement.addElement(DISTRIBUTION_MEMBERS);
            this.serializeObject(theRequestContext, refPropSet, queryOptions, distributionMembers, distributionMembersElement);
            this.addMetaData(true, distributionMembersElement);
        } else if (unSupportedPropSet.contains(DISTRIBUTION_MEMBERS)) {
            this.addUnsupportedMetaData(parentElement, DISTRIBUTION_MEMBERS, BASECLASS_ARRAYPROP);
        }
    }

    protected void serializeGroup(Group theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        this.serializeUiClassWithMembers((UiClassWithMembers)theObject, theRequestContext, thePropertySet, queryOptions, unSupportedPropSet, parentElement);
    }

    protected void serializeNamespace(Namespace theObject, Set thePropertySet, Set unSupportedPropSet, Element parentElement) {
        String[] capabilities = theObject.getCapabilities();
        if (thePropertySet.contains("capabilities")) {
            Element capabilityElement = parentElement.addElement("capabilities");
            capabilityElement.addAttribute(XSI_TYPE, STRING_ARRAY_PROP);
            Element value = capabilityElement.addElement(VALUE);
            value.addAttribute(XSI_TYPE, ARRAY_OF_STRING);
            if (capabilities != null) {
                for (int i = 0; i < capabilities.length; ++i) {
                    Element item = value.addElement(ITEM);
                    item.addAttribute(XSI_TYPE, XSD_STRING);
                    item.addAttribute(XML_SPACE, PRESERVE);
                    item.addText(capabilities[i]);
                }
            } else {
                this.addValueNotSpecified(value);
            }
            this.addMetaData(true, capabilityElement);
        } else if (unSupportedPropSet.contains("capabilities")) {
            this.addUnsupportedMetaData(parentElement, "capabilities", STRING_ARRAY_PROP);
        }
        this.addStringProp(thePropertySet, unSupportedPropSet, "namespaceFormat", theObject.getNamespaceFormat(), parentElement);
    }

    protected void serializeObject(RequestContext theRequestContext, Set refPropsSet, QueryOptions queryOptions, BaseClass[] objects, Element membersElement) {
        membersElement.addAttribute(XSI_TYPE, BASECLASS_ARRAYPROP);
        int numberOfObjects = 0;
        if (objects != null) {
            numberOfObjects = objects.length;
        }
        Element value = this.createArrayElement(membersElement, VALUE, BASECLASS, numberOfObjects);
        for (int i = 0; i < numberOfObjects; ++i) {
            this.serialize(objects[i], theRequestContext, refPropsSet, null, value);
        }
    }

    protected void serializeRole(Role theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        this.serializeUiClassWithMembers((UiClassWithMembers)theObject, theRequestContext, thePropertySet, queryOptions, unSupportedPropSet, parentElement);
    }

    protected void serializeSession(Session theObject, RequestContext theRequestContext, Set thePropertySet, QueryOptions queryOptions, Set unSupportedPropSet, Element parentElement) {
        String tenantId;
        Set propsWithValues = theObject.getPropertiesWithValue();
        if (propsWithValues.contains("tenantID") && (tenantId = theObject.getTenantID()) != null && !tenantId.equals("")) {
            thePropertySet.add("tenantID");
            this.addStringProp(thePropertySet, unSupportedPropSet, "tenantID", tenantId, parentElement);
        }
        this.addStringProp(thePropertySet, unSupportedPropSet, "namespace", theObject.getPrimaryNamespace(), parentElement);
        this.addStringProp(thePropertySet, unSupportedPropSet, "userName", theObject.getUsername(), parentElement);
    }

    protected void serializeUiClass(BaseClass theObject, RequestContext theRequestContext, Set thePropertySet, Set unSupportedPropSet, Element parentElement) {
        if (theObject instanceof UiClass) {
            UiClass uiClassObject = (UiClass)theObject;
            this.addDefaultDescription(uiClassObject, theRequestContext, thePropertySet, unSupportedPropSet, parentElement);
            this.addDescription(uiClassObject, theRequestContext, thePropertySet, unSupportedPropSet, parentElement);
        }
    }
}

