/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.Query;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterFunctionCall;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStepImpl;
import org.dom4j.Element;
import org.dom4j.QName;

public final class IQueryUtil {
    private static final QName QUERY_QNAME = QName.get((String)"query", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");

    private IQueryUtil() {
    }

    public static Element toLegacyQueryElement(Query query) {
        Element queryElement = ((QueryImpl)query).getQueryElement().createCopy();
        if (!QUERY_QNAME.getName().equals(queryElement.getQName().getName())) {
            queryElement.setQName(QUERY_QNAME);
        }
        Element searchElement = queryElement.element("search");
        SearchExpression searchExpression = query.getSearchExpression();
        StringBuffer searchSteps = new StringBuffer();
        IQueryUtil.serializeSearchSteps(searchExpression, searchSteps);
        searchElement.setText(searchSteps.toString());
        return queryElement;
    }

    public static String toLegacySearchExpression(Query query) {
        return IQueryUtil.toLegacyQueryElement(query).asXML();
    }

    private static boolean convertCAMFunct(StringBuffer buffer, String[] parms) {
        if (parms.length == 2) {
            buffer.append("CAMID(\"");
            buffer.append(parms[0]);
            if (parms[1] != null) {
                buffer.append(':');
                buffer.append(parms[1]);
            }
            buffer.append("\")");
            return true;
        }
        return false;
    }

    private static boolean isCAMFunction(SearchStepImpl step, StringBuffer buffer) {
        SearchFilterFunctionCall func;
        if (step.getAxis() == 5 && step.getNodeTest().equals("*") && step.getPredicate() != null && step.getPredicate().getSearchFilterType() == 2 && (func = (SearchFilterFunctionCall)step.getPredicate()).getFunctionName().equals("CAMID")) {
            String[] parms = func.getParameters();
            return IQueryUtil.convertCAMFunct(buffer, parms);
        }
        return false;
    }

    private static void serializeSearchSteps(SearchExpression searchExpression, StringBuffer buffer) {
        SearchStepImpl step;
        SearchStep[] steps = searchExpression.getSteps();
        if (steps.length > 0 && !IQueryUtil.isCAMFunction(step = (SearchStepImpl)steps[0], buffer)) {
            buffer.append(step.toString());
        }
        for (int i = 1; i < steps.length; ++i) {
            SearchStepImpl step2 = (SearchStepImpl)steps[i];
            buffer.append(step2.toString());
        }
    }
}

