/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.InternalQuery;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptionsImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpressionImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SortProperty;
import com.ibm.cognos.camaaa.internal.admin.soap.SortPropertyImpl;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class QueryImpl
implements InternalQuery {
    private static final String PROPERTIES = "properties";
    private static final String SEARCH = "search";
    private final Element query;
    private SearchExpression searchExpression;

    public QueryImpl(Element theQuery) throws SoapFaultException {
        this.query = theQuery;
        String expression = this.query.element(SEARCH).getText();
        this.searchExpression = new SearchExpressionImpl(expression);
    }

    public void addProperty(String extraProperty) {
        Element properties = this.query.element(PROPERTIES);
        boolean needToAdd = true;
        if (properties != null) {
            String[] propertyNames = this.getProperties();
            for (int i = 0; propertyNames != null && i < propertyNames.length; ++i) {
                if (propertyNames[i].compareToIgnoreCase(extraProperty) != 0) continue;
                needToAdd = false;
                break;
            }
            if (needToAdd) {
                Element item = properties.addElement("item");
                item.setText(extraProperty);
            }
        }
    }

    public String[] getProperties() {
        return this.getProperties(null);
    }

    private String[] getProperties(Set supportedProperties) {
        Element props = this.query.element(PROPERTIES);
        if (props != null) {
            ArrayList<String> properties = new ArrayList<String>();
            Iterator it = props.elementIterator();
            while (it.hasNext()) {
                Element item = (Element)it.next();
                String propName = item.getText();
                if (supportedProperties != null && !supportedProperties.contains(propName)) continue;
                properties.add(propName);
            }
            if (properties.size() > 0) {
                return properties.toArray(new String[properties.size()]);
            }
        }
        return null;
    }

    Element getQueryElement() {
        return this.query;
    }

    public QueryOptions getQueryOptions() {
        QueryOptionsImpl queryOptions = null;
        Element optionsElement = this.query.element("options");
        if (optionsElement != null) {
            queryOptions = new QueryOptionsImpl(optionsElement);
        }
        return queryOptions;
    }

    public SearchExpression getSearchExpression() {
        return this.searchExpression;
    }

    public SortProperty[] getSortProperties() {
        Element props = this.query.element("sortBy");
        if (props != null) {
            ArrayList<SortPropertyImpl> sortProperties = new ArrayList<SortPropertyImpl>();
            Iterator it = props.elementIterator();
            while (it.hasNext()) {
                Element item = (Element)it.next();
                sortProperties.add(new SortPropertyImpl(item));
            }
            return sortProperties.toArray(new SortPropertyImpl[sortProperties.size()]);
        }
        return null;
    }

    @Override
    public void setSearchExpression(SearchExpression newSearchExpression) {
        this.searchExpression = newSearchExpression;
        Element searchElement = this.query.element(SEARCH);
        if (searchElement != null) {
            searchElement.clearContent();
        } else {
            searchElement = this.query.addElement(SEARCH);
        }
        searchElement.addText(newSearchExpression.toString());
    }

    public String toString() {
        try {
            return DocumentHelper.toCompactUtf8String((Element)this.query, (boolean)true);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

