/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.QueryOptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

class QueryOptionsImpl
implements QueryOptions {
    private final Element queryOption;

    QueryOptionsImpl(Element theQueryOption) {
        this.queryOption = theQueryOption;
    }

    public long getMaxCount() {
        if (this.queryOption != null) {
            Element maxObjectsElement = this.queryOption.element("maxObjects");
            String value = null;
            if (maxObjectsElement != null) {
                value = maxObjectsElement.getText();
            }
            if (value != null && value.length() > 0) {
                return Integer.parseInt(value);
            }
        }
        return 0L;
    }

    public String[] getRefProps(String thePropertyName) {
        Element refPropsElement;
        if (thePropertyName != null && this.queryOption != null && (refPropsElement = this.queryOption.element("refProps")) != null) {
            return this.getRefProps(thePropertyName, refPropsElement);
        }
        return null;
    }

    private String[] getRefProps(String thePropertyName, Element refPropsElement) {
        ArrayList<String> refProps = new ArrayList<String>();
        Iterator it = refPropsElement.elementIterator();
        while (it.hasNext()) {
            Element item = (Element)it.next();
            Element refPropName = item.element("refPropName");
            if (refPropName == null || !thePropertyName.equals(refPropName.getText())) continue;
            Element properties = item.element("properties");
            if (properties == null) break;
            Iterator propsIt = properties.elementIterator();
            while (propsIt.hasNext()) {
                Element prop = (Element)propsIt.next();
                String value = prop.getText();
                this.add(refProps, value);
            }
            break block0;
        }
        if (refProps.size() > 0) {
            return refProps.toArray(new String[refProps.size()]);
        }
        return null;
    }

    private void add(ArrayList<String> refProps, String value) {
        if (value != null) {
            refProps.add(value);
        }
    }

    public long getSkipCount() {
        if (this.queryOption != null) {
            Element skipObjectsElement = this.queryOption.element("skipObjects");
            String value = null;
            if (skipObjectsElement != null) {
                value = skipObjectsElement.getText();
            }
            if (value != null && value.length() > 0) {
                return Integer.parseInt(value);
            }
        }
        return 0L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        OutputFormat outformat = OutputFormat.createCompactFormat();
        outformat.setSuppressDeclaration(true);
        outformat.setEncoding("UTF-8");
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)out, outformat);
            writer.write(this.queryOption);
            writer.flush();
            writer.close();
            buffer.append(out.toString());
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return buffer.toString();
    }
}

