/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.Literal;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchExpression;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilter;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterCamIdFunctionCallImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterConditionalExpressionImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterPropertyFunctionCallImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchFilterRelationalExpressionImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPathImpl;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStep;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchStepImpl;
import com.ibm.cognos.camaaa.internal.xpath.SearchExpressionParser;
import com.ibm.cognos.camaaa.internal.xpath.Token;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;

public class SearchExpressionImpl
implements SearchExpression {
    private static final int PARSER_POOL_SIZE = 20;
    private static final ArrayList<SearchExpressionParser> PARSER_POOL = new ArrayList(20);
    private static final String EXPECTED_A_PROPERTY = "Expected a property but got another literal ";
    private static final String EXPECTED_A_CONSTRAINT = "Expected a constraint but got another property ";
    private static final String UNEXPECTED_AXIS_VALUE = "Unexpected axis value: ";
    private static final String UNEXPECTED_FUNCTION = "Unexpected function ";
    private static final String EXPECTED_PARENTHESES = "Expected '(' after function name but got ";
    private static final String EXPECTED_PARAMETER = "Expected a parameter but got ";
    private static final String EXPECTED_NO_MORE_PARAMETERS = "Expected no more parameters but got ";
    private static final String WILDCARD = "*";
    private final Stack<SearchStep> steps = new Stack();
    private final String searchExpression;
    private boolean didParse;

    public SearchExpressionImpl(String theSearchExpression) {
        this.searchExpression = theSearchExpression;
        this.didParse = false;
    }

    private int getAxisAfterSlash(SearchExpressionParser theParser, Token token) {
        int axis;
        switch (token.kind) {
            case 34: {
                axis = 7;
                break;
            }
            case 33: {
                axis = 6;
                break;
            }
            case 17: {
                axis = this.getAxisFromName(token);
                theParser.getNextToken();
                break;
            }
            case 12: 
            case 13: 
            case 21: {
                axis = 3;
                break;
            }
            default: {
                throw new RuntimeException(UNEXPECTED_AXIS_VALUE + token.image);
            }
        }
        return axis;
    }

    private int getAxisFromName(Token token) {
        int axis;
        if (token.image.compareTo("ancestor::") == 0) {
            axis = 1;
        } else if (token.image.compareTo("child::") == 0) {
            axis = 3;
        } else if (token.image.compareTo("descendant::") == 0) {
            axis = 4;
        } else if (token.image.compareTo("descendant-or-self::") == 0) {
            axis = 5;
        } else if (token.image.compareTo("parent::") == 0) {
            axis = 3;
        } else if (token.image.compareTo("self::") == 0) {
            axis = 3;
        } else {
            throw new RuntimeException(UNEXPECTED_AXIS_VALUE + token.image);
        }
        return axis;
    }

    private String getPropertyName(SearchExpressionParser theParser) {
        String propertyName = null;
        Token token = theParser.token;
        if (token.kind != 22) {
            throw new RuntimeException("Expected property name but got " + token.image);
        }
        propertyName = token.image;
        token = theParser.getNextToken();
        return propertyName;
    }

    private String getRelationalOperator(SearchExpressionParser theParser) {
        String operator = null;
        Token token = theParser.token;
        switch (token.kind) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                operator = token.image;
                break;
            }
            default: {
                throw new RuntimeException("Expected relational operator but got " + token.image);
            }
        }
        token = theParser.getNextToken();
        return operator;
    }

    public SearchStep[] getSteps() {
        if (!this.didParse) {
            this.parseSearchExpression();
        }
        if (this.steps.isEmpty()) {
            return null;
        }
        SearchStep[] array = new SearchStep[this.steps.size()];
        return this.steps.toArray(array);
    }

    private boolean isHomeStep(SearchExpressionParser theParser) {
        switch (theParser.token.kind) {
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    private int parseAxis(SearchExpressionParser theParser) {
        Token token = theParser.token;
        int axis = 0;
        switch (token.kind) {
            case 16: 
            case 18: {
                axis = 5;
                break;
            }
            case 13: 
            case 14: {
                axis = 3;
                break;
            }
            case 32: {
                token = theParser.getNextToken();
                axis = this.getAxisAfterSlash(theParser, token);
                break;
            }
            case 31: {
                axis = 5;
                theParser.getNextToken();
                break;
            }
            case 34: {
                axis = 7;
                theParser.getNextToken();
                break;
            }
            case 33: {
                axis = 6;
                theParser.getNextToken();
                break;
            }
            default: {
                axis = this.getAxisFromName(token);
                theParser.getNextToken();
            }
        }
        return axis;
    }

    private SearchFilter parseCAMID(SearchExpressionParser theParser) {
        Token token = theParser.token;
        if (token.kind != 16) {
            throw new RuntimeException(UNEXPECTED_FUNCTION + token.image);
        }
        String camidValue = SearchPathImpl.parseCamidValue(token.image);
        String[] parms = new String[]{SearchPathImpl.parseNamespaceID(camidValue), SearchPathImpl.parseObjectID(camidValue)};
        return new SearchFilterCamIdFunctionCallImpl("CAMID", parms);
    }

    private SearchFilter parseCAMIDFunction(SearchExpressionParser theParser) {
        Token token = theParser.token;
        String functionName = token.image;
        if (token.kind != 18) {
            throw new RuntimeException(UNEXPECTED_FUNCTION + token.image);
        }
        token = theParser.getNextToken();
        if (token.kind != 36) {
            throw new RuntimeException(EXPECTED_PARENTHESES + token.image);
        }
        ArrayList<String> parms = new ArrayList<String>();
        do {
            token = theParser.getNextToken();
            switch (token.kind) {
                case 13: 
                case 14: 
                case 16: {
                    parms.add(token.image);
                    break;
                }
                default: {
                    throw new RuntimeException(EXPECTED_PARAMETER + token.image);
                }
            }
            token = theParser.getNextToken();
            switch (token.kind) {
                case 30: 
                case 37: {
                    break;
                }
                default: {
                    throw new RuntimeException(EXPECTED_NO_MORE_PARAMETERS + token.image);
                }
            }
        } while (token.kind != 37);
        return new SearchFilterCamIdFunctionCallImpl(functionName, parms.toArray(new String[parms.size()]));
    }

    private Literal parseLiteral(SearchExpressionParser theParser) {
        Literal literal = null;
        Token token = theParser.token;
        switch (token.kind) {
            case 5: {
                literal = new Literal(token.image);
                break;
            }
            default: {
                throw new RuntimeException("Expected literal constraint but got " + token.image);
            }
        }
        token = theParser.getNextToken();
        return literal;
    }

    private String parseNodeTest(SearchExpressionParser theParser) {
        Token token = theParser.token;
        String nodeTest = null;
        switch (token.kind) {
            case 13: {
                nodeTest = "account";
                break;
            }
            case 14: {
                nodeTest = "session";
                break;
            }
            case 0: 
            case 16: 
            case 18: {
                nodeTest = WILDCARD;
                break;
            }
            case 33: 
            case 34: {
                nodeTest = WILDCARD;
                theParser.getNextToken();
                break;
            }
            case 12: 
            case 21: {
                nodeTest = token.image;
                theParser.getNextToken();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected nodeTest value: " + token.image);
            }
        }
        return nodeTest;
    }

    private SearchFilter parsePredicate(SearchExpressionParser theParser) {
        Token token = theParser.token;
        SearchFilter searchFilter = null;
        switch (token.kind) {
            case 38: {
                searchFilter = this.parseValueBetweenBrackets(theParser, token, searchFilter);
                theParser.getNextToken();
                break;
            }
            case 16: {
                searchFilter = this.parseCAMID(theParser);
                theParser.getNextToken();
                break;
            }
            case 18: {
                searchFilter = this.parseCAMIDFunction(theParser);
                theParser.getNextToken();
                break;
            }
            case 13: 
            case 14: 
            case 33: 
            case 34: {
                theParser.getNextToken();
                break;
            }
            case 0: 
            case 31: 
            case 32: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected predicate : " + token.image);
            }
        }
        return searchFilter;
    }

    private SearchFilter parsePropertyFunction(SearchExpressionParser theParser) {
        Token token = theParser.token;
        String functionName = token.image;
        if (token.kind != 19) {
            throw new RuntimeException(UNEXPECTED_FUNCTION + token.image);
        }
        token = theParser.getNextToken();
        if (token.kind != 36) {
            throw new RuntimeException(EXPECTED_PARENTHESES + token.image);
        }
        StringBuffer property = new StringBuffer();
        Literal literal = this.parseTokenPropertyNameLiteral(theParser, property);
        token = theParser.token;
        if (token.kind != 37) {
            throw new RuntimeException(EXPECTED_NO_MORE_PARAMETERS + token.image);
        }
        token = theParser.getNextToken();
        return new SearchFilterPropertyFunctionCallImpl(functionName, property.toString(), literal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSearchExpression() {
        ArrayList<SearchExpressionParser> arrayList;
        this.steps.clear();
        SearchExpressionParser parser = null;
        try {
            arrayList = PARSER_POOL;
            synchronized (arrayList) {
                if (!PARSER_POOL.isEmpty()) {
                    parser = PARSER_POOL.remove(0);
                }
            }
            if (parser == null) {
                parser = new SearchExpressionParser(new StringReader(this.searchExpression));
            } else {
                parser.ReInit(new StringReader(this.searchExpression));
            }
            parser.getNextToken();
            while (parser.token.kind != 0) {
                this.parseStep(parser);
            }
            this.didParse = true;
        }
        finally {
            arrayList = PARSER_POOL;
            synchronized (arrayList) {
                if (PARSER_POOL.size() < 20) {
                    PARSER_POOL.add(parser);
                }
            }
        }
    }

    private SearchFilter parseSearchFilter(SearchExpressionParser theParser) {
        Object searchFilter = null;
        Token token = theParser.token;
        switch (token.kind) {
            case 22: {
                searchFilter = this.parseSearchFilterPropertyName(theParser);
                break;
            }
            case 5: {
                searchFilter = this.parseSearchFilterLiteral(theParser);
                break;
            }
            case 19: {
                searchFilter = this.parsePropertyFunction(theParser);
                break;
            }
            case 18: {
                searchFilter = this.parseCAMIDFunction(theParser);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search filter " + token.image);
            }
        }
        token = theParser.token;
        switch (token.kind) {
            case 8: 
            case 10: {
                String operator = token.image;
                token = theParser.getNextToken();
                SearchFilter[] filters = new SearchFilter[]{searchFilter, this.parseSearchFilter(theParser)};
                searchFilter = new SearchFilterConditionalExpressionImpl(operator, filters);
                break;
            }
            case 39: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected conditional operator" + token.image);
            }
        }
        return searchFilter;
    }

    private SearchFilter parseSearchFilterLiteral(SearchExpressionParser theParser) {
        Literal literal = this.parseLiteral(theParser);
        String operator = this.getRelationalOperator(theParser);
        String propertyName = this.getPropertyName(theParser);
        SearchFilterRelationalExpressionImpl searchFilter = new SearchFilterRelationalExpressionImpl(operator, propertyName, literal);
        return searchFilter;
    }

    private SearchFilter parseSearchFilterPropertyName(SearchExpressionParser theParser) {
        String propertyName = this.getPropertyName(theParser);
        String operator = this.getRelationalOperator(theParser);
        Literal literal = this.parseLiteral(theParser);
        SearchFilterRelationalExpressionImpl searchFilter = new SearchFilterRelationalExpressionImpl(operator, propertyName, literal);
        return searchFilter;
    }

    private void parseStep(SearchExpressionParser theParser) {
        int searchType = this.parseAxis(theParser);
        String nodeTest = this.parseNodeTest(theParser);
        boolean addHomeStep = this.isHomeStep(theParser);
        SearchFilter searchFilter = this.parsePredicate(theParser);
        SearchStepImpl step = new SearchStepImpl(nodeTest, searchType, searchFilter);
        if (addHomeStep) {
            this.steps.add(new SearchStepImpl("home", 3, null));
        }
        this.steps.add(step);
    }

    private Literal parseTokenPropertyNameLiteral(SearchExpressionParser theParser, StringBuffer property) {
        Token token = theParser.getNextToken();
        Literal literal = null;
        switch (token.kind) {
            case 22: {
                if (property.length() != 0) {
                    throw new RuntimeException(EXPECTED_A_CONSTRAINT + token.image);
                }
                property.append(this.getPropertyName(theParser));
                break;
            }
            case 5: {
                literal = this.parseLiteral(theParser);
                break;
            }
            default: {
                throw new RuntimeException(EXPECTED_PARAMETER + token.image);
            }
        }
        token = theParser.token;
        if (token.kind != 40) {
            throw new RuntimeException("Expected a ',' but got '" + token.image + "'");
        }
        token = theParser.getNextToken();
        switch (token.kind) {
            case 22: {
                if (property.length() != 0) {
                    throw new RuntimeException(EXPECTED_A_CONSTRAINT + token.image);
                }
                property.append(this.getPropertyName(theParser));
                break;
            }
            case 5: {
                if (literal != null) {
                    throw new RuntimeException(EXPECTED_A_PROPERTY + token.image);
                }
                literal = this.parseLiteral(theParser);
                break;
            }
            default: {
                throw new RuntimeException(EXPECTED_PARAMETER + token.image);
            }
        }
        return literal;
    }

    private SearchFilter parseValueBetweenBrackets(SearchExpressionParser theParser, Token token, SearchFilter searchFilter) {
        Token nextToken = token;
        Object searchFilterRet = searchFilter;
        while (nextToken.kind == 38) {
            nextToken = theParser.getNextToken();
            while (nextToken.kind != 39) {
                if (searchFilterRet != null) {
                    SearchFilter[] filters = new SearchFilter[]{searchFilterRet, this.parseSearchFilter(theParser)};
                    searchFilterRet = new SearchFilterConditionalExpressionImpl("and", filters);
                } else {
                    searchFilterRet = this.parseSearchFilter(theParser);
                }
                nextToken = theParser.token;
            }
            nextToken = theParser.getNextToken();
        }
        return searchFilterRet;
    }

    public String toString() {
        if (!this.didParse) {
            this.parseSearchExpression();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.steps.size(); ++i) {
            SearchStepImpl step = (SearchStepImpl)this.steps.get(i);
            buffer.append(step.toString());
        }
        return buffer.toString();
    }
}

