/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.admin.soap;

import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;

public class SearchPathImpl
implements SearchPath {
    private static final String QUOT_ESCAPED_STR = "&quot;";
    private static final String QUOT_STR = "\"";
    private static final char QUOT_CHAR = '\"';
    private static final char APOS_CHAR = '\'';
    private static final String CAMID_PREFIX = "CAMID(\"";
    private static final String CAMID_SUFFIX = "\")";
    private static final String CAMID_FIELD_SEPARATOR = ":";
    private static final int CAMID_PREFIX_LENGTH = "CAMID(\"".length();
    private static final int CAMID_SUFFIX_LENGTH = "\")".length();
    private final String namespaceID;
    private final String objectID;

    public SearchPathImpl(String theSearchPath) {
        if (theSearchPath == null || !SearchPathImpl.isCAMID(theSearchPath)) {
            throw new IllegalArgumentException();
        }
        String searchPathValue = SearchPathImpl.parseCamidValue(theSearchPath);
        this.namespaceID = SearchPathImpl.parseNamespaceID(searchPathValue);
        this.objectID = SearchPathImpl.parseObjectID(searchPathValue);
    }

    public SearchPathImpl(String theNamespaceID, String theObjectID) {
        if (theNamespaceID == null || theNamespaceID.indexOf(58) != -1) {
            throw new IllegalArgumentException("Invalid namespace ID");
        }
        if (theObjectID != null && theObjectID.length() == 0) {
            throw new IllegalArgumentException("Invalid object ID");
        }
        this.namespaceID = theNamespaceID;
        this.objectID = theObjectID;
    }

    private static boolean isCAMID(String theSearchPath) {
        boolean retval = false;
        if (theSearchPath.startsWith("CAMID(")) {
            char quoteChar;
            switch (theSearchPath.charAt(CAMID_PREFIX_LENGTH - 1)) {
                case '\'': {
                    quoteChar = '\'';
                    break;
                }
                case '\"': {
                    quoteChar = '\"';
                    break;
                }
                default: {
                    return false;
                }
            }
            if (theSearchPath.endsWith(quoteChar + ")")) {
                retval = true;
            }
        }
        return retval;
    }

    static String parseCamidValue(String theSearchPath) {
        if (theSearchPath == null || !SearchPathImpl.isCAMID(theSearchPath)) {
            throw new IllegalArgumentException();
        }
        return theSearchPath.substring(CAMID_PREFIX_LENGTH, theSearchPath.length() - CAMID_SUFFIX_LENGTH);
    }

    static String parseNamespaceID(String theCamidValue) {
        if (SearchPathImpl.isCAMID(theCamidValue)) {
            throw new IllegalArgumentException();
        }
        String namespaceID = "";
        int pos = theCamidValue.indexOf(58);
        namespaceID = pos >= 0 ? theCamidValue.substring(0, pos) : theCamidValue;
        return namespaceID;
    }

    static String parseObjectID(String theCamidValue) {
        int end;
        if (SearchPathImpl.isCAMID(theCamidValue)) {
            throw new IllegalArgumentException();
        }
        String objectID = null;
        int start = theCamidValue.indexOf(58);
        if (start >= 0 && ++start < (end = theCamidValue.length())) {
            objectID = theCamidValue.substring(start, end);
        }
        return objectID;
    }

    private boolean areObjectIdsEqual(String rhsObjectID) {
        if (this.objectID == null && rhsObjectID == null) {
            return true;
        }
        return this.objectID != null && this.objectID.equals(rhsObjectID);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchPathImpl) {
            SearchPathImpl rhs = (SearchPathImpl)obj;
            if (this.namespaceID.equals(rhs.namespaceID)) {
                return this.areObjectIdsEqual(rhs.objectID);
            }
        }
        return false;
    }

    public String getNamespaceID() {
        return this.namespaceID;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public String getValue() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(CAMID_PREFIX);
        if (this.namespaceID != null) {
            buffer.append(this.namespaceID);
        }
        if (this.objectID != null) {
            buffer.append(CAMID_FIELD_SEPARATOR);
            buffer.append(this.objectID.replaceAll(QUOT_STR, QUOT_ESCAPED_STR));
        }
        buffer.append(CAMID_SUFFIX);
        return buffer.toString();
    }

    public int hashCode() {
        String camId = this.namespaceID + this.objectID;
        return camId.hashCode();
    }
}

