/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.AuthRedirectRequest;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class AuthRedirectRequestImpl
implements AuthRedirectRequest {
    public static final int ERROR_CODE = -50;
    private static final String SINGLE_CREDENTIAL_NAMESPACE_XPATH_EXPRESSION = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credential']/*[local-name()='namespace']";
    private static final String FORM_FIELD_NAMESPACE_XPATH_EXPRESSION = "./*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='formFieldVars']/*[local-name()='item']/*[local-name()='name'][camaaa:element-text(.)='CAMNamespace']";
    private static final String CREDENTIALS_XPATH_EXPRESSION = "./*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='credentials']/*[local-name()='credential']";
    private static final String NAMESPACE_XPATH_EXPRESSION = "./*[local-name()='namespace']";
    private static final String FORM_FIELD_VARS_XPATH_EXPRESSION = "./*[local-name()='biBusHeader']/*[local-name()='hdrSession']/*[local-name()='formFieldVars']";
    private static final String OUTER_CREDENTIAL_XPATH_EXPRESSION = "./*[local-name()='credential']";
    private final Element authDoc;

    public AuthRedirectRequestImpl(Element theAuthDoc) {
        this.authDoc = theAuthDoc.createCopy();
    }

    @Override
    public String getAuthDoc() {
        this.removeFormFieldVars();
        this.removeOuterCredentialElement();
        return this.authDoc.asXML();
    }

    private String getFormFieldCAMNamespace() {
        String namespaceValue = null;
        Element camNamespaceElement = DocumentHelper.selectSingleElement((String)FORM_FIELD_NAMESPACE_XPATH_EXPRESSION, (Node)this.authDoc);
        if (camNamespaceElement != null) {
            Element itemElement = camNamespaceElement.getParent();
            namespaceValue = DocumentHelper.valueOf((String)"./*[local-name()='value']", (Node)itemElement);
        }
        return namespaceValue;
    }

    @Override
    public String getTargetNamespaceId() {
        String namespaceId = DocumentHelper.valueOf((String)SINGLE_CREDENTIAL_NAMESPACE_XPATH_EXPRESSION, (Node)this.authDoc);
        if (namespaceId == null) {
            List credentials = DocumentHelper.selectElements((String)CREDENTIALS_XPATH_EXPRESSION, (Node)this.authDoc);
            if (credentials != null && credentials.size() == 1) {
                namespaceId = DocumentHelper.valueOf((String)NAMESPACE_XPATH_EXPRESSION, (Node)((Node)credentials.get(0)));
            }
            if (namespaceId == null) {
                namespaceId = this.getFormFieldCAMNamespace();
            }
        }
        return namespaceId;
    }

    private void removeFormFieldVars() {
        Element formFieldVarsElement = DocumentHelper.selectSingleElement((String)FORM_FIELD_VARS_XPATH_EXPRESSION, (Node)this.authDoc);
        if (formFieldVarsElement != null) {
            formFieldVarsElement.detach();
        }
    }

    private void removeOuterCredentialElement() {
        Element credentialElement = DocumentHelper.selectSingleElement((String)OUTER_CREDENTIAL_XPATH_EXPRESSION, (Node)this.authDoc);
        if (credentialElement != null) {
            credentialElement.detach();
        }
    }
}

