/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.util.TimerTask;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

class DestroyCmSessionTask
extends TimerTask {
    private static final String END_SESSION_RESPONSE = "*[local-name()='Body']/*[local-name()='endSessionResponse']";
    private final String passportID;
    private final String accountSearchPath;

    DestroyCmSessionTask(String thePassportID, String theAccountSearchPath) {
        this.passportID = thePassportID;
        this.accountSearchPath = theAccountSearchPath;
    }

    private void log(String operation, String logData) {
        LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)"Audit.RTUsage.CAM.AAA.SRVC", LogAuditAccessIndication.class);
        LogAuditAccessIndication indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber());
        indication.setOperation(operation);
        indication.setObjectType(PassportManager.class.getName());
        indication.setStatus("Failure");
        indication.setLevel(10000);
        if (logData != null) {
            indication.setLogData(logData);
        }
        ipfLogger.log((Object)indication);
    }

    @Override
    public void run() {
        String functionName = "DestroyCmSessionTask.run";
        try {
            StringBuffer cmRequest = new StringBuffer();
            cmRequest.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ");
            cmRequest.append("xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" ");
            cmRequest.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" ");
            cmRequest.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" ");
            cmRequest.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"> ");
            cmRequest.append("<SOAP-ENV:Header/><SOAP-ENV:Body> ");
            cmRequest.append("<cm:endSession xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"> ");
            cmRequest.append("<id xsi:type=\"xsd:string\">");
            cmRequest.append(this.passportID);
            cmRequest.append("</id> ");
            cmRequest.append("<search xsi:type=\"xsd:string\">");
            cmRequest.append(this.accountSearchPath);
            cmRequest.append("</search> </cm:endSession> </SOAP-ENV:Body></SOAP-ENV:Envelope> ");
            String xmlResponse = null;
            xmlResponse = CMAccessor.getInstance().invoke(cmRequest.toString());
            Document doc = DocumentHelper.parseText((String)xmlResponse);
            Element responseElement = doc.getRootElement();
            Element endSessionResponse = (Element)DocumentHelper.selectSingleNode((String)END_SESSION_RESPONSE, (Node)responseElement);
            if (endSessionResponse == null) {
                this.log("DestroyCmSessionTask.run", "failed to destroy CM session: " + endSessionResponse);
            }
        }
        catch (Exception e) {
            this.log("DestroyCmSessionTask.run", e.getLocalizedMessage());
        }
    }
}

