/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class EnvironmentSecurityBlob
extends SecurityBlob {
    private static final String UTF8 = "UTF8";
    private static final String VALUE_DELIMITER = "=";
    private static final String BLOB_DELIMITER = " , ";
    private LinkedHashMap<String, String> requestedVarsWithValues = new LinkedHashMap();
    private final String tokenId;
    private final byte[] hmacDigest;
    private final String environnmentalRawData;
    private boolean changed;

    public EnvironmentSecurityBlob() {
        this(null, null, null, null, null);
    }

    public EnvironmentSecurityBlob(String theEncodedSecurityBlob, String theEnvironmentRawData, String[] theRequestedVars, String theTokenId, byte[] theHmacDigest) {
        super(1, theEncodedSecurityBlob);
        if (theRequestedVars != null) {
            this.parseRequestedVarsWithValues(theRequestedVars);
        }
        this.tokenId = theTokenId;
        this.hmacDigest = theHmacDigest;
        this.environnmentalRawData = theEnvironmentRawData;
        this.changed = false;
    }

    private void parseRequestedVarsWithValues(String[] dataString) {
        String attribute = null;
        String unEscapedValue = null;
        for (int i = 0; i < dataString.length; ++i) {
            String attributeValuePair = dataString[i];
            int tokenSeperator = attributeValuePair.indexOf(VALUE_DELIMITER, 0);
            if (tokenSeperator >= 0) {
                attribute = attributeValuePair.substring(0, tokenSeperator);
                String value = attributeValuePair.substring(tokenSeperator + VALUE_DELIMITER.length());
                int length = value.length();
                StringBuffer unEscapedValueBuffer = new StringBuffer(length + 1);
                for (int idx = 0; idx < length; ++idx) {
                    if (value.charAt(idx) == '\\' && idx + 1 < length && (value.charAt(idx + 1) == '=' || value.charAt(idx + 1) == ',')) {
                        unEscapedValueBuffer.append(value.charAt(++idx));
                        continue;
                    }
                    unEscapedValueBuffer.append(value.charAt(idx));
                }
                unEscapedValue = unEscapedValueBuffer.toString();
            } else {
                attribute = attributeValuePair;
                unEscapedValue = null;
            }
            this.requestedVarsWithValues.put(attribute, unEscapedValue);
        }
    }

    public String getEnvironmentRawData() {
        if (this.changed || this.environnmentalRawData == null) {
            return this.generateRawData();
        }
        return this.environnmentalRawData;
    }

    public byte[] getHmacDigest() {
        return this.hmacDigest;
    }

    public String[] getRequestedVars() {
        Set<String> attributeList = this.requestedVarsWithValues.keySet();
        return attributeList.toArray(new String[attributeList.size()]);
    }

    public String getRequestedVarValue(String attributeName) {
        return this.requestedVarsWithValues.get(attributeName);
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public void addVars(String attributeName, String value) {
        this.requestedVarsWithValues.put(attributeName, value);
        this.changed = true;
    }

    public void removeVars(String attributeName) {
        this.requestedVarsWithValues.remove(attributeName);
        this.changed = true;
    }

    @Override
    public String getEncodedSecurityBlob() {
        try {
            String rawData = this.getEnvironmentRawData();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(rawData.getBytes(UTF8));
            if (this.hmacDigest != null) {
                out.write(" : ".getBytes(UTF8));
                out.write(this.hmacDigest);
            }
            return base64.encode((int)0, (byte[])out.toByteArray());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private String generateRawData() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type");
        buffer.append(VALUE_DELIMITER);
        buffer.append(this.getBlobType());
        Set<String> set = this.requestedVarsWithValues.keySet();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            buffer.append(BLOB_DELIMITER);
            String key = it.next();
            buffer.append(key);
            String value = this.requestedVarsWithValues.get(key);
            if (value == null) continue;
            buffer.append(VALUE_DELIMITER);
            buffer.append(value);
        }
        if (this.tokenId != null) {
            buffer.append(BLOB_DELIMITER);
            buffer.append("CAM_TOKENID_");
            buffer.append(this.tokenId);
        }
        return buffer.toString();
    }
}

