/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.LockableObject;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.camaaa.internal.common.util.TimerImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExpiringEntry
implements TimedObject,
LockableObject,
Externalizable {
    private static final long serialVersionUID = 2L;
    private String uniqueID;
    private long inactivityTimeout;
    private long validUntil;
    private TimerImpl inactivityTimer;
    private boolean isLocked = false;
    private boolean isDoomed = false;
    private Thread lockOwner = null;

    public ExpiringEntry() {
    }

    public ExpiringEntry(String thePassportID, long theInactivityTimeout, long validUntil) {
        this();
        this.uniqueID = thePassportID;
        this.inactivityTimeout = theInactivityTimeout;
        this.validUntil = validUntil;
        this.inactivityTimer = new TimerImpl();
    }

    protected void checkState() {
        if (this.isDoomed) {
            throw new IllegalStateException();
        }
    }

    public synchronized void cleanup() {
        this.isDoomed = true;
        this.notifyAll();
    }

    public synchronized String getID() {
        return this.uniqueID;
    }

    public synchronized long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public synchronized boolean isExpired() {
        boolean retval = false;
        if (this.isDoomed) {
            retval = true;
        } else if (!this.isLocked) {
            retval = this.inactivityTimer.getElapsedTimeInMs() > this.inactivityTimeout || System.currentTimeMillis() > this.validUntil;
        }
        return retval;
    }

    @Override
    public synchronized void lock() throws InterruptedException {
        this.checkState();
        while (!this.trylock()) {
            this.wait();
        }
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 2L) {
            throw new IOException("Unkown version: " + Long.toString(version));
        }
        this.uniqueID = in.readUTF();
        this.isDoomed = in.readBoolean();
        this.inactivityTimeout = in.readLong();
        this.validUntil = in.readLong();
        this.inactivityTimer = new TimerImpl();
        this.inactivityTimer.start();
    }

    protected void setID(String theID) {
        this.uniqueID = theID;
    }

    protected void setInactivityTimeout(long theInactivityTimeout) {
        this.inactivityTimeout = theInactivityTimeout;
    }

    @Override
    public synchronized boolean trylock() {
        this.checkState();
        if (this.lockOwner == null) {
            this.lockOwner = Thread.currentThread();
            this.isLocked = true;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void unlock() {
        if (this.lockOwner != Thread.currentThread()) {
            throw new IllegalStateException("not lock owner");
        }
        this.lockOwner = null;
        this.isLocked = false;
        this.inactivityTimer.start();
        this.notifyAll();
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(2L);
        out.writeUTF(this.uniqueID);
        out.writeBoolean(this.isDoomed);
        out.writeLong(this.inactivityTimeout);
        out.writeLong(this.validUntil);
        out.flush();
    }

    public long getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }
}

