/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.ccl4j.bibus.CAMCookieImpl;
import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.indications.LogIPFControl;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Set;

public final class InternalCAMCookieImpl
extends CAMCookieImpl {
    private static final int VERSION = 1;
    private final boolean isNewCamCookieFormatEnabled;

    public InternalCAMCookieImpl(Passport thePassport, boolean newCamCookieFormatEnabled, Set<String> dyeTracedUsers) {
        super.setVersion(1);
        super.setPassportID(thePassport.getID());
        super.setPassportGeneration(thePassport.getGeneration());
        super.setCanCurrentUserCallLogon(thePassport.canUserCallLogon());
        super.setAction(null);
        this.isNewCamCookieFormatEnabled = newCamCookieFormatEnabled;
        this.setLoggingEnabled(thePassport, dyeTracedUsers);
    }

    private HashSet<String> getSessionCamIds(Passport thePassport) {
        HashSet<String> camIds = new HashSet<String>();
        Set<String> authenticatedNsIds = thePassport.getAuthenticatedNamespaceIDs();
        for (String id : authenticatedNsIds) {
            camIds.add(thePassport.getInternalVisa(id).getCAMID());
        }
        return camIds;
    }

    public String getSessionContext() {
        String sessionID = null;
        if (this.getPassportID() == null) {
            return sessionID;
        }
        boolean[] flags = new boolean[]{this.isLoggingEnabled()};
        try {
            sessionID = LogIPFControl.generateSessionID((String)this.getPassportID(), (boolean[])flags);
        }
        catch (Exception e) {
            sessionID = null;
        }
        return sessionID;
    }

    public String getValue() {
        String theValue;
        StringBuffer buffer = new StringBuffer();
        if (this.isNewCamCookieFormatEnabled) {
            buffer.append(this.getVersion());
            buffer.append(";");
            buffer.append(this.getPassportID());
            buffer.append(";");
            if (this.isLoggingEnabled()) {
                buffer.append("1");
            } else {
                buffer.append("0");
            }
            buffer.append(";");
            buffer.append(this.getPassportGeneration());
            buffer.append(";");
            if (this.canCurrentUserCallLogon()) {
                buffer.append("1");
            } else {
                buffer.append("0");
            }
            buffer.append(";");
            try {
                theValue = CCLWeb64.encode((byte[])buffer.toString().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                theValue = "";
            }
        } else {
            buffer.append(this.getPassportID());
            theValue = buffer.toString();
        }
        return theValue;
    }

    private void setLoggingEnabled(Passport thePassport, Set<String> dyeTracedUsers) {
        if (dyeTracedUsers == null) {
            return;
        }
        HashSet<String> camIds = this.getSessionCamIds(thePassport);
        boolean loggingEnabled = false;
        for (String camId : camIds) {
            if (!dyeTracedUsers.contains(camId)) continue;
            loggingEnabled = true;
            break;
        }
        super.setLoggingEnabled(loggingEnabled);
    }
}

