/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.common.Visa;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class InternalVisa
implements Externalizable {
    private static final String NULL_STRING = "null";
    private static final long serialVersionUID = -6816533782745589488L;
    private String camid;
    private String displayName;
    private String username;
    private Visa visa;

    public InternalVisa() {
    }

    public InternalVisa(String theCamid, String theDisplayName, String theUsername) {
        this.camid = theCamid;
        this.displayName = theDisplayName;
        this.username = theUsername;
    }

    public String getCAMID() {
        return this.camid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUsername() {
        return this.username;
    }

    public Visa getVisa() {
        return this.visa;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != -6816533782745589488L) {
            throw new IOException("Unknown version: " + Long.toString(version));
        }
        this.camid = in.readUTF();
        if (this.camid.equals(NULL_STRING)) {
            this.camid = null;
        }
        this.displayName = in.readUTF();
        if (this.displayName.equals(NULL_STRING)) {
            this.displayName = null;
        }
        this.username = in.readUTF();
        if (this.username.equals(NULL_STRING)) {
            this.username = null;
        }
        this.visa = (Visa)in.readObject();
    }

    public void setVisa(Visa theVisa) {
        this.visa = theVisa;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(-6816533782745589488L);
        this.writeString(out, this.camid);
        this.writeString(out, this.displayName);
        this.writeString(out, this.username);
        out.writeObject(this.visa);
        out.flush();
    }

    private void writeString(ObjectOutput theOutput, String theString) throws IOException {
        if (theString == null) {
            theOutput.writeUTF(NULL_STRING);
        } else {
            theOutput.writeUTF(theString);
        }
    }
}

