/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.ReplicatedPassportCache;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.pdc.CacheException;
import com.ibm.cognos.pdc.CacheMap;
import com.ibm.cognos.pdc.PDCGrid;
import com.ibm.cognos.pdc.Session;
import com.ibm.cognos.pdc.SessionContext;
import com.ibm.cognos.pdc.core.PDCGridBuilder;
import com.ibm.cognos.pdc.core.PDCGridBuilderFinder;
import java.util.Iterator;

public class PDCWrapper
implements ReplicatedPassportCache {
    private static final String INITIALIZE_METHODNAME = "initialize";
    private static final String TRACE_CAM_AAA_SRVC_PDC = "Trace.CAM.AAA.SRVC.PDC";
    private CacheMap cacheMap;
    private Session session;
    private TraceLogger traceLogger;
    private LogContext logContext;
    private PDCGridBuilder gridBuilder;

    PDCWrapper() throws SoapFaultException {
        this(new PDCGridBuilderFinder().findBuilder(), null);
    }

    PDCWrapper(PDCGridBuilder aBuilder, TraceLogger aTraceLogger) {
        this.gridBuilder = aBuilder;
        this.traceLogger = aTraceLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Passport get(String passportID) {
        Passport thePassport = null;
        if (passportID != null) {
            try {
                this.session.begin();
                thePassport = (Passport)this.cacheMap.get((Object)passportID);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                if (this.session.isTransactionActive()) {
                    this.quietRollback();
                }
            }
        }
        return thePassport;
    }

    private void quietRollback() {
        try {
            this.session.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initialize(PDCGridBuilder theGridBuilder, TraceLogger theTraceLogger) throws SoapFaultException {
        if (theTraceLogger == null) {
            LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)TRACE_CAM_AAA_SRVC_PDC, LogTraceIndication.class);
            this.traceLogger = new TraceLoggerImpl(ipfLogger);
        } else {
            this.traceLogger = theTraceLogger;
        }
        this.logContext = new LogContextImpl(null, null, 1, null);
        try {
            PDCGrid grid = theGridBuilder.buildPDCGrid("CAM_Grid");
            this.session = grid.getSession(new SessionContext());
            this.cacheMap = this.session.getMap("PassportMap");
        }
        catch (CacheException e) {
            throw new FunctionCallFailedException(PDCWrapper.class.toString(), INITIALIZE_METHODNAME, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String passportID, Passport thePassport) {
        if (passportID != null) {
            try {
                this.session.begin();
                this.cacheMap.put((Object)passportID, (Object)thePassport);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                if (this.session.isTransactionActive()) {
                    this.quietRollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Passport remove(String passportID) {
        Passport thePassport = null;
        if (passportID != null) {
            try {
                this.session.begin();
                thePassport = (Passport)this.cacheMap.remove((Object)passportID);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                if (this.session.isTransactionActive()) {
                    this.quietRollback();
                }
            }
        }
        return thePassport;
    }

    @Override
    public void initialize(Configuration theConfiguration) throws SoapFaultException {
        this.initialize(this.gridBuilder, this.traceLogger);
    }

    @Override
    public Iterator<Object> getPassportIDs() {
        try {
            return this.cacheMap.getKeys();
        }
        catch (CacheException e) {
            LogData theLogData = this.traceLogger.getLogData();
            theLogData.setException((Exception)((Object)e));
            this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            return ReplicatedPassportCache.EMPTY_ITERATOR;
        }
    }
}

