/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportLoaderTask;
import com.ibm.cognos.camaaa.internal.auth.ReplicatedPassportCache;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;

public class PassportCache {
    public static final String XPATH_REPLICATION_CONFIG = "./*[local-name()='Replication']";
    public static final String XPATH_ENABLE_REPLICATION = "./value/*[local-name()='parameter'][@name='pdcEnableReplication']/*[local-name()='value']/text()";
    protected static final String KEY_REPLICATION_CLASS = "replicationClass";
    protected static final String DEFAULT_REPLICATION_CLASS = "com.ibm.cognos.camaaa.internal.auth.PDCWrapper";
    private final ConcurrentHashMap<String, Passport> passports = new ConcurrentHashMap();
    private ReplicatedPassportCache replicatedCache = null;
    private boolean shutdown;
    private volatile boolean reloading = false;

    public Passport get(String aPassportId) {
        Passport thePassport = null;
        if (aPassportId != null) {
            thePassport = this.passports.get(aPassportId);
        }
        if (this.replicatedCache != null && thePassport == null && aPassportId != null && (thePassport = this.replicatedCache.get(aPassportId)) != null) {
            thePassport = this.revivePassport(aPassportId, thePassport);
        }
        return thePassport;
    }

    private Passport revivePassport(String thePassportId, Passport thePassport) {
        Passport revivedPassport;
        if (thePassport.isExpired()) {
            this.replicatedCache.remove(thePassportId);
            revivedPassport = null;
        } else {
            this.passports.put(thePassportId, thePassport);
            revivedPassport = thePassport;
        }
        this.reloadIfNecessary(thePassport);
        return revivedPassport;
    }

    private synchronized void reloadIfNecessary(Passport thePassport) {
        if (thePassport != null && !this.reloading) {
            this.reloading = true;
            PassportLoaderTask task = new PassportLoaderTask(this);
            Executors.newSingleThreadExecutor().execute(task);
        }
    }

    public void initialize(Configuration theConfiguration) throws SoapFaultException {
        boolean enableReplication = this.isReplicationEnabled(theConfiguration);
        Map<String, String> advProps = theConfiguration.getAdvancedProperties();
        this.shutdown = false;
        if (enableReplication) {
            String className = advProps.get(KEY_REPLICATION_CLASS);
            if (className == null) {
                className = DEFAULT_REPLICATION_CLASS;
            }
            this.replicatedCache = this.newReplicatedPassportCache(className);
            this.replicatedCache.initialize(theConfiguration);
        }
    }

    private boolean isReplicationEnabled(Configuration theConfiguration) throws InternalErrorException {
        Configuration replicationConfig;
        boolean enableReplication = false;
        try {
            replicationConfig = theConfiguration.getRootConfiguration().getSingleConfiguration(XPATH_REPLICATION_CONFIG);
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(this.getClass().toString(), (Exception)((Object)e));
        }
        if (replicationConfig != null) {
            String enableReplicationStr = replicationConfig.getOptionalValue(XPATH_ENABLE_REPLICATION, Boolean.toString(enableReplication));
            enableReplication = Boolean.parseBoolean(enableReplicationStr);
        }
        return enableReplication;
    }

    private ReplicatedPassportCache newReplicatedPassportCache(String className) throws SoapFaultException {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            return (ReplicatedPassportCache)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InternalErrorException(className, e);
        }
        catch (InstantiationException e) {
            throw new InternalErrorException(className, e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException(className, e);
        }
    }

    public boolean isEmpty() {
        return this.passports.isEmpty();
    }

    public void put(String aPassportId, Passport aPassport) {
        if (aPassportId != null) {
            this.passports.put(aPassportId, aPassport);
            if (this.replicatedCache != null) {
                this.replicatedCache.put(aPassportId, aPassport);
            }
        }
    }

    public Passport remove(String passportId) {
        if (this.replicatedCache != null && !this.shutdown) {
            this.replicatedCache.remove(passportId);
        }
        Passport passport = null;
        if (passportId != null) {
            passport = this.passports.remove(passportId);
        }
        return passport;
    }

    synchronized void setReplicatedCache(ReplicatedPassportCache theReplicatedCache) {
        this.replicatedCache = theReplicatedCache;
    }

    public boolean isReplicated() {
        return this.replicatedCache != null;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public void update(String passportId, Passport thePassport) {
        if (this.replicatedCache != null && thePassport.hasStateChanged()) {
            this.replicatedCache.remove(passportId);
            this.replicatedCache.put(passportId, thePassport);
        }
        thePassport.resetChangeIndicator();
    }

    public Collection<Passport> values() {
        return this.passports.values();
    }

    public Collection<String> keys() {
        return this.passports.keySet();
    }

    void reload() {
        if (this.replicatedCache != null) {
            Iterator<Object> keys = this.getReplicatedKeyIterator();
            while (keys.hasNext()) {
                this.updatePassport(keys.next().toString());
            }
        }
        this.reloading = false;
    }

    private void updatePassport(String key) {
        if (key != null && !this.passports.containsKey(key)) {
            Passport passport = this.replicatedCache.get(key);
            if (passport != null && !passport.isExpired()) {
                this.passports.put(key, passport);
            } else {
                this.replicatedCache.remove(key);
            }
        }
    }

    private Iterator<Object> getReplicatedKeyIterator() {
        return this.replicatedCache.getPassportIDs();
    }
}

