/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.ExpiringEntry;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.TenancyInfoImpl;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.VisaHelper;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.legacy.auth.BaseLegacyVisa;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PassportImpl
extends ExpiringEntry
implements Passport {
    private static final String NULL_STRING = "null";
    private static final long serialVersionUID = 1L;
    private String primaryNsID;
    private int generation;
    private boolean canUserCallLogon;
    private String tiedRemoteUser;
    private Map<String, InternalVisa> visas;
    private HashSet<String> globalIdentity;
    private HashSet<String> roles;
    private TenancyInfo tenancyInfo;
    private boolean dirty;
    private boolean hasDoneLogonResponse;

    public PassportImpl() {
        this.dirty = true;
        this.tenancyInfo = new TenancyInfoImpl();
    }

    public PassportImpl(String thePassportID, long theInactivityTimeout, long validUntil) {
        super(thePassportID, theInactivityTimeout, validUntil);
        this.primaryNsID = null;
        this.generation = 1;
        this.canUserCallLogon = true;
        this.visas = new HashMap<String, InternalVisa>();
        this.globalIdentity = new HashSet();
        this.roles = new HashSet();
        this.dirty = true;
        this.hasDoneLogonResponse = false;
        this.tenancyInfo = new TenancyInfoImpl();
    }

    @Override
    public synchronized void add(String theNamespaceID, InternalVisa theVisa) {
        if (this.primaryNsID == null) {
            this.primaryNsID = theNamespaceID;
        }
        if (this.visas.containsKey(theNamespaceID)) {
            throw new RuntimeException("A visa already exists for this namespace.");
        }
        this.visas.put(theNamespaceID, theVisa);
        this.dirty = true;
    }

    @Override
    public synchronized void addIdentity(Set<String> theNamespaceIdentity) {
        this.globalIdentity.addAll(theNamespaceIdentity);
        ++this.generation;
        this.dirty = true;
    }

    @Override
    public synchronized void addRoles(Set<String> theRoles) {
        this.roles.addAll(theRoles);
        this.dirty = true;
    }

    @Override
    public boolean canUserCallLogon() {
        return this.canUserCallLogon;
    }

    @Override
    public synchronized void cleanup() {
        this.expire();
        super.cleanup();
    }

    @Override
    public synchronized void cloneFrom(Passport passport) throws IOException, ClassNotFoundException, CloneNotSupportedException {
        PassportImpl thePassport = (PassportImpl)passport;
        this.primaryNsID = thePassport.getPrimaryNsID();
        this.setInactivityTimeout(thePassport.getInactivityTimeout());
        this.setValidUntil(thePassport.getValidUntil());
        for (Map.Entry<String, InternalVisa> entry : thePassport.getVisas().entrySet()) {
            String namespaceId = entry.getKey();
            InternalVisa intVisa = entry.getValue();
            InternalVisa clonedIntVisa = new InternalVisa(intVisa.getCAMID(), intVisa.getDisplayName(), intVisa.getUsername());
            Visa theVisa = intVisa.getVisa();
            if (theVisa instanceof BaseLegacyVisa) {
                BaseLegacyVisa theBaseLegacyVisa = (BaseLegacyVisa)intVisa.getVisa();
                BaseLegacyVisa clonedVisa = theBaseLegacyVisa.cloneVisa();
                clonedIntVisa.setVisa(clonedVisa);
            } else {
                Visa clonedVisa = VisaHelper.cloneVisaUsingExternalizable((Visa)theVisa);
                clonedIntVisa.setVisa(clonedVisa);
            }
            this.visas.put(namespaceId, clonedIntVisa);
        }
        this.globalIdentity = (HashSet)thePassport.getIdentity();
        this.roles = (HashSet)thePassport.getRoles();
        this.tiedRemoteUser = thePassport.getTiedRemoteUser();
        this.generation = thePassport.getGeneration();
        this.canUserCallLogon = thePassport.canUserCallLogon();
        this.tenancyInfo = (TenancyInfo)thePassport.getTenancyInfo().clone();
    }

    @Override
    public synchronized void destroy() {
        super.cleanup();
    }

    public synchronized void expire() {
        this.handlePassportExpiration(null, false);
    }

    @Override
    public synchronized Visa get(String theNamespaceID) {
        if (this.visas.containsKey(theNamespaceID)) {
            InternalVisa internalVisa = this.visas.get(theNamespaceID);
            return internalVisa.getVisa();
        }
        return null;
    }

    @Override
    public synchronized Set<String> getAuthenticatedNamespaceIDs() {
        return new HashSet<String>(this.visas.keySet());
    }

    @Override
    public Set<String> getCognosIdentity() {
        HashSet<String> myCognosIdentity = new HashSet<String>();
        Set<String> myIdentity = this.getIdentity();
        for (String anIdentity : myIdentity) {
            if (!anIdentity.startsWith("CAMID(\"::")) continue;
            myCognosIdentity.add(anIdentity);
        }
        return myCognosIdentity;
    }

    @Override
    public boolean getDidLogonResponse() {
        return this.hasDoneLogonResponse;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public synchronized Set<String> getIdentity() {
        return new HashSet<String>(this.globalIdentity);
    }

    @Override
    public synchronized InternalVisa getInternalVisa(String theNamespaceID) {
        if (this.visas.containsKey(theNamespaceID)) {
            return this.visas.get(theNamespaceID);
        }
        return null;
    }

    @Override
    public synchronized String getPrimaryNsID() {
        return this.primaryNsID;
    }

    @Override
    public synchronized Set<String> getRoles() {
        return new HashSet<String>(this.roles);
    }

    @Override
    public TenancyInfo getTenancyInfo() {
        return this.tenancyInfo;
    }

    @Override
    public String getTiedRemoteUser() {
        return this.tiedRemoteUser;
    }

    private Map<String, InternalVisa> getVisas() {
        return this.visas;
    }

    private void handlePassportExpiration(String theRequestContext, boolean forcedLogoff) {
        PassportManager.getInstance().expirePassport(this.getID(), theRequestContext, forcedLogoff);
        PassportManager.getInstance().destroyPassport(this.getID());
    }

    @Override
    public synchronized boolean hasStateChanged() {
        boolean isDirty = false;
        if (this.dirty || this.tenancyInfo.hasStateChanged()) {
            isDirty = true;
        } else if (this.visas != null && !this.visas.isEmpty()) {
            for (InternalVisa aVisa : this.visas.values()) {
                if (!aVisa.getVisa().hasStateChanged()) continue;
                isDirty = true;
                break;
            }
        }
        return isDirty;
    }

    @Override
    public synchronized void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Unkown version: " + Long.toString(version));
        }
        this.primaryNsID = in.readUTF();
        if (this.primaryNsID.equals(NULL_STRING)) {
            this.primaryNsID = null;
        }
        this.visas = new HashMap<String, InternalVisa>();
        int nbVisa = in.readInt();
        for (int i = 0; i < nbVisa; ++i) {
            String namespaceID = in.readUTF();
            InternalVisa visa = (InternalVisa)in.readObject();
            this.visas.put(namespaceID, visa);
        }
        this.globalIdentity = new HashSet();
        int nbIds = in.readInt();
        for (int i = 0; i < nbIds; ++i) {
            String id = in.readUTF();
            this.globalIdentity.add(id);
        }
        this.roles = new HashSet();
        int nbRoles = in.readInt();
        for (int i = 0; i < nbRoles; ++i) {
            String role = in.readUTF();
            this.roles.add(role);
        }
        this.tiedRemoteUser = in.readUTF();
        if (this.tiedRemoteUser.equals(NULL_STRING)) {
            this.tiedRemoteUser = null;
        }
        this.generation = in.readInt();
        this.canUserCallLogon = in.readBoolean();
        this.tenancyInfo = (TenancyInfoImpl)in.readObject();
        this.dirty = true;
    }

    @Override
    public synchronized void resetChangeIndicator() {
        this.dirty = false;
        if (this.visas != null && !this.visas.isEmpty()) {
            for (InternalVisa intVisa : this.visas.values()) {
                Visa aVisa = intVisa.getVisa();
                if (aVisa == null) continue;
                aVisa.resetChangeIndicator();
            }
        }
        this.tenancyInfo.resetChangeIndicator();
    }

    @Override
    public synchronized void selectRoles(Set<String> theSelectedRoles) throws UnrecoverableException {
        if (!this.roles.containsAll(theSelectedRoles)) {
            Message message = new Message("AAA_AUT_INVALID_ROLE_SELECTION");
            throw new UnrecoverableException(Passport.class.getName(), (LocalizableMessage)message, (LocalizableMessage)message);
        }
        this.globalIdentity.removeAll(this.roles);
        this.globalIdentity.addAll(theSelectedRoles);
        ++this.generation;
        this.dirty = true;
    }

    @Override
    public void setCanUserCallLogon(boolean canUserCallLogonFlag) {
        this.canUserCallLogon = canUserCallLogonFlag;
        this.dirty = true;
    }

    @Override
    public void setDidLogonResponse() {
        this.hasDoneLogonResponse = true;
    }

    @Override
    public void setTiedRemoteUser(String theTiedRemoteUser) {
        this.tiedRemoteUser = theTiedRemoteUser;
        this.dirty = true;
    }

    public synchronized void terminate(String theRequestContext) {
        this.handlePassportExpiration(theRequestContext, true);
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(1L);
        if (this.primaryNsID == null) {
            out.writeUTF(NULL_STRING);
        } else {
            out.writeUTF(this.primaryNsID);
        }
        Set<String> namespaceIDs = this.visas.keySet();
        out.writeInt(namespaceIDs.size());
        for (String namespaceID : namespaceIDs) {
            out.writeUTF(namespaceID);
            InternalVisa visa = this.visas.get(namespaceID);
            out.writeObject(visa);
        }
        out.writeInt(this.globalIdentity.size());
        for (String id : this.globalIdentity) {
            out.writeUTF(id);
        }
        out.writeInt(this.roles.size());
        for (String role : this.roles) {
            out.writeUTF(role);
        }
        if (this.tiedRemoteUser == null) {
            out.writeUTF(NULL_STRING);
        } else {
            out.writeUTF(this.tiedRemoteUser);
        }
        out.writeInt(this.generation);
        out.writeBoolean(this.canUserCallLogon);
        out.writeObject(this.tenancyInfo);
        out.flush();
    }
}

