/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.DestroyCmSessionTask;
import com.ibm.cognos.camaaa.internal.auth.InternalCAMCookieImpl;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportCache;
import com.ibm.cognos.camaaa.internal.auth.PassportImpl;
import com.ibm.cognos.camaaa.internal.auth.UniqueIDGenerator;
import com.ibm.cognos.camaaa.internal.auth.handler.DispatchToNamespaceUtility;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidCfgAttributeValueException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContextImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapHeader;
import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import com.ibm.cognos.camaaa.internal.common.util.TimerPruningTask;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class PassportManager
implements ConfigurationListener {
    public static final String SYSTEM_ADMINISTRATOR_ROLE = "CAMID(\"::System Administrators\")";
    public static final String TENANT_ADMINISTRATOR_ROLE = "CAMID(\"::Tenant Administrators\")";
    static final String ALLOW_ANON_PARAMETER = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"allowAnon\"]/*[local-name()='value']/text()";
    static final String SECURE_RANDOM_ALGORITHM_PARAMETER = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"secureRandomAlgorithm\"]/*[local-name()='value']/text()";
    static final String SECURE_RANDOM_PROVIDER_PARAMETER = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"secureRandomProvider\"]/*[local-name()='value']/text()";
    static final String INACTIVITY_TIMEOUT_PARAMETER = "./*[local-name()='parameter'][@name=\"inactivityTimeout\"]/*[local-name()='value']/text()";
    static final String MAX_SESSION_LIFETIME_PARAMETER = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"maximumSessionLifetime\"]/*[local-name()='value']/text()";
    static final String IS_SECURITY_ENABLED_PARAMETER = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class!=\"Cognos\"]";
    static final String IS_NEWCOOKIE_ENABLED_PARAMETER = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"newCookie\"]/*[local-name()='value']/text()";
    static final String CM_DISABLED_PARAMETER = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]/*[local-name()='parameter'][@name=\"disableCM\"]/*[local-name()='value']/text()";
    private static final String FLAG_SET = "1";
    private static final String FLAG_NOT_SET = "0";
    private static final String PID_SEPARATOR = ":";
    private static final int PID_HEADER_SIZE = 4;
    private static final int PID_HEADER_NAMED_USER_FLAG_START = 2;
    private static final int PID_HEADER_NAMED_USER_FLAG_END = 3;
    private static final String COGNOS_INSTANCE = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class=\"Cognos\"]";
    private static final String ADVANCED_PROPERTIES = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']";
    private static final String THIRTY_SIX_HUNDRED = "3600";
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private static final int PASSPORT_PRUNING_FREQUENCY = 60000;
    private static final String PASSPORT_MANAGER_CONFIGURATION_CHANGED = "PassportManager.configurationChanged";
    private static String anonymousUserPidHeader;
    private static String namedUserPidHeader;
    private static PassportManager instance;
    private final PassportCache passportCache = new PassportCache();
    private UniqueIDGenerator uniqueIDGenerator = null;
    private String id = null;
    private boolean isSecurityEnabled = false;
    private boolean isAnonymousAllowed = false;
    private boolean isCMDisabled = false;
    private long inactivityTimeout = 0L;
    private long maximumLifetime = 0L;
    private final TimerPruningTask timerPruningTask;
    private DyeTraceManagerMBean dyeTraceManager;
    private boolean newCookieFormat;
    private int refCount = 0;
    private TraceLogger traceLogger;
    private final Timer timer;
    private HandlerBinding binding;

    private PassportManager() {
        this(new TimerPruningTask());
    }

    private PassportManager(TimerPruningTask timerTask) {
        this.timerPruningTask = timerTask;
        this.timer = new Timer(true);
        this.binding = null;
        this.timer.schedule((TimerTask)this.timerPruningTask, 0L, 60000L);
        this.dyeTraceManager = null;
        this.newCookieFormat = false;
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    public static synchronized PassportManager getInstance() {
        if (instance == null) {
            instance = new PassportManager();
        }
        return instance;
    }

    static synchronized PassportManager getInstance(TimerPruningTask theTimerPruningTask) {
        if (instance == null) {
            instance = new PassportManager(theTimerPruningTask);
        }
        return instance;
    }

    public static synchronized void setInstance(PassportManager passportMgr) {
        instance = passportMgr;
    }

    private static boolean isMatchingTenantID(String tenant1, String tenant2) {
        boolean retval = false;
        retval = tenant1 == null && tenant2 == null ? true : tenant1 != null && tenant2 != null && tenant1.compareTo(tenant2) == 0;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, PASSPORT_MANAGER_CONFIGURATION_CHANGED);
        PassportManager passportManager = this;
        synchronized (passportManager) {
            boolean oldIsAnonymousAllowed = this.isAnonymousAllowed;
            long oldInactivityTimeout = this.inactivityTimeout;
            long oldMaximumLifetime = this.maximumLifetime;
            boolean oldIsSecurityEnabled = this.isSecurityEnabled;
            String value = null;
            value = theNewConfiguration.getOptionalValue(INACTIVITY_TIMEOUT_PARAMETER, THIRTY_SIX_HUNDRED);
            this.inactivityTimeout = Integer.valueOf(value).longValue() * 1000L;
            value = theNewConfiguration.getOptionalValue(MAX_SESSION_LIFETIME_PARAMETER, FLAG_NOT_SET);
            this.maximumLifetime = Integer.valueOf(value).longValue() * 1000L;
            value = theNewConfiguration.getOptionalValue(ALLOW_ANON_PARAMETER, Boolean.FALSE.toString());
            this.isAnonymousAllowed = Boolean.valueOf(value);
            value = theNewConfiguration.getOptionalValue(IS_SECURITY_ENABLED_PARAMETER, null);
            this.isSecurityEnabled = value != null;
            LogData logData = this.traceLogger.getLogData();
            logData.addParameter("Old is anonymous enabled value: ", Boolean.toString(oldIsAnonymousAllowed));
            logData.addParameter("New is anonymous enabled value: ", Boolean.toString(this.isAnonymousAllowed));
            logData.addParameter("Old inativity timeout value: ", Long.toString(oldInactivityTimeout));
            logData.addParameter("New inativity timeout value: ", Long.toString(this.inactivityTimeout));
            logData.addParameter("Old maximum lifetime value: ", Long.toString(oldMaximumLifetime));
            logData.addParameter("New maximum lifetime value: ", Long.toString(this.maximumLifetime));
            logData.addParameter("Old is security enabled value: ", Boolean.toString(oldIsSecurityEnabled));
            logData.addParameter("New is security enabled value: ", Boolean.toString(this.isSecurityEnabled));
            this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL1, "PassportManager.values", logData);
            String header = new String();
            header = this.isSecurityEnabled ? header + FLAG_SET : header + FLAG_NOT_SET;
            header = this.isAnonymousAllowed ? header + FLAG_SET : header + FLAG_NOT_SET;
            anonymousUserPidHeader = header + FLAG_NOT_SET + PID_SEPARATOR + this.id + PID_SEPARATOR;
            namedUserPidHeader = header + FLAG_SET + PID_SEPARATOR;
            if (oldIsAnonymousAllowed && !this.isAnonymousAllowed) {
                this.terminateSessions(passport -> passport.getAuthenticatedNamespaceIDs().contains(""));
            }
            this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, PASSPORT_MANAGER_CONFIGURATION_CHANGED);
        }
    }

    public synchronized void configure(Configuration theConfiguration) throws SoapFaultException {
        if (this.refCount++ > 0) {
            if (this.hasConfigChanged(theConfiguration)) {
                throw new RuntimeException("The passport manager is already configured.");
            }
            return;
        }
        if (theConfiguration instanceof ConfigurationManager) {
            ((ConfigurationManager)theConfiguration).addListener(this);
        }
        try {
            String value = null;
            this.isAnonymousAllowed = true;
            this.isSecurityEnabled = false;
            value = theConfiguration.getOptionalValue(IS_NEWCOOKIE_ENABLED_PARAMETER, Boolean.TRUE.toString());
            this.newCookieFormat = Boolean.valueOf(value);
            value = theConfiguration.getOptionalValue(CM_DISABLED_PARAMETER, Boolean.FALSE.toString());
            this.isCMDisabled = Boolean.valueOf(value);
            this.initializeUniqueIDGenerator(theConfiguration);
            this.id = this.uniqueIDGenerator.generateGUID();
            this.configurationChanged(theConfiguration);
            this.passportCache.initialize(theConfiguration);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidCfgAttributeValueException(PassportManager.class.getName(), null, SECURE_RANDOM_ALGORITHM_PARAMETER, e);
        }
        catch (NoSuchProviderException e) {
            throw new InvalidCfgAttributeValueException(PassportManager.class.getName(), null, SECURE_RANDOM_PROVIDER_PARAMETER, e);
        }
    }

    public synchronized void configure(Configuration theConfiguration, HandlerBinding theBinding, DyeTraceManagerMBean dyeTracingManager) throws SoapFaultException {
        this.binding = theBinding;
        this.configure(theConfiguration);
        this.dyeTraceManager = dyeTracingManager;
    }

    public Passport createAnonymousSession() {
        if (this.isAnonymousAllowed) {
            return this.createPassport(this.generateAnonymousSessionID());
        }
        return null;
    }

    private MessageContext createEmptyMessageContext(String theRequestContext, boolean forcedLogoff) throws SoapFaultException {
        Document doc;
        MessageContextImpl mc = new MessageContextImpl();
        String emptyRequest = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader></bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body/></SOAP-ENV:Envelope>";
        try {
            doc = DocumentHelper.parseText((String)"<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><SOAP-ENV:Header><bus:biBusHeader></bus:biBusHeader></SOAP-ENV:Header><SOAP-ENV:Body/></SOAP-ENV:Envelope>");
        }
        catch (DocumentException e) {
            throw new InternalErrorException(this.getClass().getName(), (Exception)((Object)e));
        }
        Element requestElement = doc.getRootElement();
        SoapEnvelopeRequestImpl request = new SoapEnvelopeRequestImpl(requestElement);
        RequestContextImpl requestContext = new RequestContextImpl(requestElement);
        if (theRequestContext != null) {
            requestContext.getLogContext().setRequestContext(theRequestContext);
        }
        SoapEnvelopeResponseImpl response = new SoapEnvelopeResponseImpl(requestElement, requestContext);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest", request);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.requestContext", requestContext);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", response);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", this.binding);
        if (forcedLogoff) {
            mc.put((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT, (Object)MessageContextImpl.PassportExpireEvent.FORCEDLOGOFF);
        } else {
            mc.put((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT, (Object)MessageContextImpl.PassportExpireEvent.LOGONEXPIRED);
        }
        return mc;
    }

    public Passport createNamedUserSession() {
        if (this.isSecurityEnabled) {
            return this.createPassport(this.generateNamedUserSessionID());
        }
        return null;
    }

    private Passport createPassport(String thePassportID) {
        long validUntil = this.maximumLifetime > 0L ? System.currentTimeMillis() + this.maximumLifetime : Long.MAX_VALUE;
        PassportImpl passport = new PassportImpl(thePassportID, this.inactivityTimeout, validUntil);
        this.passportCache.put(passport.getID(), passport);
        this.timerPruningTask.add((TimedObject)passport);
        return passport;
    }

    private synchronized void destroy() {
        if (this.refCount == 1) {
            this.passportCache.shutdown();
            this.isAnonymousAllowed = false;
            this.isSecurityEnabled = false;
            this.timer.cancel();
            while (!this.passportCache.isEmpty()) {
                for (String passportId : this.passportCache.keys()) {
                    this.expirePassport(passportId, null, false);
                    this.destroyPassport(passportId);
                }
            }
        }
        --this.refCount;
    }

    public void destroyPassport(String thePassportID) {
        Passport passport = this.passportCache.remove(thePassportID);
        if (passport != null) {
            this.timerPruningTask.remove((TimedObject)passport);
            passport.destroy();
            this.logoffFromCM(passport);
        }
    }

    public void expirePassport(String thePassportID, String theRequestContext, boolean forcedLogoff) {
        Passport passport = this.passportCache.get(thePassportID);
        if (passport != null) {
            try {
                this.logoffFromNamepaces(passport, theRequestContext, forcedLogoff);
            }
            catch (SoapFaultException soapFaultException) {
                // empty catch block
            }
        }
    }

    private String generateAnonymousSessionID() {
        StringBuffer sessionID = new StringBuffer(55);
        sessionID.append(anonymousUserPidHeader);
        sessionID.append(this.uniqueIDGenerator.getID());
        return sessionID.toString();
    }

    private String generateNamedUserSessionID() {
        StringBuffer sessionID = new StringBuffer(55);
        sessionID.append(namedUserPidHeader);
        sessionID.append(this.uniqueIDGenerator.generateGUID());
        sessionID.append(PID_SEPARATOR);
        sessionID.append(this.uniqueIDGenerator.getID());
        return sessionID.toString();
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{INACTIVITY_TIMEOUT_PARAMETER, ALLOW_ANON_PARAMETER, IS_SECURITY_ENABLED_PARAMETER, MAX_SESSION_LIFETIME_PARAMETER};
    }

    public Passport getPassport(String thePassportID) {
        Passport passport = this.passportCache.get(thePassportID);
        if (passport != null && passport.isExpired()) {
            passport = null;
        }
        return passport;
    }

    public Collection<Passport> getVisibleSession(Passport thePassport) throws SoapFaultException {
        Collection<Passport> allPassports = this.passportCache.values();
        ArrayList<Passport> sessions = new ArrayList<Passport>();
        if (thePassport.getIdentity().contains(SYSTEM_ADMINISTRATOR_ROLE)) {
            sessions.addAll(allPassports);
        } else {
            Iterator<Passport> sIt = allPassports.iterator();
            String primaryNs = thePassport.getPrimaryNsID();
            String tenantID = thePassport.getTenancyInfo().getTenancy(TenancyInfo.TenancyType.TENANTID);
            Set<String> identity = thePassport.getIdentity();
            while (sIt.hasNext()) {
                Passport p = sIt.next();
                if (!PassportManager.isMatchingTenantID(tenantID, p.getTenancyInfo().getTenancy(TenancyInfo.TenancyType.TENANTID)) || !p.getPrimaryNsID().equals(primaryNs) || !identity.containsAll(p.getIdentity())) continue;
                sessions.add(p);
            }
        }
        return sessions;
    }

    private boolean hasConfigChanged(Configuration theConfiguration) {
        String value = null;
        value = theConfiguration.getOptionalValue(INACTIVITY_TIMEOUT_PARAMETER, THIRTY_SIX_HUNDRED);
        long tmpInactivityTimeout = Integer.valueOf(value).longValue() * 1000L;
        value = theConfiguration.getOptionalValue(MAX_SESSION_LIFETIME_PARAMETER, FLAG_NOT_SET);
        long tmpMaximumLifetime = Integer.valueOf(value).longValue() * 1000L;
        value = theConfiguration.getOptionalValue(ALLOW_ANON_PARAMETER, Boolean.FALSE.toString());
        boolean tmpIsAnonymousAllowed = Boolean.valueOf(value);
        value = theConfiguration.getOptionalValue(IS_SECURITY_ENABLED_PARAMETER, null);
        boolean tmpIsSecurityEnabled = value != null;
        value = theConfiguration.getOptionalValue(IS_NEWCOOKIE_ENABLED_PARAMETER, Boolean.TRUE.toString());
        boolean tmpNewCookieFormat = Boolean.valueOf(value);
        value = theConfiguration.getOptionalValue(CM_DISABLED_PARAMETER, Boolean.FALSE.toString());
        boolean tmpIsCMDisabled = Boolean.valueOf(value);
        boolean result1 = this.inactivityTimeout != tmpInactivityTimeout || this.isAnonymousAllowed != tmpIsAnonymousAllowed || this.isSecurityEnabled != tmpIsSecurityEnabled || this.maximumLifetime != tmpMaximumLifetime;
        boolean result2 = this.newCookieFormat != tmpNewCookieFormat || this.isCMDisabled != tmpIsCMDisabled;
        return result1 || result2;
    }

    private void initializeUniqueIDGenerator(Configuration theConfiguration) throws NoSuchAlgorithmException, NoSuchProviderException {
        String theSecureRandomAlgorithm = null;
        String theSecureRandomProvider = null;
        theSecureRandomAlgorithm = theConfiguration.getOptionalValue(SECURE_RANDOM_ALGORITHM_PARAMETER, null);
        theSecureRandomProvider = theConfiguration.getOptionalValue(SECURE_RANDOM_PROVIDER_PARAMETER, null);
        SecureRandom prng = null;
        prng = theSecureRandomProvider != null ? SecureRandom.getInstance(theSecureRandomAlgorithm, theSecureRandomProvider) : (theSecureRandomAlgorithm != null ? SecureRandom.getInstance(theSecureRandomAlgorithm) : new SecureRandom());
        this.uniqueIDGenerator = new UniqueIDGenerator(prng);
    }

    public boolean isAnonymousPassportID(String thePassportID) {
        return !this.isNamedUserPassportID(thePassportID);
    }

    public boolean isNamedUserPassportID(String thePassportID) {
        if (thePassportID.length() > 4) {
            return thePassportID.substring(2, 3).equals(FLAG_SET);
        }
        return false;
    }

    private void logoffFromCM(Passport thePassport) {
        String primaryNamespaceID = thePassport.getPrimaryNsID();
        InternalVisa visa = thePassport.getInternalVisa(primaryNamespaceID);
        if (visa != null) {
            DestroyCmSessionTask task = new DestroyCmSessionTask(thePassport.getID(), visa.getCAMID());
            task.run();
        }
    }

    private void logoffFromNamepaces(Passport thePassport, String theRequestContext, boolean forcedLogoff) throws SoapFaultException {
        if (this.binding == null || thePassport == null) {
            return;
        }
        MessageContext mc = this.createEmptyMessageContext(theRequestContext, forcedLogoff);
        Set<String> nsIDs = thePassport.getAuthenticatedNamespaceIDs();
        Iterator<String> it = nsIDs.iterator();
        while (it.hasNext()) {
            this.populateContext(mc, thePassport);
            String nsID = it.next();
            Visa visa = thePassport.get(nsID);
            if (visa == null) continue;
            DispatchToNamespaceUtility.logoff(visa, nsID, mc);
        }
    }

    private void populateContext(MessageContext theContext, Passport thePassport) {
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)thePassport);
        SoapEnvelopeRequest request = (SoapEnvelopeRequest)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        InternalCAMCookieImpl cookie = new InternalCAMCookieImpl(thePassport, this.newCookieFormat, this.dyeTraceManager.getDyeTracedUsers());
        String sessionID = cookie.getSessionContext();
        SoapHeader header = request.getHeader();
        header.getBiBusHeader().setSessionContext(sessionID);
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        this.populateLogContext(requestContext.getLogContext(), sessionID);
    }

    protected void populateLogContext(LogContext logContext, String sessionID) {
        String sessionContext = logContext.getSessionContext();
        String requestContextInsideLogContext = logContext.getRequestContext();
        if (sessionContext == null || sessionContext.length() == 0) {
            logContext.setSessionContext(sessionID);
        }
        if (requestContextInsideLogContext == null || requestContextInsideLogContext.length() == 0) {
            String fakeRequestContextInsideLogContext = logContext.getSessionContext() + "ThisIsASpecialRequestContext";
            logContext.setRequestContext(fakeRequestContextInsideLogContext);
        }
    }

    public synchronized void terminateSessions(Predicate<Passport> tester) {
        Collection<Passport> allPassports = this.passportCache.values();
        for (Passport passport : allPassports) {
            if (!tester.test(passport)) continue;
            ((PassportImpl)passport).terminate(null);
        }
    }

    public void updateIfRequired(Passport passport) {
        if (passport != null) {
            this.passportCache.update(passport.getID(), passport);
        }
    }
}

