/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.AuditLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.TimerTask;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;

public class RenewTCTask
extends TimerTask {
    private static final String LOGOFF = "logoff";
    private static final String AUDIT_RTUSAGE_CAM_AAA = "Audit.RTUsage.CAM.AAA.SRVC";
    private static final String RENEW_TC_HANDLER_CHAIN = "processRenewTrustedCredential";
    private static final QName RENEWTC_QNAME = new QName("renewTC", new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/"));
    private static final QName LOGOFF_QNAME = new QName("logoff", new Namespace("bus", "http://developer.cognos.com/schemas/bibus/3/"));
    private static final Namespace SOAP_ENV_NS = new Namespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
    private static final QName SOAP_BODY_QNAME = new QName("Body", SOAP_ENV_NS);
    private final HandlerBinding binding;
    private final String originalResponse;
    private final String nsId;
    private final String credentialPath;
    private final String passportId;
    private final LogContext logContext;
    private Passport passport;

    public RenewTCTask(HandlerBinding theBinding, String theOriginalResponse, String theNamespaceId, String theCredentialPath, String thePassportId, LogContext theLogContext) {
        this.binding = theBinding;
        this.originalResponse = theOriginalResponse;
        this.nsId = theNamespaceId;
        this.credentialPath = theCredentialPath;
        this.passportId = thePassportId;
        this.logContext = theLogContext;
    }

    private MessageContext createMessageContext(Element soapEnvElement) throws SoapFaultException, InterruptedException {
        MessageContextImpl mc = new MessageContextImpl(soapEnvElement);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", this.nsId);
        if (this.passport == null) {
            this.passport = PassportManager.getInstance().getPassport(this.passportId);
            this.passport.lock();
        }
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.passport", this.passport);
        mc.put("com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding", this.binding);
        return mc;
    }

    private Element createRequest(Element body) throws DocumentException {
        Document doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)this.originalResponse);
        Element soapEnvElement = doc.getRootElement();
        Node soapBodyNode = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)"./SOAP-ENV:Body", (Node)soapEnvElement);
        if (soapBodyNode != null) {
            soapEnvElement.remove(soapBodyNode);
        }
        soapEnvElement.add(body);
        return soapEnvElement;
    }

    protected void execute() throws Exception {
        Element soapEnvElement = this.createRequest(this.getRenewTCSoapBody());
        MessageContext mc = this.createMessageContext(soapEnvElement);
        this.handleRequest(mc, "clonePassportHandler");
        this.passport = (Passport)mc.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        try {
            this.handleRequest(mc, RENEW_TC_HANDLER_CHAIN);
        }
        catch (SoapFaultException e) {
            this.logRenewTCFailure(e);
        }
        Element logoffSoapEnvElement = this.createRequest(this.getLogoffSoapBody());
        MessageContext mcLogoff = this.createMessageContext(logoffSoapEnvElement);
        mcLogoff.put((Object)"clonedPassport", (Object)true);
        this.handleRequest(mcLogoff, "destroySession");
    }

    private void handleRequest(MessageContext mc, String handlerName) throws LocalizableException {
        Handler handler = this.binding.getHandler(handlerName);
        if (handler == null) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_HANDLER_NOT_FOUND", (Object[])new String[]{handlerName}));
        }
        this.binding.handleRequestRequired(mc, handler);
        this.passport = (Passport)mc.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
    }

    private Element getLogoffSoapBody() {
        Element soapBody = DocumentHelper.createElement((QName)SOAP_BODY_QNAME);
        soapBody.addElement(LOGOFF_QNAME);
        return soapBody;
    }

    private Element getRenewTCSoapBody() {
        Element soapBody = DocumentHelper.createElement((QName)SOAP_BODY_QNAME);
        Element renewTCElement = soapBody.addElement(RENEWTC_QNAME);
        Element namespacElement = renewTCElement.addElement("namespace");
        namespacElement.setText(this.nsId);
        return soapBody;
    }

    private void logException(String operation, Exception e) {
        LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)AUDIT_RTUSAGE_CAM_AAA, LogAuditIndication.class);
        LogAuditAccessIndication indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber());
        indication.setOperation(operation);
        indication.setStatus("Failure");
        indication.setLevel(10000);
        indication.setLogData(e.getLocalizedMessage());
        ipfLogger.log((Object)indication);
    }

    private void logRenewTCFailure(Throwable e) {
        InternalVisa visa = this.passport.getInternalVisa(this.passport.getPrimaryNsID());
        String username = visa.getUsername();
        String displayName = visa.getDisplayName();
        String camId = visa.getCAMID();
        LogTypedLogger typedLogger = LogTypedLogger.getInstance((String)AUDIT_RTUSAGE_CAM_AAA, LogAuditIndication.class);
        AuditLoggerImpl logger = new AuditLoggerImpl(typedLogger);
        LogDataImpl logData = new LogDataImpl();
        logData.addParameter("username", username);
        logData.addParameter("display name", displayName);
        logData.addParameter("CAMID", camId);
        logger.logRenewTCFailure(this.logContext, ComponentImpl.getInstance(), logData, this.credentialPath, e.getLocalizedMessage());
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            this.logException("RenewTCTask.execute()", e);
        }
        finally {
            if (this.passport != null) {
                try {
                    this.passport.unlock();
                }
                catch (Exception e) {
                    this.logException("RenewTCTask.passport.unlock()", e);
                }
            }
        }
    }
}

