/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.KerberosSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public final class SecurityBlobManager {
    private static final String EQUALS_CHAR = "=";
    private static final String ENCODING = "UTF-8";
    private static final String TRUSTED_ENVIRONMENT_TOKEN = "CAM_TOKENID_";
    private static final String ENVIRONMENT_TYPE_TOKEN = "Type=1";
    private static final String ENVIRONMENT_BLOB_DELIMITER = " , ";
    private static final String HASH_DELIMITER = " : ";
    private static final String UTF8 = "UTF8";

    private SecurityBlobManager() {
    }

    public static SecurityBlob createSecurityBlob(byte[] theSecurityContext) {
        String encodedSecurityBlob;
        KerberosSecurityBlob securityBlob = null;
        if (theSecurityContext != null && theSecurityContext.length > 0 && (encodedSecurityBlob = base64.encode((int)0, (byte[])theSecurityContext)) != null && encodedSecurityBlob.length() > 0) {
            securityBlob = new KerberosSecurityBlob(encodedSecurityBlob, theSecurityContext);
        }
        return securityBlob;
    }

    public static SecurityBlob createSecurityBlob(String theEncodedSecurityBlob) {
        SecurityBlob securityBlob = null;
        int hmacDigestOffset = -1;
        if (theEncodedSecurityBlob == null) {
            return securityBlob;
        }
        byte[] decodedBytes = base64.decode((int)0, (String)theEncodedSecurityBlob);
        if (decodedBytes != null) {
            String decodedSecurityBlob = null;
            try {
                hmacDigestOffset = SecurityBlobManager.determineHmacOffset(decodedBytes);
                int stringLength = hmacDigestOffset > 0 ? hmacDigestOffset - HASH_DELIMITER.length() : decodedBytes.length;
                decodedSecurityBlob = new String(decodedBytes, 0, stringLength, ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (decodedSecurityBlob != null && decodedSecurityBlob.startsWith(ENVIRONMENT_TYPE_TOKEN)) {
                securityBlob = SecurityBlobManager.parseEnvironmentSbData(decodedSecurityBlob, decodedBytes, theEncodedSecurityBlob, hmacDigestOffset);
            } else if (decodedSecurityBlob != null && decodedSecurityBlob.length() > 0) {
                securityBlob = SecurityBlobManager.parseKerberosSbData(decodedSecurityBlob, theEncodedSecurityBlob);
            }
        }
        return securityBlob;
    }

    public static SecurityBlob createSecurityBlob(String[] theRequestedVars, String tokenId) {
        EnvironmentSecurityBlob securityBlob = null;
        if (theRequestedVars != null && theRequestedVars.length > 0) {
            StringBuffer blob = new StringBuffer();
            blob.append(ENVIRONMENT_TYPE_TOKEN);
            boolean isValidBlob = true;
            for (int i = 0; i < theRequestedVars.length; ++i) {
                if (theRequestedVars[i].length() == 0) {
                    isValidBlob = false;
                    break;
                }
                blob.append(ENVIRONMENT_BLOB_DELIMITER);
                blob.append(theRequestedVars[i]);
            }
            if (isValidBlob && tokenId != null) {
                blob.append(ENVIRONMENT_BLOB_DELIMITER);
                blob.append(TRUSTED_ENVIRONMENT_TOKEN);
                blob.append(tokenId);
            }
            if (isValidBlob) {
                try {
                    String encodedSecurityBlob = base64.encode((int)0, (byte[])blob.toString().getBytes(ENCODING));
                    securityBlob = new EnvironmentSecurityBlob(encodedSecurityBlob, blob.toString(), theRequestedVars, tokenId, null);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return securityBlob;
    }

    private static int determineHmacOffset(byte[] decodedSbBytes) {
        int hmacDigestOffset = -1;
        byte[] hashDelimiter = null;
        try {
            hashDelimiter = HASH_DELIMITER.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            hmacDigestOffset = -1;
        }
        for (int i = 0; i < decodedSbBytes.length; ++i) {
            if (decodedSbBytes[i] != hashDelimiter[0] || decodedSbBytes.length <= i + 2 || decodedSbBytes[i + 1] != hashDelimiter[1] || decodedSbBytes[i + 2] != hashDelimiter[2]) continue;
            hmacDigestOffset = i + HASH_DELIMITER.length();
            break;
        }
        return hmacDigestOffset;
    }

    private static SecurityBlob parseEnvironmentSbData(String environmentRawData, byte[] decodedSbBytes, String theEncodedSecurityBlob, int hmacDigestOffset) {
        int tokenSeperator;
        EnvironmentSecurityBlob securityBlob = null;
        byte[] hmacDigest = null;
        if (hmacDigestOffset != -1) {
            int hmacDigestSize = decodedSbBytes.length - hmacDigestOffset;
            hmacDigest = new byte[hmacDigestSize];
            for (int i = 0; i < hmacDigestSize; ++i) {
                hmacDigest[i] = decodedSbBytes[i + hmacDigestOffset];
            }
        }
        ArrayList<String> envVars = new ArrayList<String>();
        String trustedTokenId = null;
        int startPos = 0;
        do {
            tokenSeperator = environmentRawData.indexOf(ENVIRONMENT_BLOB_DELIMITER, startPos);
            String token = null;
            token = tokenSeperator >= 0 ? environmentRawData.substring(startPos, tokenSeperator) : environmentRawData.substring(startPos);
            if (token.startsWith(TRUSTED_ENVIRONMENT_TOKEN)) {
                trustedTokenId = SecurityBlobManager.parseTrustedTokenData(token);
            } else if (!token.equals(ENVIRONMENT_TYPE_TOKEN)) {
                envVars.add(token);
            }
            startPos = ENVIRONMENT_BLOB_DELIMITER.length() + tokenSeperator;
        } while (tokenSeperator >= 0);
        if (envVars.size() > 0) {
            securityBlob = new EnvironmentSecurityBlob(theEncodedSecurityBlob, environmentRawData, envVars.toArray(new String[envVars.size()]), trustedTokenId, hmacDigest);
        }
        return securityBlob;
    }

    private static SecurityBlob parseKerberosSbData(String impersonateData, String theEncodedSecurityBlob) {
        KerberosSecurityBlob securityBlob = null;
        byte[] securityContextBytes = null;
        try {
            securityContextBytes = impersonateData.getBytes(ENCODING);
            securityBlob = new KerberosSecurityBlob(theEncodedSecurityBlob, securityContextBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return securityBlob;
    }

    private static String parseTrustedTokenData(String token) {
        String trustedTokenId = token.substring(TRUSTED_ENVIRONMENT_TOKEN.length());
        if (trustedTokenId.endsWith(EQUALS_CHAR)) {
            trustedTokenId = trustedTokenId.substring(0, trustedTokenId.length() - 1);
        }
        return trustedTokenId;
    }
}

