/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.auth.TrustedToken;
import com.ibm.cognos.camaaa.internal.auth.TrustedTokenImpl;
import com.ibm.cognos.camaaa.internal.auth.UniqueIDGenerator;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.util.TimedObjectMap;
import java.security.SecureRandom;

public final class TrustedTokenManager {
    private static final int TRUSTED_TOKEN_PRUNING_FREQUENCY = 60000;
    private static final long DEFAULT_VALIDITY_TIMEOUT = 120000L;
    private static final long MILLISECONDS_IN_A_SECOND = 1000L;
    private static final String ADVANCED_PROPERTIES_XPATH_EXPRESSION = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']";
    private static final String TRUSTED_ENV_VALIDITY_WINDOW_XPATH_EXPRESSION = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"trustedEnvValidityWindow\"]/*[local-name()='value']/text()";
    private static TrustedTokenManager instance;
    private final TimedObjectMap trustedTokensMap;
    private final UniqueIDGenerator uniqueIDGenerator = new UniqueIDGenerator(new SecureRandom());
    private boolean isConfigured = false;
    private long tokenValidityTimout = 120000L;

    private TrustedTokenManager() {
        this.trustedTokensMap = new TimedObjectMap(60000L);
    }

    public static synchronized void destroyInstance() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    public static synchronized TrustedTokenManager getInstance() {
        if (instance == null) {
            instance = new TrustedTokenManager();
        }
        return instance;
    }

    public synchronized void configure(Configuration theConfiguration) {
        if (this.isConfigured) {
            throw new RuntimeException("The trusted token manager is already configured.");
        }
        String validityTimeoutStr = theConfiguration.getOptionalValue(TRUSTED_ENV_VALIDITY_WINDOW_XPATH_EXPRESSION, null);
        if (validityTimeoutStr != null) {
            try {
                long validityWindow = Long.valueOf(validityTimeoutStr);
                if (validityWindow > 0L) {
                    this.tokenValidityTimout = validityWindow * 1000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.isConfigured = true;
    }

    public synchronized TrustedToken createTrustedToken() {
        String trustedTokenId = this.uniqueIDGenerator.getID();
        TrustedTokenImpl trustedToken = new TrustedTokenImpl(trustedTokenId.toString(), this.tokenValidityTimout);
        this.trustedTokensMap.put((Object)trustedToken.getID(), (Object)trustedToken);
        return trustedToken;
    }

    private synchronized void destroy() {
        this.isConfigured = false;
        this.tokenValidityTimout = 120000L;
        while (!this.trustedTokensMap.isEmpty()) {
            Object obj = this.trustedTokensMap.values().iterator().next();
            if (obj == null) continue;
            this.destroyTrustedToken(((TrustedToken)obj).getID());
        }
        this.trustedTokensMap.stopExpiry();
    }

    public synchronized void destroyTrustedToken(String theTrustedTokenId) {
        this.trustedTokensMap.remove((Object)theTrustedTokenId);
    }

    public synchronized TrustedToken getTrustedToken(String theTrustedTokenId) {
        TrustedToken trustedToken = null;
        if (this.trustedTokensMap.containsKey((Object)theTrustedTokenId) && (trustedToken = (TrustedToken)this.trustedTokensMap.get((Object)theTrustedTokenId)).isExpired()) {
            trustedToken = null;
        }
        return trustedToken;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }
}

