/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.ibm.cognos.camaaa.internal.common.util.Blob;
import java.security.SecureRandom;

class UniqueIDGenerator {
    private static final char DASH = '-';
    private static final int GUID_SIZE = 36;
    private static final int DATA1_SIZE = 8;
    private static final int DATA2_SIZE = 4;
    private static final int DATA3_SIZE = 4;
    private static final int DATA4_SIZE = 4;
    private static final int DATA5_SIZE = 12;
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int SIZEOF_UNSIGNED_INT = 4;
    private static final int SIZEOF_INT = 4;
    private static final int NIBBLE = 15;
    private static final int ID_ALIGNMENT = 10;
    private final SecureRandom rng;

    UniqueIDGenerator(SecureRandom thePRNG) {
        this.rng = thePRNG;
    }

    String generateGUID() {
        StringBuffer guid = new StringBuffer(36);
        guid.append(this.getHexString(8));
        guid.append('-');
        guid.append(this.getHexString(4));
        guid.append('-');
        guid.append(this.getHexString(4));
        guid.append('-');
        guid.append(this.getHexString(4));
        guid.append('-');
        guid.append(this.getHexString(12));
        return guid.toString();
    }

    String getHexString(int theLength) {
        byte[] randomData = new byte[theLength];
        int charsLeft = theLength;
        this.rng.nextBytes(randomData);
        StringBuffer retval = new StringBuffer(theLength);
        for (int i = 0; charsLeft > 0 && i < theLength; ++i) {
            retval.append(Integer.toHexString(randomData[i] >> 4 & 0xF));
            if (--charsLeft <= 0) continue;
            retval.append(Integer.toHexString(randomData[i] >> 0 & 0xF));
            --charsLeft;
        }
        return retval.toString();
    }

    String getID() {
        StringBuffer retval = new StringBuffer(10);
        byte[] bytes = new byte[4];
        this.rng.nextBytes(bytes);
        String id = Long.toString((long)Blob.getInt((byte[])bytes, (int)0) & 0xFFFFFFFFL);
        for (int i = id.length(); i < 10; ++i) {
            retval.append('0');
        }
        retval.append(id);
        return retval.toString();
    }
}

