/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.ibm.cognos.camaaa.internal.auth.UserSession;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class UserSessionImpl
implements UserSession {
    private byte[] userSessionId;
    private UserSessionIDSession session;

    public UserSessionImpl(UserSessionIDSession theSession, int days) throws UnrecoverableException {
        try {
            this.session = theSession;
            this.userSessionId = this.session.generateUserSessionID(days);
        }
        catch (CAMCryptoException e) {
            throw new UnrecoverableException(this.getClass().getName(), (LocalizableMessage)new Message("AAA_CAP_E_CLIENT_DID_SOMETHING_WRONG"), (LocalizableMessage)new Message("AAA_AUT_FAILED_CREATE_USER_SESSION_ID"), (Exception)((Object)e));
        }
    }

    public UserSessionImpl(UserSessionIDSession theSession, String theUserSessionId) throws UnrecoverableException {
        this.session = theSession;
        this.userSessionId = theUserSessionId.getBytes();
    }

    @Override
    public void extendTimeout(int days) throws UnrecoverableException {
        try {
            this.userSessionId = this.session.updateUserSessionID(this.userSessionId, days);
        }
        catch (CAMCryptoException e) {
            throw new UnrecoverableException(this.getClass().getName(), (LocalizableMessage)new Message("AAA_CAP_E_CLIENT_DID_SOMETHING_WRONG"), (LocalizableMessage)new Message("AAA_AUT_FAILED_EXTEND_USER_SESSION_ID"), (Exception)((Object)e));
        }
    }

    @Override
    public String getUserSessionId() {
        return new String(this.userSessionId);
    }

    @Override
    public int verify() throws UnrecoverableException {
        try {
            return this.session.verifyUserSessionID(this.userSessionId);
        }
        catch (CAMCryptoException e) {
            throw new UnrecoverableException(this.getClass().getName(), (LocalizableMessage)new Message("AAA_CAP_E_CLIENT_DID_SOMETHING_WRONG"), (LocalizableMessage)new Message("AAA_AUT_INVALID_USER_SESSION_ID"), (Exception)((Object)e));
        }
    }
}

