/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.UserSessionIDSession;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.UserSession;
import com.ibm.cognos.camaaa.internal.auth.UserSessionImpl;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public final class UserSessionManager {
    private static final String CLASS_NAME = UserSessionManager.class.toString();

    private UserSessionManager() {
    }

    private static UserSessionIDSession createUserSessionIDSession(CAMFactory theCamFactory) throws UnrecoverableException {
        try {
            return theCamFactory.createUserSessionIDSession();
        }
        catch (CAMCryptoException e) {
            throw new UnrecoverableException(CLASS_NAME, (LocalizableMessage)new Message("AAA_CAP_E_CLIENT_DID_SOMETHING_WRONG"), (LocalizableMessage)new Message("AAA_AUT_FAILED_CREATE_USER_SESSION_ID"), (Exception)((Object)e));
        }
    }

    public static void generateUserSessionID(CAMFactory theCamFactory, MessageContext theContext, int userSessionTimeout) throws UnrecoverableException {
        UserSessionImpl session;
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        String userSessionID = request.getHeader().getBiBusHeader().getUserSessionID();
        if (userSessionID == null) {
            session = new UserSessionImpl(UserSessionManager.createUserSessionIDSession(theCamFactory), userSessionTimeout);
        } else {
            session = new UserSessionImpl(UserSessionManager.createUserSessionIDSession(theCamFactory), userSessionID);
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            PassportManager passportMgr = PassportManager.getInstance();
            if (passport == null || passportMgr.isAnonymousPassportID(passport.getID())) {
                switch (session.verify()) {
                    case -1: {
                        throw new UnrecoverableException(UserSession.class.getName(), (LocalizableMessage)new Message("AAA_CAP_INVALID_USER_SESSION"), (LocalizableMessage)new Message("AAA_AUT_INVALID_USER_SESSION_ID"));
                    }
                    case 0: 
                    case 1: {
                        session.extendTimeout(userSessionTimeout);
                        break;
                    }
                }
            }
        }
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userSessionID", (Object)session.getUserSessionId());
    }
}

