/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.ReplicatedPassportCache;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.websphere.objectgrid.ClientClusterContext;
import com.ibm.websphere.objectgrid.ObjectGrid;
import com.ibm.websphere.objectgrid.ObjectGridException;
import com.ibm.websphere.objectgrid.ObjectGridManager;
import com.ibm.websphere.objectgrid.ObjectGridManagerFactory;
import com.ibm.websphere.objectgrid.ObjectMap;
import com.ibm.websphere.objectgrid.Session;
import com.ibm.websphere.objectgrid.security.config.ClientSecurityConfiguration;
import java.util.Iterator;

public class WXSWrapper
implements ReplicatedPassportCache {
    private static final String CATALOG_SERVER_ADDRESSES = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"catalogServerBootstrap\"]/*[local-name()='value']/text()";
    private static final String INITIALIZE_METHODNAME = "initialize";
    private static final String TRACE_CAM_AAA_SRVC_WXS = "Trace.CAM.AAA.SRVC.WXS";
    private ObjectMap objectMap;
    private Session session;
    private TraceLogger traceLogger;
    private LogContext logContext;

    WXSWrapper(ObjectGridManager ogMgr, String catalogServerBootstrap, TraceLogger theTraceLogger) throws SoapFaultException {
        this.initialize(ogMgr, catalogServerBootstrap, theTraceLogger);
    }

    WXSWrapper() throws SoapFaultException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Passport get(String passportID) {
        Passport thePassport = null;
        if (passportID != null) {
            try {
                this.session.begin();
                thePassport = (Passport)this.objectMap.get((Object)passportID);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                try {
                    if (this.session.isTransactionActive()) {
                        this.session.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return thePassport;
    }

    private void initialize(ObjectGridManager ogMgr, String catalogServerBootstrap, TraceLogger theTraceLogger) throws SoapFaultException {
        if (theTraceLogger == null) {
            LogTypedLogger ipfLogger = LogTypedLogger.getInstance((String)TRACE_CAM_AAA_SRVC_WXS, LogTraceIndication.class);
            this.traceLogger = new TraceLoggerImpl(ipfLogger);
        } else {
            this.traceLogger = theTraceLogger;
        }
        this.logContext = new LogContextImpl(null, null, 1, null);
        try {
            ClientClusterContext ccc = ogMgr.connect(catalogServerBootstrap, (ClientSecurityConfiguration)null, null);
            ObjectGrid og = ogMgr.getObjectGrid(ccc, "CAM_Grid");
            this.session = og.getSession();
            this.objectMap = this.session.getMap("PassportMap");
        }
        catch (ObjectGridException e) {
            throw new FunctionCallFailedException(WXSWrapper.class.toString(), INITIALIZE_METHODNAME, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String passportID, Passport thePassport) {
        if (passportID != null) {
            try {
                this.session.begin();
                this.objectMap.put((Object)passportID, (Object)thePassport);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                try {
                    if (this.session.isTransactionActive()) {
                        this.session.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Passport remove(String passportID) {
        Passport thePassport = null;
        if (passportID != null) {
            try {
                this.session.begin();
                thePassport = (Passport)this.objectMap.remove((Object)passportID);
                this.session.commit();
            }
            catch (Exception e) {
                LogData theLogData = this.traceLogger.getLogData();
                theLogData.setException(e);
                this.traceLogger.resultReceive(this.logContext, ComponentImpl.getInstance(), Logger.LEVEL4, theLogData);
            }
            finally {
                try {
                    if (this.session.isTransactionActive()) {
                        this.session.rollback();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return thePassport;
    }

    @Override
    public void initialize(Configuration theConfiguration) throws SoapFaultException {
        String catalogServerBootstrap = theConfiguration.getOptionalValue(CATALOG_SERVER_ADDRESSES, null);
        ObjectGridManager ogMgr = ObjectGridManagerFactory.getObjectGridManager();
        this.initialize(ogMgr, catalogServerBootstrap, null);
    }

    @Override
    public Iterator<Object> getPassportIDs() {
        return ReplicatedPassportCache.EMPTY_ITERATOR;
    }
}

