/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.exception;

import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.ReadOnlyDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.TextDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.TextNoEchoDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class InvalidCredentialsException
extends UserRecoverableException {
    private static final LocalizableMessage CAPTION = new Message("AAA_CAP_COULD_NOT_AUTHENTICATE_USER");
    private static final LocalizableMessage MESSAGE = new Message("AAA_AUT_CREDENTIALS_INVALID");
    private static final LocalizableMessage NAMESPACE_CAPTION = new Message("AAA_CAP_NAMESPACE");
    private static final LocalizableMessage USERNAME_CAPTION = new Message("AAA_CAP_USERNAME");
    private static final LocalizableMessage PASSWORD_CAPTION = new Message("AAA_CAP_PASSWORD");
    private static final long serialVersionUID = 4327912372736342981L;

    public InvalidCredentialsException(String theFaultActor) {
        super(theFaultActor, CAPTION, MESSAGE);
        this.addDisplayObject((DisplayObject)new TextDisplayObject(USERNAME_CAPTION, "CAMUsername"));
        this.addDisplayObject((DisplayObject)new TextNoEchoDisplayObject(PASSWORD_CAPTION, "CAMPassword"));
    }

    public InvalidCredentialsException(String theFaultActor, Exception theCause) {
        super(theFaultActor, CAPTION, MESSAGE, theCause);
        this.addDisplayObject((DisplayObject)new TextDisplayObject(USERNAME_CAPTION, "CAMUsername"));
        this.addDisplayObject((DisplayObject)new TextNoEchoDisplayObject(PASSWORD_CAPTION, "CAMPassword"));
    }

    public InvalidCredentialsException(String theFaultActor, String nsDisplayName, String namespaceID, String action) {
        super(theFaultActor, CAPTION, MESSAGE);
        this.addDisplayObject((DisplayObject)new HiddenDisplayObject("CAMNamespace", namespaceID));
        this.addDisplayObject((DisplayObject)new ReadOnlyDisplayObject(NAMESPACE_CAPTION, "CAMNamespaceDisplayName", nsDisplayName));
        this.addDisplayObject((DisplayObject)new TextDisplayObject(USERNAME_CAPTION, "CAMUsername"));
        this.addDisplayObject((DisplayObject)new TextNoEchoDisplayObject(PASSWORD_CAPTION, "CAMPassword"));
        if (action != null) {
            this.addDisplayObject((DisplayObject)new HiddenDisplayObject("h_CAM_action", action));
        }
    }
}

