/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.exception;

import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.MultiSelectDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SelectOption;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public final class RoleSelectionExceptionFactory {
    private static final String CLASS_NAME = RoleSelectionExceptionFactory.class.getName();

    private RoleSelectionExceptionFactory() {
    }

    private static String buildQueryForRoleNames(Set<String> theAvailableRoles) {
        StringBuffer xmlRequest = new StringBuffer();
        xmlRequest.append("<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        xmlRequest.append(" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"");
        xmlRequest.append(" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"");
        xmlRequest.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        xmlRequest.append(" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">");
        xmlRequest.append("<bus:query>");
        xmlRequest.append("<search xsi:type=\"xsd:string\">");
        Iterator<String> it = theAvailableRoles.iterator();
        while (true) {
            String searchPath = it.next();
            xmlRequest.append(searchPath);
            if (!it.hasNext()) break;
            xmlRequest.append("|");
        }
        xmlRequest.append("</search>");
        xmlRequest.append("<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:propEnum[]\"><item xsi:type=\"bus:propEnum\">searchPath</item><item xsi:type=\"bus:propEnum\">defaultName</item></properties>");
        xmlRequest.append("</bus:query>");
        xmlRequest.append("</SOAP-ENV:Body>");
        return xmlRequest.toString();
    }

    public static UserRecoverableException createRoleSelectionException(Set<String> theAvailableRoles, Set<String> theCurrentIdentity, SoapEnvelopeRequest theRequestEnvelope) throws SoapFaultException {
        if (theAvailableRoles.isEmpty()) {
            throw new UnrecoverableException(CLASS_NAME, (LocalizableMessage)new Message("AAA_CAP_NO_AVAILABLE_ROLES"), (LocalizableMessage)new Message("AAA_AUT_NO_ROLE_AVAILABLE"));
        }
        UserRecoverableException ur = new UserRecoverableException(CLASS_NAME, (LocalizableMessage)new Message("AAA_CAP_SELECT_ONE_OR_MORE_ROLES"), (LocalizableMessage)new Message("AAA_AUT_ROLE_SELECTION_REQUIRED"));
        MultiSelectDisplayObject selectRoles = new MultiSelectDisplayObject((LocalizableMessage)new Message("AAA_CAP_ROLES"), "CAM_Role");
        Element queryResponse = RoleSelectionExceptionFactory.queryForRoleNames(theAvailableRoles, theRequestEnvelope);
        List items = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectNodes((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/*[local-name()='queryResult']/*", (Node)queryResponse);
        for (int i = 0; i < items.size(); ++i) {
            Node currentItem = (Node)items.get(i);
            String searchPath = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((String)"./*[local-name()='searchPath']/*[local-name()='value']", (Node)currentItem);
            String defaultName = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((String)"./*[local-name()='defaultName']/*[local-name()='value']", (Node)currentItem);
            selectRoles.addOption(new SelectOption(defaultName, searchPath, theCurrentIdentity.contains(searchPath)));
        }
        ur.addDisplayObject((DisplayObject)selectRoles);
        return ur;
    }

    private static Element queryForRoleNames(Set<String> theAvailableRoles, SoapEnvelopeRequest theRequestEnvelope) throws SoapFaultException {
        SoapEnvelope newRequest = theRequestEnvelope.createNewRequest(RoleSelectionExceptionFactory.buildQueryForRoleNames(theAvailableRoles));
        try {
            String response = CMAccessor.getInstance().invoke(newRequest.toXML());
            return DocumentHelper.parseText((String)response).getRootElement();
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(CLASS_NAME, (Exception)((Object)e));
        }
        catch (DocumentException e) {
            throw new InternalErrorException(CLASS_NAME, (Exception)((Object)e));
        }
    }
}

