/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.InternalCAMCookieImpl;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.exception.RoleSelectionExceptionFactory;
import com.ibm.cognos.camaaa.internal.auth.soap.SelectRolesRequest;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import java.util.HashSet;
import java.util.Set;

public class ApplyRoleSelection
extends DefaultHandler {
    public static final String CAM_ROLE_FORM_FIELD = "CAM_Role";
    private static final String NEW_COOKIE_ADVANCED_PROPERTY_XPATH = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"newCookie\"]/*[local-name()='value']/text()";
    private DyeTraceManagerMBean dyeTraceManager;
    private boolean isNewCamCookieFormatEnabled;

    private void createCamCookie(Passport thePassport, MessageContext theContext) {
        InternalCAMCookieImpl cookie = new InternalCAMCookieImpl(thePassport, this.isNewCamCookieFormatEnabled, this.dyeTraceManager.getDyeTracedUsers());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie", (Object)cookie.getValue());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.trackingSessionContextId", (Object)cookie.getSessionContext());
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        SoapEnvelopeRequest envelope = (SoapEnvelopeRequest)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapBodyEntry bodyEntry = envelope.getBody().getBodyEntry();
        Set<String> roleSelection = null;
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        boolean promptForRoles = false;
        switch (bodyEntry.getType()) {
            case 7: {
                String[] selection = ((SelectRolesRequest)bodyEntry).getRoleSelection();
                if (selection != null) {
                    roleSelection = new HashSet<String>(selection.length);
                    for (int i = 0; i < selection.length; ++i) {
                        roleSelection.add(selection[i]);
                    }
                    break;
                }
                promptForRoles = true;
                break;
            }
            default: {
                Set logonRoles = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles");
                Set<String> assumedRoles = passport.getRoles();
                assumedRoles.retainAll(passport.getIdentity());
                roleSelection = assumedRoles;
                if (logonRoles == null || logonRoles.size() <= 0) break;
                roleSelection.addAll(logonRoles);
            }
        }
        if (promptForRoles) {
            throw RoleSelectionExceptionFactory.createRoleSelectionException(passport.getRoles(), passport.getIdentity(), envelope);
        }
        passport.selectRoles(roleSelection);
        this.createCamCookie(passport, theContext);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String value = config.getOptionalValue(NEW_COOKIE_ADVANCED_PROPERTY_XPATH, Boolean.TRUE.toString());
        this.isNewCamCookieFormatEnabled = Boolean.valueOf(value);
        this.dyeTraceManager = (DyeTraceManagerMBean)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean");
    }
}

