/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.admin.handler.AdminHandler;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.HandlerChainConfigException;
import com.ibm.cognos.camaaa.internal.common.exception.InvalidCfgAttributeValueException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.UnexpectedElementException;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerFactory;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerWrapper;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class AuthHandler
extends HandlerWrapper {
    public static final int UNKNOWN_HANDLER_TYPE = 0;
    public static final int OPTIONAL_HANDLER_TYPE = 1;
    public static final int REQUIRED_HANDLER_TYPE = 2;
    public static final int REQUISITE_HANDLER_TYPE = 3;
    public static final int SUFFICIENT_HANDLER_TYPE = 4;
    private static final String OPTIONAL = "optional";
    private static final String REQUIRED = "required";
    private static final String REQUISITE = "requisite";
    private static final String SUFFICIENT = "sufficient";
    private static final QName HANDLER = QName.get((String)"handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName AUTH_HANDLER = QName.get((String)"auth-handler", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName AUTH_HANDLER_REF = QName.get((String)"auth-handler-ref", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");
    private static final QName CONTROL_FLAG_ATTR = QName.get((String)"type");
    private int type = 0;

    @Override
    public void destroy() {
        super.destroy();
        this.type = 0;
    }

    int getHandlerType() {
        return this.type;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.type = 0;
        String handlerConfiguration = (String)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration");
        Element root = (Element)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfigurationElement");
        SAXReader xmlReader = new SAXReader();
        if (root == null) {
            try {
                Document doc = xmlReader.read((Reader)new StringReader(handlerConfiguration));
                root = doc.getRootElement();
            }
            catch (DocumentException e) {
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
            }
        }
        if (root != null && root.getNodeType() == 1) {
            this.populateHandler(root, theConfig);
            String authFlag = root.attributeValue(CONTROL_FLAG_ATTR);
            if (authFlag == null) {
                InvalidCfgAttributeValueException e = new InvalidCfgAttributeValueException(AuthHandler.class.toString(), authFlag, CONTROL_FLAG_ATTR.getQualifiedName());
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
            }
            if (authFlag.equals(OPTIONAL)) {
                this.type = 1;
            } else if (authFlag.equals(REQUIRED)) {
                this.type = 2;
            } else if (authFlag.equals(REQUISITE)) {
                this.type = 3;
            } else if (authFlag.equals(SUFFICIENT)) {
                this.type = 4;
            }
            if (this.type == 0) {
                InvalidCfgAttributeValueException e = new InvalidCfgAttributeValueException(AuthHandler.class.toString(), authFlag, CONTROL_FLAG_ATTR.getQualifiedName());
                throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
            }
        }
    }

    private void populateHandler(Element theElement, HandlerInfo theConfig) throws LocalizableException {
        HandlerFactory handlerFactory = (HandlerFactory)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerFactory");
        String handlerConfiguration = (String)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.handlerConfiguration");
        QName handlerType = theElement.getQName();
        this.setName(theElement);
        if (handlerType.equals((Object)AUTH_HANDLER)) {
            Element e = theElement.createCopy(HANDLER);
            Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
            this.setHandler(handlerFactory.createHandler(config, e));
        } else if (handlerType.equals((Object)AUTH_HANDLER_REF)) {
            String refName = theElement.attributeValue("name");
            if (refName == null) {
                throw new InvalidCfgAttributeValueException(AdminHandler.class.getName(), refName, "name");
            }
            this.setHandler(handlerFactory.getHandlerByName(refName));
        } else {
            UnexpectedElementException e = new UnexpectedElementException(handlerType.getQualifiedName(), AUTH_HANDLER.getQualifiedName() + "|" + AUTH_HANDLER_REF.getQualifiedName());
            throw new HandlerChainConfigException(handlerConfiguration, (Exception)((Object)e));
        }
    }
}

