/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.handler.AuthHandler;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerChain;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import java.util.ListIterator;
import org.dom4j.QName;

public class AuthHandlerChain
extends HandlerChain {
    private static final QName AUTH_HANDLER_CHAIN = QName.get((String)"auth-handler-chain", (String)"http://developer.cognos.com/schemas/CAM/AAA/2/");

    @Override
    protected QName getElementQName() {
        return AUTH_HANDLER_CHAIN;
    }

    private int getHandlerType(Handler theHandler) {
        int retval = 3;
        if (theHandler instanceof AuthHandler) {
            retval = ((AuthHandler)theHandler).getHandlerType();
        }
        return retval;
    }

    @Override
    protected boolean invokeHandlersForward(ListIterator it, MessageContext theContext) throws SoapFaultException {
        int nbHandlerSucceeded = 0;
        int nbRequiredHandlerFailure = 0;
        boolean retval = true;
        while (it.hasNext()) {
            Handler handler = (Handler)it.next();
            int handlerType = this.getHandlerType(handler);
            boolean continueProcessing = handler.handleMessage(theContext);
            if (continueProcessing) {
                ++nbHandlerSucceeded;
                if (handlerType != 4) continue;
                break;
            }
            if (handlerType == 2) {
                ++nbRequiredHandlerFailure;
                continue;
            }
            if (handlerType != 3) continue;
            retval = false;
            break;
        }
        if (retval) {
            retval = nbRequiredHandlerFailure == 0 && nbHandlerSucceeded > 0;
        }
        return retval;
    }
}

