/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.EnvironmentSecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlob;
import com.ibm.cognos.camaaa.internal.auth.SecurityBlobManager;
import com.ibm.cognos.camaaa.internal.auth.TrustedToken;
import com.ibm.cognos.camaaa.internal.auth.TrustedTokenManager;
import com.ibm.cognos.camaaa.internal.auth.exception.DisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.HiddenDisplayObject;
import com.ibm.cognos.camaaa.internal.auth.exception.SystemRecoverableException;
import com.ibm.cognos.camaaa.internal.auth.exception.UserRecoverableException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.common.soap.SoapFault;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeResponseImpl;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class AuthenticateToNamespaceIfRequired
extends DefaultHandler {
    private static final String LOGON_REQUEST = "<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding\"> <bus:logon><logonOptions xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:logonOptionEnum[]\"><item xsi:type=\"bus:logonOptionEnum\">IgnoreAnonymous</item></logonOptions></bus:logon></SOAP-ENV:Body>";
    private static final String CAM_PASSPORT = "cam_passport";
    private static final String CAM_NAMESPACE = "CAMNamespace";
    private static final String CAM_ENV_NAME = "REMOTE_USER";
    private static final String CAM_ACTION = "h_CAM_action";

    private SoapFaultException addHiddenDisplayObjet(String targetNS, SystemRecoverableException bodyException) {
        HiddenDisplayObject newObject = new HiddenDisplayObject(CAM_NAMESPACE, targetNS);
        bodyException.addDisplayObject(newObject);
        return bodyException;
    }

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String targetNS = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        String passportID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passportID");
        if (passport.get(targetNS) == null) {
            if (this.isAnonymousPassport(passportID)) {
                this.throwExceptionNotAutoSwitchFromAnonymousToNamedUser(theContext, targetNS);
            } else {
                this.logonToNamespace(theContext, targetNS);
            }
        }
        return true;
    }

    private boolean hasFullHeader(MessageContext theContext) {
        String cookieValue;
        SoapEnvelope envelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        BiBusHeader bibusHeader = envelope.getHeader().getBiBusHeader();
        try {
            cookieValue = bibusHeader.getCookieValue(CAM_PASSPORT);
        }
        catch (LocalizableException e) {
            e.printStackTrace();
            cookieValue = null;
        }
        return cookieValue != null && cookieValue.length() != 0;
    }

    private boolean isAnonymousPassport(String passportID) {
        return PassportManager.getInstance().isAnonymousPassportID(passportID);
    }

    private void logonToNamespace(MessageContext theContext, String targetNS) throws SoapFaultException {
        MessageContext newMC = theContext.createMessageContextForNewRequest(LOGON_REQUEST);
        newMC.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse"));
        HandlerBinding handlerBinding = (HandlerBinding)newMC.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler(2);
        handlerBinding.handleRequest(newMC, handler);
        SoapEnvelopeResponse soapEnvelope = (SoapEnvelopeResponse)newMC.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        SoapFault bodyEntry = null;
        if (soapEnvelope instanceof LegacySoapEnvelopeResponseImpl) {
            bodyEntry = ((LegacySoapEnvelopeResponseImpl)soapEnvelope).getFaultEntry();
        } else if (soapEnvelope instanceof SoapEnvelopeResponse) {
            bodyEntry = soapEnvelope.getBody().getBodyEntry();
        }
        if (bodyEntry != null && bodyEntry.getType() == 19) {
            this.modifyException(theContext, targetNS, (SoapEnvelope)soapEnvelope, (SoapBodyEntry)bodyEntry);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse", (Object)soapEnvelope);
            throw new InternalErrorException(AuthenticateToNamespaceIfRequired.class.getName());
        }
    }

    private void modifyException(MessageContext theContext, String targetNS, SoapEnvelope soapEnvelope, SoapBodyEntry bodyEntry) {
        if (bodyEntry instanceof SystemRecoverableException) {
            SystemRecoverableException systemException = (SystemRecoverableException)bodyEntry;
            SoapFaultException bodyException = this.addHiddenDisplayObjet(targetNS, systemException);
            if (soapEnvelope instanceof SoapEnvelopeResponse) {
                SoapEnvelopeResponse soapEnv = (SoapEnvelopeResponse)soapEnvelope;
                soapEnv.setFaultEntry((SoapFault)bodyException, theContext);
            }
        }
    }

    private void setFalutEntry(MessageContext theContext, SoapFaultException authException) {
        SoapEnvelope soapEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        if (soapEnvelope instanceof SoapEnvelopeResponse) {
            SoapEnvelopeResponse soapEnv = (SoapEnvelopeResponse)soapEnvelope;
            soapEnv.setFaultEntry((SoapFault)authException, theContext);
        }
    }

    private void throwExceptionNotAutoSwitchFromAnonymousToNamedUser(MessageContext theContext, String targetNS) throws InternalErrorException {
        if (!this.hasFullHeader(theContext)) {
            this.throwUserRecoverableException(theContext, targetNS);
        } else {
            this.throwSystemRecoverableException(theContext, targetNS);
        }
    }

    private void throwSystemRecoverableException(MessageContext theContext, String nsID) throws InternalErrorException {
        String[] requestVars = new String[]{CAM_ENV_NAME};
        TrustedToken trustedToken = TrustedTokenManager.getInstance().createTrustedToken();
        SecurityBlob securityBlob = SecurityBlobManager.createSecurityBlob(requestVars, trustedToken.getID());
        if (securityBlob.getBlobType() == 1) {
            EnvironmentSecurityBlob envBlob = (EnvironmentSecurityBlob)securityBlob;
            SystemRecoverableException systemEx = new SystemRecoverableException(AuthenticateToNamespaceIfRequired.class.getName(), (LocalizableMessage)new Message("AAA_AUT_AUTHENTICATION_REQUIRED"), envBlob.getEnvironmentRawData().getBytes());
            SoapFaultException soapFaultEx = this.addHiddenDisplayObjet(nsID, systemEx);
            this.setFalutEntry(theContext, soapFaultEx);
            throw new InternalErrorException(AuthenticateToNamespaceIfRequired.class.getName());
        }
    }

    private void throwUserRecoverableException(MessageContext theContext, String nsID) throws InternalErrorException {
        UserRecoverableException userRecoverableEx = new UserRecoverableException(AuthenticateToNamespaceIfRequired.class.getName(), (LocalizableMessage)new Message("AAA_AUT_AUTHENTICATION_REQUIRED"), (LocalizableMessage)new Message("AAA_AUT_REQUEST_INCOMPLETE"));
        HiddenDisplayObject camAction = new HiddenDisplayObject(CAM_ACTION, "logonAs");
        HiddenDisplayObject camNS = new HiddenDisplayObject(CAM_NAMESPACE, nsID);
        userRecoverableEx.addDisplayObject((DisplayObject)camNS);
        userRecoverableEx.addDisplayObject((DisplayObject)camAction);
        this.setFalutEntry(theContext, (SoapFaultException)userRecoverableEx);
        throw new InternalErrorException(AuthenticateToNamespaceIfRequired.class.getName());
    }
}

