/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationListener;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.Component;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLogger;
import com.ibm.cognos.camaaa.internal.common.logging.TraceLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.util.HashSet;
import java.util.Set;

public class CheckApplicationAccessRestriction
extends DefaultHandler
implements ConfigurationListener {
    static final String RESTRICT_ACCESS_TO_CRN = "./*[local-name()='parameter'][@name=\"restrictAccessToCRN\"]/*[local-name()='value']/text()";
    private static final String CHECK_APPLICATION_ACCESS_RESTRICTION_CONFIGURATION_CHANGED = "CheckApplicationAccessRestriction.configurationChanged";
    private static final String ALL_AUTHENTICATED_USERS = "CAMID(\"::All Authenticated Users\")";
    private static final String EVERYONE = "CAMID(\"::Everyone\")";
    private static final String DISPATCH_TO_NAMESPACE = "dispatchToNamespace";
    private boolean accessRestrictionEnabled;
    private TraceLogger traceLogger;

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        if (this.accessRestrictionEnabled && this.isDeniedAccess(theContext)) {
            this.logoffFromProvider(theContext);
            throw new UnrecoverableException(CheckApplicationAccessRestriction.class.getName(), (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"), (LocalizableMessage)new Message("AAA_CAP_USER_ACCESS_RESTRICTED"));
        }
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        LogTypedLogger theTraceLogger = LogTypedLogger.getInstance((String)"Trace.CAM.AAA.SRVC", LogTraceIndication.class);
        this.traceLogger = new TraceLoggerImpl(theTraceLogger);
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        if (config instanceof ConfigurationManager) {
            ((ConfigurationManager)config).addListener(this);
        }
        this.internalConfigurationChanged(config);
    }

    private boolean isDeniedAccess(MessageContext theContext) {
        HashSet cognosIdentity = (HashSet)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.cognosIdentity");
        HashSet cognosRoles = (HashSet)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles");
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        boolean userDeniedAccess = false;
        if (!this.checkIfUserAlreadyAdmin(passport) && cognosIdentity.size() == 2 && cognosIdentity.contains(ALL_AUTHENTICATED_USERS) && cognosIdentity.contains(EVERYONE) && cognosRoles.size() == 0) {
            userDeniedAccess = true;
        }
        return userDeniedAccess;
    }

    private boolean checkIfUserAlreadyAdmin(Passport thePassport) {
        Set<String> globalIdentity;
        return thePassport != null && (globalIdentity = thePassport.getIdentity()) != null && (globalIdentity.contains("CAMID(\"::System Administrators\")") || globalIdentity.contains("CAMID(\"::Tenant Administrators\")"));
    }

    @Override
    public void configurationChanged(Configuration theNewConfiguration) {
        LogContextImpl theLogContext = new LogContextImpl("System", "", 1, "");
        Component theComponent = ComponentImpl.getInstance();
        this.traceLogger.enter((LogContext)theLogContext, theComponent, Logger.LEVEL4, CHECK_APPLICATION_ACCESS_RESTRICTION_CONFIGURATION_CHANGED);
        boolean existingRestrictionsEnabled = this.accessRestrictionEnabled;
        this.internalConfigurationChanged(theNewConfiguration);
        LogData logData = this.traceLogger.getLogData();
        logData.addParameter("Old restrictions enabled", Boolean.toString(existingRestrictionsEnabled));
        logData.addParameter("New restrictions enabled", Boolean.toString(this.accessRestrictionEnabled));
        this.traceLogger.trace((LogContext)theLogContext, theComponent, Logger.LEVEL4, "CheckApplicationAccessRestriction.values", logData);
        if (!existingRestrictionsEnabled && this.accessRestrictionEnabled) {
            PassportManager.getInstance().terminateSessions(passport -> !this.doesUserBelongToMoreThanAAUAndEveryone(passport.getCognosIdentity()));
        }
        this.traceLogger.exit((LogContext)theLogContext, theComponent, Logger.LEVEL4, CHECK_APPLICATION_ACCESS_RESTRICTION_CONFIGURATION_CHANGED);
    }

    private boolean doesUserBelongToMoreThanAAUAndEveryone(Set<String> identity) {
        return identity.size() != 2 || !identity.contains(ALL_AUTHENTICATED_USERS) || !identity.contains(EVERYONE);
    }

    @Override
    public String[] getParameterPath() {
        return new String[]{RESTRICT_ACCESS_TO_CRN};
    }

    private void internalConfigurationChanged(Configuration theConfig) {
        String value = theConfig.getOptionalValue(RESTRICT_ACCESS_TO_CRN, Boolean.FALSE.toString());
        this.accessRestrictionEnabled = Boolean.valueOf(value);
    }

    private void logoffFromProvider(MessageContext theContext) throws SoapFaultException {
        StringBuffer logoffRequest = new StringBuffer();
        logoffRequest.append("<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        logoffRequest.append(" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><bus:logoff/></SOAP-ENV:Body>");
        MessageContext newContext = theContext.createMessageContextForNewRequest(logoffRequest.toString());
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa"));
        HandlerBinding handlerBinding = (HandlerBinding)newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler(DISPATCH_TO_NAMESPACE);
        handlerBinding.handleRequest(newContext, handler);
    }
}

