/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.InternalCAMCookieImpl;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.exception.UnrecoverableException;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;

public class ClonePassport
extends DefaultHandler {
    private static final String NEW_COOKIE_ADVANCED_PROPERTY_XPATH = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"newCookie\"]/*[local-name()='value']/text()";
    private static final String RESTORE_PASSPORT = "com.ibm.cognos.camaaa.internal.auth.handler.ClonePassport.restorePassportKey";
    private static final String ORIGINAL_PASSPORT = "com.ibm.cognos.camaaa.internal.auth.handler.ClonePassport.originalPassportKey";
    private DyeTraceManagerMBean dyeTraceManager;
    private boolean isNewCamCookieFormatEnabled;

    @Override
    public void close(MessageContext theContext) {
        Boolean restorePassport = (Boolean)theContext.getLocal(RESTORE_PASSPORT);
        if (restorePassport.booleanValue()) {
            Passport originalPassport;
            Passport currentPassport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            if (currentPassport != (originalPassport = (Passport)theContext.getLocal(ORIGINAL_PASSPORT))) {
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)originalPassport);
                this.createCamCookie(originalPassport, theContext);
                PassportManager.getInstance().destroyPassport(currentPassport.getID());
            }
        } else {
            Passport originalPassport = (Passport)theContext.getLocal(ORIGINAL_PASSPORT);
            if (originalPassport != null) {
                originalPassport.unlock();
            }
        }
        theContext.putLocal(RESTORE_PASSPORT, (Object)Boolean.FALSE);
        theContext.removeLocal(ORIGINAL_PASSPORT);
    }

    private void createCamCookie(Passport thePassport, MessageContext theContext) {
        InternalCAMCookieImpl cookie = new InternalCAMCookieImpl(thePassport, this.isNewCamCookieFormatEnabled, this.dyeTraceManager.getDyeTracedUsers());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie", (Object)cookie.getValue());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.trackingSessionContextId", (Object)cookie.getSessionContext());
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        requestContext.getLogContext().setSessionContext(cookie.getSessionContext());
    }

    @Override
    public boolean handleFault(MessageContext theContext) throws SoapFaultException {
        theContext.putLocal(RESTORE_PASSPORT, (Object)Boolean.TRUE);
        return true;
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            theContext.putLocal(RESTORE_PASSPORT, (Object)Boolean.TRUE);
            return true;
        }
        theContext.putLocal(RESTORE_PASSPORT, (Object)Boolean.FALSE);
        Passport originalPassport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        theContext.putLocal(ORIGINAL_PASSPORT, (Object)originalPassport);
        Passport clonedPassport = null;
        clonedPassport = PassportManager.getInstance().isAnonymousPassportID(originalPassport.getID()) ? PassportManager.getInstance().createAnonymousSession() : PassportManager.getInstance().createNamedUserSession();
        try {
            clonedPassport.cloneFrom(originalPassport);
            clonedPassport.lock();
        }
        catch (Exception e) {
            PassportManager.getInstance().destroyPassport(clonedPassport.getID());
            throw new UnrecoverableException(ClonePassport.class.getName(), (LocalizableMessage)new Message("AAA_AUT_CLONE_PASSPORT_FAILED"), (LocalizableMessage)new Message("AAA_AUT_CLONE_PASSPORT_FAILED"), e);
        }
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)clonedPassport);
        this.createCamCookie(clonedPassport, theContext);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String value = config.getOptionalValue(NEW_COOKIE_ADVANCED_PROPERTY_XPATH, Boolean.TRUE.toString());
        this.isNewCamCookieFormatEnabled = Boolean.valueOf(value);
        this.dyeTraceManager = (DyeTraceManagerMBean)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean");
    }
}

