/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.admin.soap.Account;
import com.ibm.cognos.camaaa.internal.admin.soap.BaseClass;
import com.ibm.cognos.camaaa.internal.admin.soap.Namespace;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResponse;
import com.ibm.cognos.camaaa.internal.admin.soap.QueryResult;
import com.ibm.cognos.camaaa.internal.admin.soap.SearchPath;
import com.ibm.cognos.camaaa.internal.auth.InternalCAMCookieImpl;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.PassportManager;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.NamespaceManager;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.RequestContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import com.ibm.cognos.camaaa.internal.legacy.soap.LegacySoapEnvelopeResponseImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CreateApplicationLogonSession
extends DefaultHandler {
    public static final String ANONYMOUS_USER_CAMID = "CAMID(\"::Anonymous\")";
    public static final String CAM_PASSPORT = "cam_passport";
    private static final String REMOTE_USER = "REMOTE_USER";
    private static final String LOGOFF_REQUEST_BODY = "<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\"><bus:logoff/></SOAP-ENV:Body>";
    private static final String NEW_COOKIE_ADVANCED_PROPERTY_XPATH = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"newCookie\"]/*[local-name()='value']/text()";
    private static final String CAM_NAMESPACE = "CAMNamespace";
    private NamespaceManager namespaceManager;
    private DyeTraceManagerMBean dyeTraceManager;
    private boolean isNewCamCookieFormatEnabled;

    @Override
    public void close(MessageContext theContext) {
    }

    private void createCamCookie(Passport thePassport, MessageContext theContext) {
        InternalCAMCookieImpl cookie = new InternalCAMCookieImpl(thePassport, this.isNewCamCookieFormatEnabled, this.dyeTraceManager.getDyeTracedUsers());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.camPassportCookie", (Object)cookie.getValue());
        theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.trackingSessionContextId", (Object)cookie.getSessionContext());
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        requestContext.getLogContext().setSessionContext(cookie.getSessionContext());
    }

    private InternalVisa createInternalVisa(MessageContext theContext) {
        QueryResult result = (QueryResult)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.userInfoQueryResult");
        Account account = (Account)result.getAll()[0];
        SearchPath searchPath = account.getSearchPath();
        RequestContext requestContext = (RequestContext)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.requestContext");
        String camid = searchPath.getValue();
        String displayName = account.getDefaultName(requestContext);
        String username = account.getUserName();
        Visa namespaceVisa = (Visa)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa");
        InternalVisa internalVisa = new InternalVisa(camid, displayName, username);
        internalVisa.setVisa(namespaceVisa);
        return internalVisa;
    }

    HashSet<String> getAvailableNamespaces(Passport thePassport, MessageContext theContext) {
        HashSet<String> availableNamespaceIds = this.getNamespaceIds(this.namespaceManager.getAuthenticationNamespaces());
        if (availableNamespaceIds.size() > 0) {
            SoapEnvelope soapRequest = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
            String[] allowedNSs = soapRequest.getHeader().getBiBusHeader().getEnvVarValues(CAM_NAMESPACE);
            if (allowedNSs != null) {
                availableNamespaceIds.retainAll(Arrays.asList(allowedNSs));
            }
            if (availableNamespaceIds.size() > 0) {
                Set<String> authenticatedNSIds = thePassport.getAuthenticatedNamespaceIDs();
                availableNamespaceIds.removeAll(authenticatedNSIds);
            }
            if (availableNamespaceIds.size() > 0) {
                HashSet<String> selectableNSIds = this.getNamespaceIds(this.namespaceManager.getSelectableAuthenticationNamespaces());
                availableNamespaceIds.retainAll(selectableNSIds);
            }
        }
        return availableNamespaceIds;
    }

    private HashSet<String> getNamespaceIds(Namespace[] namespaces) {
        HashSet<String> namespaceIds = new HashSet<String>();
        if (namespaces != null) {
            for (int i = 0; i < namespaces.length; ++i) {
                namespaceIds.add(namespaces[i].getSearchPath().getNamespaceID());
            }
        }
        return namespaceIds;
    }

    private Passport getPassport(MessageContext theContext, Set<String> logonIds) throws SoapFaultException {
        PassportManager passportMgr = PassportManager.getInstance();
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        try {
            if (passport == null) {
                if (logonIds.contains(ANONYMOUS_USER_CAMID)) {
                    passport = PassportManager.getInstance().createAnonymousSession();
                } else {
                    passport = PassportManager.getInstance().createNamedUserSession();
                    this.tieRemoteUserToPassport(theContext, passport);
                }
                this.setTenantID(theContext, passport);
                passport.lock();
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)passport);
            } else if (passportMgr.isAnonymousPassportID(passport.getID())) {
                this.invokeLogoffAction(theContext);
                SoapEnvelopeResponse envResp = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
                if (envResp instanceof LegacySoapEnvelopeResponseImpl) {
                    QueryResponse queryRespnse = (QueryResponse)envResp.getBody().getBodyEntry();
                    QueryResult result = queryRespnse.getResult()[0];
                    BaseClass[] anonObjects = result.getAll();
                    for (int i = 0; i < anonObjects.length; ++i) {
                        result.remove(anonObjects[i]);
                    }
                }
                passport = PassportManager.getInstance().createNamedUserSession();
                this.setTenantID(theContext, passport);
                passport.lock();
                theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)passport);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("got interupted in handleMessage", e);
        }
        return passport;
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        HashSet<String> availableNamespaces;
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        Visa visa = (Visa)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa");
        if (visa == null) {
            throw new NullPointerException();
        }
        InternalVisa internalVisa = this.createInternalVisa(theContext);
        Set logonIds = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonIdentity");
        Passport passport = this.getPassport(theContext, logonIds);
        String targetNS = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
        passport.add(targetNS, internalVisa);
        passport.addIdentity(logonIds);
        Set logonRoles = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.logonRoles");
        if (logonRoles != null) {
            passport.addRoles(logonRoles);
        }
        passport.setCanUserCallLogon((availableNamespaces = this.getAvailableNamespaces(passport, theContext)).size() > 0);
        this.createCamCookie(passport, theContext);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String value = config.getOptionalValue(NEW_COOKIE_ADVANCED_PROPERTY_XPATH, Boolean.TRUE.toString());
        this.isNewCamCookieFormatEnabled = Boolean.valueOf(value);
        this.dyeTraceManager = (DyeTraceManagerMBean)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.logging.DyeTraceManagerMBean");
        this.namespaceManager = (NamespaceManager)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.NamespaceManager");
    }

    private void invokeLogoffAction(MessageContext messageContext) throws SoapFaultException {
        MessageContextImpl mcImpl = (MessageContextImpl)messageContext;
        MessageContext newMC = mcImpl.createMessageContextForNewRequest(LOGOFF_REQUEST_BODY);
        HandlerBinding handlerBinding = (HandlerBinding)newMC.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler("destroySession");
        handlerBinding.handleRequest(newMC, handler);
    }

    private void tieRemoteUserToPassport(MessageContext theContext, Passport passport) throws InternalErrorException {
        SoapEnvelope soapEnvelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        BiBusHeader biBusHeader = soapEnvelope.getHeader().getBiBusHeader();
        try {
            String value = biBusHeader.getEnvVarValue(REMOTE_USER);
            passport.setTiedRemoteUser(value);
        }
        catch (LocalizableException localizableException) {
            // empty catch block
        }
    }

    private void setTenantID(MessageContext theContext, Passport passport) throws SoapFaultException {
        String[] boundingSet;
        String writeTenantId;
        String tenantID = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.tenantID");
        if (tenantID != null) {
            passport.getTenancyInfo().setTenancy(TenancyInfo.TenancyType.TENANTID, tenantID);
        }
        if ((writeTenantId = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.writeTenantID")) != null) {
            passport.getTenancyInfo().setTenancy(TenancyInfo.TenancyType.WRITE_TENANTID, writeTenantId);
        }
        if ((boundingSet = (String[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.multitenacy.handler.boundingTenantIds")) != null) {
            passport.getTenancyInfo().setTenancies(TenancyInfo.TenancyType.READ_TENANTID, boundingSet);
        }
    }
}

