/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.common.MessageContextImpl;
import com.ibm.cognos.camaaa.internal.common.Visa;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.Handler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerBinding;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class DispatchToNamespaceUtility {
    public static final String LOGOFF_REQUEST = DispatchToNamespaceUtility.createRequestBody("<bus:logoff/>");
    private static String namespace = "namespace";
    private static String dispatchHandler = "dispatchToNamespace";

    private DispatchToNamespaceUtility() {
    }

    private static void addNames(Credential credential, Element credElement, String[] names) {
        if (names != null) {
            for (int j = 0; j < names.length; ++j) {
                if (names[j] == null || names[j].equals("")) continue;
                String[] values = credential.getCredentialValues(names[j]);
                DispatchToNamespaceUtility.addValues(credElement, names[j], values);
            }
        }
    }

    private static void addValues(Element credElement, String name, String[] values) {
        if (values != null) {
            for (int k = 0; k < values.length; ++k) {
                if (values[k] == null) continue;
                Element nameElement = DocumentHelper.createElement((String)name);
                nameElement.setText(values[k]);
                credElement.add(nameElement);
            }
        }
    }

    private static String createRequestBody(String method) {
        return "<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">" + method + "</SOAP-ENV:Body>";
    }

    private static void dispatchToNamespace(MessageContext newContext, String handlerName) throws SoapFaultException {
        HandlerBinding handlerBinding = (HandlerBinding)newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.handlerBinding");
        Handler handler = handlerBinding.getHandler(handlerName);
        handlerBinding.handleRequestRequired(newContext, handler);
    }

    public static CredentialImpl generateTC(Passport passport, String targetNamespaceId, boolean primary, MessageContext context) throws SoapFaultException {
        String generateTCRequest = DispatchToNamespaceUtility.createRequestBody("<bus:generateTC/>");
        MessageContext newContext = context.createMessageContextForNewRequest(generateTCRequest);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)targetNamespaceId);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport", (Object)passport);
        DispatchToNamespaceUtility.dispatchToNamespace(newContext, dispatchHandler);
        Credential[] credentials = (Credential[])newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials == null || credentials.length != 1 || credentials[0] == null) {
            return null;
        }
        Element credElement = DocumentHelper.createElement((String)"credential");
        if (primary) {
            Element primaryElement = DocumentHelper.createElement((String)"primary");
            primaryElement.setText("true");
            credElement.add(primaryElement);
        }
        String[] names = credentials[0].getCredentialNames();
        DispatchToNamespaceUtility.addNames(credentials[0], credElement, names);
        if (credElement.element(namespace) == null) {
            Element nsElement = DocumentHelper.createElement((String)namespace);
            nsElement.setText(targetNamespaceId);
            credElement.add(nsElement);
        } else {
            String credentialNamespace = credElement.valueOf(namespace);
            if (!credentialNamespace.equals(targetNamespaceId)) {
                throw new FunctionCallFailedException(DispatchToNamespaceUtility.class.toString(), "provider returned credential with namespace unequal to namespace requested");
            }
        }
        return new CredentialImpl(credElement);
    }

    public static void logoff(Visa visa, String targetNamespaceId, MessageContext context) throws SoapFaultException {
        MessageContext newContext = context.createMessageContextForNewRequest(LOGOFF_REQUEST);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)targetNamespaceId);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa", (Object)visa);
        if (context.containsKey((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT)) {
            newContext.put((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT, context.get((Object)MessageContextImpl.PASSPORT_EXPIRED_EVENT));
        }
        DispatchToNamespaceUtility.dispatchToNamespace(newContext, "logoffNamespaces");
    }

    public static Visa logonTC(Credential trustedCredential, String targetNamespaceId, MessageContext context) throws SoapFaultException {
        String logonTCRequest = DispatchToNamespaceUtility.createRequestBody("<bus:logonTC/>");
        MessageContext newContext = context.createMessageContextForNewRequest(logonTCRequest);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)targetNamespaceId);
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)new Credential[]{trustedCredential});
        newContext.put((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted", (Object)new Boolean(true));
        DispatchToNamespaceUtility.dispatchToNamespace(newContext, dispatchHandler);
        return (Visa)newContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.visa");
    }
}

