/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.auth.soap.GenerateTCResponse;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeResponse;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class GenerateTCForAuthenticatedNamespaces
extends DefaultHandler {
    private ICMAccessor cmAccessor;
    private EncryptingSession session;
    private Element body;

    private void generateTC(String camId, SoapEnvelopeRequest request, String credentialString, String credentialPath) throws InternalErrorException {
        try {
            Element oldBody;
            byte[] encryptedTCBytes = this.session.encryptData(credentialString.getBytes("UTF-8"));
            String encryptedTC = base64.encode((int)0, (byte[])encryptedTCBytes);
            Element soapEnv = null;
            if (request instanceof SoapEnvelopeRequestImpl) {
                soapEnv = ((SoapEnvelopeRequestImpl)request).getElement().createCopy();
            }
            if ((oldBody = (Element)soapEnv.selectSingleNode("./*[local-name()='Body']")) != null) {
                soapEnv.remove(oldBody);
            }
            soapEnv.add(this.body.createCopy());
            Element search = (Element)soapEnv.selectSingleNode("./*[local-name()='Body']/*[local-name()='add']/*[local-name()='search']");
            search.setText(camId);
            Element value = (Element)soapEnv.selectSingleNode("./*[local-name()='Body']/*[local-name()='add']/*[local-name()='objects']/*[local-name()='item']/*[local-name()='credentials']/*[local-name()='value']");
            value.setText("<credential><encryptedValue>" + encryptedTC + "</encryptedValue></credential>");
            String xmlResponse = this.cmAccessor.invoke(soapEnv.asXML());
            SAXReader xmlReader = new SAXReader();
            Document doc = xmlReader.read((Reader)new StringReader(xmlResponse));
            Element fault = (Element)doc.getRootElement().selectSingleNode("./*[local-name()='Body']/*[local-name()='Fault']");
            if (fault != null) {
                throw new RuntimeException(fault.asXML());
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(GenerateTCForAuthenticatedNamespaces.class.toString(), e);
        }
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        String credentialString = new String();
        SoapEnvelopeRequest request = (SoapEnvelopeRequest)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapEnvelopeResponse response = (SoapEnvelopeResponse)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapResponse");
        Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
        String primaryNsId = passport.getPrimaryNsID();
        InternalVisa visa = passport.getInternalVisa(primaryNsId);
        String camid = visa.getCAMID();
        String credentialPath = camid + "/credential";
        Set<String> authenticatedNSIds = passport.getAuthenticatedNamespaceIDs();
        for (String nsId : authenticatedNSIds) {
            if (!nsId.equals("")) continue;
            credentialPath = "CAMID(\"::Anonymous\")/credential";
            credentialString = credentialString + "<credential><namespace></namespace><username></username><password></password></credential>";
        }
        this.generateTC(camid, request, credentialString, credentialPath);
        GenerateTCResponse generateTCResponse = (GenerateTCResponse)response.getBody().getBodyEntry();
        generateTCResponse.setCredentialPath(credentialPath);
        return true;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.cmAccessor = CMAccessor.getInstance();
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(GenerateTCForAuthenticatedNamespaces.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
        StringBuffer update = new StringBuffer();
        update.append("<SOAP-ENV:Body xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\">");
        update.append("<bus:add><search xsi:type=\"xsd:string\">CAMID(\"::Anonymous\")</search>");
        update.append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">");
        update.append("<item xsi:type=\"bus:credential\">");
        update.append("<credentials xsi:type=\"bus:anyTypeProp\">");
        update.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">&lt;credential&gt;&lt;encryptedValue&gt;");
        update.append("encryptedTCString");
        update.append("&lt;/encryptedValue&gt;&lt;/credential&gt;</value></credentials></item></objects>");
        update.append("<options xsi:type=\"bus:addOptions\"><updateAction xsi:type=\"bus:updateActionEnum\">update</updateAction></options>");
        update.append("</bus:add></SOAP-ENV:Body>");
        SAXReader xmlReader = new SAXReader();
        try {
            Document doc = xmlReader.read((Reader)new StringReader(update.toString()));
            this.body = doc.getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException("Cannot read soap body for adding an object");
        }
    }
}

