/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.CredentialImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonTCRequest;
import com.ibm.cognos.camaaa.internal.common.exception.FunctionCallFailedException;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.CMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.ICMAccessor;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequestImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class GetCredentialsFromTC
extends DefaultHandler {
    private static final String ITEM = "item";
    private ICMAccessor cmAccessor;
    private EncryptingSession session;

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        Credential[] credentials;
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        SoapEnvelope request = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        boolean retval = false;
        if (outboundDirection) {
            if (request.getHeader() != null && request.getHeader().getBiBusHeader() != null && request.getHeader().getBiBusHeader().getCAMPassportID() != null) {
                throw new RuntimeException("A logonTC cannot contain a passportID in the header.");
            }
            throw new RuntimeException("Cannot find trusted credentials.");
        }
        if (request.getHeader() != null && request.getHeader().getBiBusHeader() != null && request.getHeader().getBiBusHeader().getCAMPassportID() == null && (credentials = this.retrieveCredentials(request)) != null) {
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials", (Object)credentials);
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.auth.soap.credential.trusted", (Object)Boolean.TRUE);
            retval = true;
        }
        return retval;
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        this.cmAccessor = CMAccessor.getInstance();
        CAMFactory camf = (CAMFactory)theConfig.get((Object)"com.cognos.accman.jcam.crypto.CAMFactory");
        try {
            this.session = camf.createEncryptingSession();
        }
        catch (CAMCryptoException e) {
            throw new FunctionCallFailedException(GetCredentialsFromTC.class.toString(), "CAMFactory.createEncryptingSession", (Exception)((Object)e));
        }
    }

    private List queryCmForCredentials(SoapEnvelope request) throws InternalErrorException {
        LogonTCRequest logonTCRequest = (LogonTCRequest)request.getBody().getBodyEntry();
        String[] credentialPaths = logonTCRequest.getCredentialPath();
        Element cmRequest = ((SoapEnvelopeRequestImpl)request).getElement().createCopy();
        Element camProtect = (Element)DocumentHelper.selectSingleNode((String)"./SOAP-ENV:Header/bus:biBusHeader/*[local-name()='CAMProtect']", (Node)cmRequest);
        Element body = (Element)DocumentHelper.selectSingleNode((String)"./SOAP-ENV:Body", (Node)cmRequest);
        if (camProtect != null) {
            camProtect.getParent().remove(camProtect);
        }
        cmRequest.remove(body);
        body = cmRequest.addElement(QName.get((String)"Body", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
        body.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        body.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        body.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        Element query = body.addElement("bus:query");
        Element requests = query.addElement("requests");
        for (int i = 0; i < credentialPaths.length; ++i) {
            Element item = requests.addElement(ITEM);
            Element search = item.addElement("search");
            Element properties = item.addElement("properties");
            Element itemProp = properties.addElement(ITEM);
            itemProp.addText("credentials");
            search.setText(credentialPaths[i]);
        }
        List values = null;
        SAXReader reader = new SAXReader();
        try {
            String xmlResponse = this.cmAccessor.invoke(cmRequest.asXML());
            Document doc = reader.read((Reader)new StringReader(xmlResponse));
            values = DocumentHelper.selectNodes((String)"/SOAP-ENV:Envelope/SOAP-ENV:Body/bus:queryResponse/*/*/*/*/*[local-name()='credentials']/*[local-name()='value']", (Node)doc.getRootElement());
            if (values.size() == 0 || values.size() != credentialPaths.length) {
                values = null;
            }
        }
        catch (SoapFaultException e) {
            throw new InternalErrorException(GetCredentialsFromTC.class.toString(), (Exception)((Object)e));
        }
        catch (DocumentException e) {
            throw new InternalErrorException(GetCredentialsFromTC.class.toString(), (Exception)((Object)e));
        }
        return values;
    }

    private Credential[] retrieveCredentials(SoapEnvelope request) throws InternalErrorException {
        LogonTCRequest logonTCRequest = (LogonTCRequest)request.getBody().getBodyEntry();
        String[] credentialPaths = logonTCRequest.getCredentialPath();
        CredentialImpl[] credentials = null;
        List values = this.queryCmForCredentials(request);
        if (values != null) {
            credentials = new CredentialImpl[credentialPaths.length];
            for (int i = 0; i < values.size(); ++i) {
                String encryptedValue = null;
                String value = ((Element)values.get(i)).getStringValue();
                if (value.length() == 0) {
                    throw new RuntimeException("Invalid credential value");
                }
                SAXReader reader = null;
                try {
                    reader = new SAXReader();
                    Document doc = reader.read((Reader)new StringReader(value));
                    encryptedValue = DocumentHelper.valueOf((String)"/*[local-name()='credential']/*[local-name()='encryptedValue']", (Node)doc.getRootElement());
                    byte[] decodedValue = base64.decode((int)0, (String)encryptedValue);
                    String decryptedValue = new String(this.session.decryptData(decodedValue));
                    doc = reader.read((Reader)new StringReader(decryptedValue));
                    credentials[i] = new CredentialImpl(doc.getRootElement());
                    continue;
                }
                catch (DocumentException e) {
                    throw new InternalErrorException(GetCredentialsFromTC.class.toString(), (Exception)((Object)e));
                }
                catch (CAMCryptoException e) {
                    throw new InternalErrorException(GetCredentialsFromTC.class.toString(), (Exception)((Object)e));
                }
            }
        }
        return credentials;
    }
}

