/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.InvalidNamespaceSelectionException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.auth.soap.LogonRequest;
import com.ibm.cognos.camaaa.internal.auth.soap.RenewTCRequest;
import com.ibm.cognos.camaaa.internal.auth.soap.RetrieveCredentialRequest;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import java.util.Set;

public class GetNamespaceFromBody
extends DefaultHandler {
    private static final String CAM_NAMESPACE = "CAMNamespace";

    private String getNSFromCredential(SoapEnvelope envelope, Set<String> availableNS, Credential[] credentials) {
        String targetNS = null;
        try {
            targetNS = credentials[0].getCredentialValue("namespace");
            if (targetNS != null && availableNS.contains(targetNS)) {
                BiBusHeader biBusHeader = envelope.getHeader().getBiBusHeader();
                biBusHeader.consumeFormField(CAM_NAMESPACE);
            }
        }
        catch (LocalizableException localizableException) {
            // empty catch block
        }
        return targetNS;
    }

    private String getTargetNamespace(SoapEnvelope envelope, Set<String> availableNS) throws InvalidNamespaceSelectionException {
        String targetNS = null;
        SoapBodyEntry bodyEntry = envelope.getBody().getBodyEntry();
        int type = bodyEntry.getType();
        switch (type) {
            case 2: {
                LogonRequest request = (LogonRequest)bodyEntry;
                Credential[] credentials = request.getCredentials();
                if (credentials == null) break;
                if (credentials.length != 1) {
                    throw new InvalidNamespaceSelectionException(GetNamespaceFromBody.class.getName());
                }
                targetNS = this.getNSFromCredential(envelope, availableNS, credentials);
                break;
            }
            case 6: {
                RetrieveCredentialRequest req = (RetrieveCredentialRequest)bodyEntry;
                targetNS = req.getNamespaceID();
                if (targetNS != null) break;
                throw new InvalidNamespaceSelectionException(GetNamespaceFromBody.class.toString());
            }
            case 24: {
                RenewTCRequest renewReqest = (RenewTCRequest)bodyEntry;
                targetNS = renewReqest.getNamespaceId();
                if (targetNS != null) break;
                throw new InvalidNamespaceSelectionException(GetNamespaceFromBody.class.toString());
            }
        }
        return targetNS;
    }

    @Override
    public boolean handleMessage(MessageContext theContext) throws SoapFaultException {
        boolean retval;
        Set availableNS;
        boolean outboundDirection = (Boolean)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.outbound");
        if (outboundDirection) {
            return true;
        }
        SoapEnvelope envelope = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        String targetNS = this.getTargetNamespace(envelope, availableNS = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.availableNamespaces"));
        if (targetNS == null) {
            retval = false;
        } else {
            if (!availableNS.contains(targetNS)) {
                throw new InvalidNamespaceSelectionException(GetNamespaceFromBody.class.toString());
            }
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)targetNS);
            retval = true;
        }
        return retval;
    }
}

