/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.exception.InvalidNamespaceSelectionException;
import com.ibm.cognos.camaaa.internal.auth.soap.Credential;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusHeader;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelope;
import java.util.Set;

public class GetNamespaceFromCredential
extends DefaultHandler {
    private static final String CAM_NAMESPACE = "CAMNamespace";

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        boolean retval = false;
        Credential[] credentials = (Credential[])theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.credentials");
        if (credentials == null || credentials.length == 0) {
            return false;
        }
        if (credentials.length > 1) {
            throw new RuntimeException("Can't have more then one credential at this stage of the request.");
        }
        Credential credential = credentials[0];
        String namespaceId = null;
        try {
            namespaceId = credential.getCredentialValue("namespace");
        }
        catch (LocalizableException e) {
            throw new InternalErrorException(GetNamespaceFromCredential.class.toString(), (Exception)((Object)e));
        }
        if (namespaceId != null) {
            Set availableNS = (Set)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.availableNamespaces");
            if (!availableNS.contains(namespaceId)) {
                throw new InvalidNamespaceSelectionException(GetNamespaceFromCredential.class.toString());
            }
            theContext.put((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace", (Object)namespaceId);
            SoapEnvelope soapRequest = (SoapEnvelope)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
            BiBusHeader biBusHeader = soapRequest.getHeader().getBiBusHeader();
            biBusHeader.consumeFormField(CAM_NAMESPACE);
            retval = true;
        }
        return retval;
    }
}

