/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.auth.handler;

import com.ibm.cognos.camaaa.internal.auth.InternalVisa;
import com.ibm.cognos.camaaa.internal.auth.Passport;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.exception.SoapFaultException;
import com.ibm.cognos.camaaa.internal.common.handler.DefaultHandler;
import com.ibm.cognos.camaaa.internal.common.handler.HandlerInfo;
import com.ibm.cognos.camaaa.internal.common.handler.MessageContext;
import com.ibm.cognos.camaaa.internal.common.soap.SoapBodyEntry;
import com.ibm.cognos.camaaa.internal.common.soap.SoapEnvelopeRequest;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class HasRecentlyRenewedTC
extends DefaultHandler {
    private static final int DEFAULT_EXPIRY_DAYS_1 = 1;
    private static final int DEFAULT_MAX_ENTRIES_500 = 500;
    private static final String ADVANCED_PROPERTIED = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']";
    private static final String MAX_ENTRIES = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"maxEntriesRenewedTC\"]/*[local-name()='value']/text()";
    private static final String EXPIRY = "./*[local-name()='parameter'][@name=\"advancedProperties\"]/*[local-name()='value']/*[local-name()='parameter'][@name=\"expiryRenewedTC\"]/*[local-name()='value']/text()";
    private static final long MILLI_SECONDS_PER_DAY = 86400000L;
    private LimitedMap map;
    private long expiry;

    @Override
    protected boolean handleInboundRequest(MessageContext theContext) throws SoapFaultException {
        if (this.map.limit == 0) {
            return false;
        }
        boolean ret = true;
        SoapEnvelopeRequest requestEnv = (SoapEnvelopeRequest)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.soapRequest");
        SoapBodyEntry entry = requestEnv.getBody().getBodyEntry();
        if (entry != null && 2 == entry.getType()) {
            Passport passport = (Passport)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.passport");
            String primaryNsId = passport.getPrimaryNsID();
            String targetNS = (String)theContext.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.message.targetNamespace");
            if (primaryNsId != null && !primaryNsId.equals("") && targetNS != null && !targetNS.equals("")) {
                InternalVisa visa = passport.getInternalVisa(primaryNsId);
                String camId = visa.getCAMID();
                ret = this.hasRecentlyRenewedTC(camId, targetNS);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRecentlyRenewedTC(String camId, String targetNS) {
        String key = camId + "/" + targetNS;
        LimitedMap limitedMap = this.map;
        synchronized (limitedMap) {
            Date lastRenewTC = (Date)this.map.get(key);
            if (lastRenewTC == null) {
                this.map.put(key, new Date());
            } else if (lastRenewTC.getTime() + this.expiry < System.currentTimeMillis()) {
                this.map.put(key, new Date());
            } else {
                return true;
            }
            return false;
        }
    }

    @Override
    public void init(HandlerInfo theConfig) throws LocalizableException {
        Configuration config = (Configuration)theConfig.get((Object)"com.ibm.cognos.camaaa.internal.common.handler.init.configuration");
        String limitString = config.getOptionalValue(MAX_ENTRIES, String.valueOf(500));
        String expiryString = config.getOptionalValue(EXPIRY, String.valueOf(1));
        int limit = 500;
        int days = 1;
        if (limitString != null) {
            try {
                int tempLimit = Integer.parseInt(limitString);
                if (tempLimit >= 0) {
                    limit = tempLimit;
                }
            }
            catch (NumberFormatException tempLimit) {
                // empty catch block
            }
        }
        if (expiryString != null) {
            try {
                int tempDays = Integer.parseInt(expiryString);
                if (tempDays >= 0) {
                    days = tempDays;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.map = new LimitedMap(limit);
        this.expiry = (long)days * 86400000L;
    }

    private class LimitedMap
    extends LinkedHashMap<String, Date> {
        private static final long serialVersionUID = 1553279977427763101L;
        private final int limit;

        LimitedMap(int theLimit) {
            this.limit = theLimit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > this.limit;
        }
    }
}

